/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.resource.systemresource;

import com.wily.util.resource.systemresource.InvalidSystemResourceException;
import com.wily.util.text.FormattedLocalizableMessage;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public class SystemResource {
    private static final String kSeparator = "/";
    private static final String kEmptyString = "";
    private static final char[] kValidResourceChars = new char[]{'.', '-'};
    private boolean fIsAbsolute = false;
    private final Vector<String> fPackages = new Vector();
    private String fName = null;

    public SystemResource(String name, boolean shouldVerifyResource) throws InvalidSystemResourceException {
        this(null, name, shouldVerifyResource);
    }

    public SystemResource(SystemResource resource, String name, boolean shouldVerifyResource) throws InvalidSystemResourceException {
        this.parse(name);
        this.makeRelativeToResource(resource);
        if (shouldVerifyResource) {
            this.verifyResource();
        }
    }

    private void verifyResource() throws InvalidSystemResourceException {
        if (ClassLoader.getSystemResource(this.getRelativeResource()) == null) {
            throw new InvalidSystemResourceException(new FormattedLocalizableMessage("Invalid_System_Resource_Element_Key", this.getRelativeResource()));
        }
    }

    private void parse(String name) throws InvalidSystemResourceException {
        if (name == null) {
            name = kEmptyString;
        }
        boolean isFirstToken = true;
        boolean lastWasDelimiter = false;
        StringTokenizer tokenizer = new StringTokenizer(name, kSeparator, true);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            boolean tokenIsDelimiter = token.equals(kSeparator);
            if (tokenIsDelimiter) {
                if (isFirstToken) {
                    this.setAbsolute(true);
                }
                if (lastWasDelimiter) {
                    this.addPackage(kEmptyString);
                }
            } else if (tokenizer.hasMoreTokens()) {
                this.addPackage(token);
            } else {
                this.setName(token);
            }
            isFirstToken = false;
            lastWasDelimiter = tokenIsDelimiter;
        }
    }

    private void makeRelativeToResource(SystemResource resource) {
        if (resource != null && !this.isAbsolute()) {
            Enumeration<String> packages = resource.fPackages.elements();
            int index = 0;
            while (packages.hasMoreElements()) {
                String pkg = packages.nextElement();
                this.fPackages.insertElementAt(pkg, index++);
            }
            this.setAbsolute(resource.isAbsolute());
        }
    }

    private void setAbsolute(boolean absolute) {
        this.fIsAbsolute = absolute;
    }

    public boolean isAbsolute() {
        return this.fIsAbsolute;
    }

    public int getNumPackages() {
        return this.fPackages.size();
    }

    public String getPackage(int index) {
        if (index < 0 || index >= this.fPackages.size()) {
            throw new IllegalArgumentException();
        }
        return this.fPackages.elementAt(index);
    }

    private void addPackage(String pkg) throws InvalidSystemResourceException {
        if (!this.isValidJavaIdentifier(pkg)) {
            throw new InvalidSystemResourceException(new FormattedLocalizableMessage("Invalid_System_Resource_Element_Key", pkg));
        }
        this.fPackages.addElement(pkg);
    }

    private boolean isValidJavaIdentifier(String value) {
        if (value == null || value.length() == 0) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(value.charAt(0))) {
            return false;
        }
        int i = 1;
        while (i < value.length()) {
            if (!Character.isJavaIdentifierPart(value.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String getName() {
        return this.fName;
    }

    private void setName(String name) throws InvalidSystemResourceException {
        if (!this.isValidResourceName(name)) {
            throw new InvalidSystemResourceException(new FormattedLocalizableMessage("Invalid_System_Resource_Element_Key", name));
        }
        this.fName = name;
    }

    private boolean isValidResourceName(String name) {
        if (name == null || name.length() == 0) {
            return false;
        }
        int i = 0;
        while (i < name.length()) {
            if (!this.isValidResourceCharacter(name.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean isValidResourceCharacter(char ch) {
        if (Character.isJavaIdentifierPart(ch)) {
            return true;
        }
        int i = 0;
        while (i < kValidResourceChars.length) {
            if (ch == kValidResourceChars[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public InputStream getInputStream() {
        return ClassLoader.getSystemResourceAsStream(this.getRelativeResource());
    }

    public URL getURL() {
        return ClassLoader.getSystemResource(this.getRelativeResource());
    }

    public String getRelativeResource() {
        StringBuilder buf = new StringBuilder();
        Enumeration<String> packages = this.fPackages.elements();
        while (packages.hasMoreElements()) {
            String pkg = packages.nextElement();
            buf.append(pkg);
            buf.append(kSeparator);
        }
        if (this.fName != null) {
            buf.append(this.fName);
        }
        return buf.toString();
    }

    public String toString() {
        if (this.isAbsolute()) {
            StringBuilder buf = new StringBuilder();
            buf.append(kSeparator);
            buf.append(this.getRelativeResource());
            return buf.toString();
        }
        return this.getRelativeResource();
    }
}

