/*
 * Decompiled with CFR 0.152.
 */
package com.wily.diagnos.personality.java.classfile.attributes;

import com.wily.diagnos.personality.java.classfile.attributes.DGAttribute;
import com.wily.diagnos.personality.java.classfile.constants.DGConstantPool;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;

public class DGExceptionsAttribute
extends DGAttribute {
    public static final String kExceptionsAttributeName = "Exceptions";
    private DGConstantPool fConstantPool;
    private int[] fCPI_Exceptions;

    public DGExceptionsAttribute(DGConstantPool constantPool, int nameIndex, String name, byte[] data) throws IOException {
        super(nameIndex, name, data);
        this.fConstantPool = constantPool;
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(data));
        int numExceptions = in.readUnsignedShort();
        this.fCPI_Exceptions = new int[numExceptions];
        for (int i = 0; i < numExceptions; ++i) {
            this.fCPI_Exceptions[i] = in.readUnsignedShort();
        }
    }

    public boolean contains(String exception) {
        for (int i = 0; i < this.fCPI_Exceptions.length; ++i) {
            if (!this.fConstantPool.getClassName(this.fCPI_Exceptions[i]).equals(exception)) continue;
            return true;
        }
        return false;
    }

    public String[] getExceptionTypes() {
        String[] exceptions = new String[this.fCPI_Exceptions.length];
        for (int i = 0; i < this.fCPI_Exceptions.length; ++i) {
            exceptions[i] = this.fConstantPool.getClassName(this.fCPI_Exceptions[i]);
        }
        return exceptions;
    }
}

