/*
 * Decompiled with CFR 0.152.
 */
package com.wily.diagnos.personality.java.classfile.attributes;

import com.wily.diagnos.personality.java.classfile.attributes.DGAttribute;
import com.wily.wilyassert.Assertion;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

class DGLineNumberTable
extends DGAttribute {
    public static final String kLineNumberTableName = "LineNumberTable";
    private int[] fStartPCs;
    private final int[] fLineNumbers;
    private boolean fDirty;

    public DGLineNumberTable(int nameIndex, String name, byte[] data) throws IOException {
        super(nameIndex, name, data);
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(data));
        int tableLength = in.readUnsignedShort();
        this.fStartPCs = new int[tableLength];
        this.fLineNumbers = new int[tableLength];
        for (int i = 0; i < tableLength; ++i) {
            this.fStartPCs[i] = in.readUnsignedShort();
            this.fLineNumbers[i] = in.readUnsignedShort();
        }
    }

    @Override
    public void write(DataOutputStream out) throws IOException {
        if (!this.fDirty) {
            super.write(out);
            return;
        }
        out.writeShort(this.fCPI_name);
        out.writeInt(this.fAttribData.length);
        out.writeShort(this.fStartPCs.length);
        Assertion.wilyAssert((boolean)false);
        for (int i = 0; i < this.fStartPCs.length; ++i) {
            out.writeShort(this.fStartPCs[i]);
            out.writeShort(this.fLineNumbers[i]);
        }
    }

    public int findLineNumber(int pc) {
        if (this.fLineNumbers.length == 0) {
            return 0;
        }
        for (int i = 0; i < this.fLineNumbers.length; ++i) {
            if (this.fStartPCs[i] < pc) continue;
            return this.fLineNumbers[i];
        }
        return this.fLineNumbers[this.fLineNumbers.length - 1];
    }

    public void insertCode(int pc, int length) {
        for (int i = 0; i < this.fLineNumbers.length; ++i) {
            if (this.fStartPCs[i] < pc) continue;
            int n = i;
            this.fStartPCs[n] = this.fStartPCs[n] + length;
            this.fDirty = true;
        }
    }
}

