/*
 * Decompiled with CFR 0.152.
 */
package com.wily.diagnos.personality.java.classfile.attributes.annotations;

import com.wily.diagnos.cmp.directives.utility.CompilerSettingsUtility;
import com.wily.diagnos.personality.java.classfile.attributes.DGAttribute;
import com.wily.diagnos.personality.java.classfile.attributes.annotations.DGAnnotation;
import com.wily.diagnos.personality.java.classfile.attributes.annotations.IAnnotationAttribute;
import com.wily.diagnos.personality.java.classfile.constants.DGConstantPool;
import com.wily.util.classfile.IClassName;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class DGRuntimeAnnotationAttribute
extends DGAttribute
implements IAnnotationAttribute {
    private List fAnnotationList;
    DGConstantPool fConstantPool;

    public DGRuntimeAnnotationAttribute(DGConstantPool constantPool, int nameIndex, String name, byte[] data) throws IOException {
        super(nameIndex, name, data);
        this.fConstantPool = constantPool;
        this.fAnnotationList = new ArrayList();
        this.loadData(data);
    }

    public void loadData(byte[] data) throws IOException {
        FilterInputStream input = null;
        try {
            input = new DataInputStream(new ByteArrayInputStream(data));
            this.loadData((DataInputStream)input);
        }
        finally {
            if (input != null) {
                input.close();
            }
        }
    }

    public int getNumberOfAnnotations() {
        return this.fAnnotationList.size();
    }

    private void loadData(DataInputStream input) throws IOException {
        short numberOfAnnotations = input.readShort();
        for (short i = 0; i < numberOfAnnotations; i = (short)(i + 1)) {
            DGAnnotation annotation = new DGAnnotation(input, this.fConstantPool);
            this.fAnnotationList.add(annotation);
        }
    }

    @Override
    public boolean containsAnnotation(IClassName annotationName) {
        for (int i = 0; i < this.fAnnotationList.size(); ++i) {
            DGAnnotation annotation = (DGAnnotation)this.fAnnotationList.get(i);
            if (!annotation.getAnnotationClassName().equals(annotationName.getReflectionFriendlyQualifiedNameString())) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<DGAnnotation> getDeclaredAnnotations() {
        return new ArrayList<DGAnnotation>(this.fAnnotationList);
    }

    public boolean isInvisible() {
        return this.getName().equals("RuntimeInvisibleParameterAnnotations");
    }

    @Override
    public String[] getPossibleKeys() {
        String[] result = new String[this.fAnnotationList.size()];
        for (int i = 0; i < this.fAnnotationList.size(); ++i) {
            DGAnnotation annotation = (DGAnnotation)this.fAnnotationList.get(i);
            String fAnnotationClassName = annotation.getAnnotationClassName();
            result[i] = CompilerSettingsUtility.getKeyFromString(fAnnotationClassName);
        }
        return result;
    }
}

