/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.autoprobe;

import com.wily.diagnos.cmp.directives.DGCompilerSettings;
import com.wily.diagnos.cmp.directives.FlagName;
import com.wily.diagnos.cmp.directives.TracerGroup;
import com.wily.diagnos.cmp.directives.builder.CompilerSettingsBuilder;
import com.wily.diagnos.cmp.directives.builder.TracerGroupBuilder;
import com.wily.diagnos.cmp.directives.parser.DGInvalidFlagNameException;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.IOverheadManager;
import com.wily.introscope.agent.transformer.dynamic.IDirectiveLoadListener;
import com.wily.introscope.agent.transformer.dynamic.IOverheadHandler;
import com.wily.introscope.agent.transformer.dynamic.OverheadAdministrator;
import com.wily.introscope.agent.transformer.dynamic.OverheadMode;
import com.wily.introscope.agent.transformer.dynamic.OverheadSettings;
import com.wily.introscope.autoprobe.AbsoluteLowModeOverheadHandler;
import com.wily.introscope.autoprobe.NormalModeOverheadHandler;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.properties.IndexedProperties;
import java.util.Map;

public class OverheadManagementHelper
implements IDirectiveLoadListener {
    private IAgent fAgent;
    private IModuleFeedbackChannel fFeedback;
    private Module kModule = new Module("OverheadManagement");
    private final IOverheadManager fOverheadManager;
    public static final String AGENT_OBVERHEAD_CONTROL_KEY = "introscope.agent.overhead.level";
    private static volatile boolean defaultSettingsInitialized = false;
    private static volatile String overheadModeAsString;

    public OverheadManagementHelper(IAgent agent) {
        this.fAgent = agent;
        this.fFeedback = agent.IAgent_getModuleFeedback();
        this.fOverheadManager = this.fAgent.IAgent_getOverheadManager();
        OverheadSettings.setInitialAgentProperties((IndexedProperties)agent.IAgent_getIndexedProperties());
        OverheadSettings.registerOverheadHandler((OverheadMode)OverheadMode.ABSOLUTE_LOW, (IOverheadHandler)new AbsoluteLowModeOverheadHandler());
        OverheadSettings.registerOverheadHandler((OverheadMode)OverheadMode.LOW_WITH_ONLY_FRONTEND_BACKEND, (IOverheadHandler)new AbsoluteLowModeOverheadHandler());
        OverheadSettings.registerOverheadHandler((OverheadMode)OverheadMode.DEFAULT, (IOverheadHandler)new NormalModeOverheadHandler());
    }

    public void updateTracerGroupBuilders(CompilerSettingsBuilder builder) {
        Map overheadMap;
        block11: {
            OverheadMode overheadMode;
            block12: {
                overheadMode = OverheadAdministrator.getOverheadMode();
                if (overheadMode == null) {
                    return;
                }
                overheadModeAsString = OverheadAdministrator.getDisplayValue((OverheadMode)OverheadAdministrator.getOverheadMode());
                if (overheadMode == null) break block11;
                if (overheadMode == OverheadMode.LOW_WITH_ONLY_FRONTEND_BACKEND || OverheadMode.ABSOLUTE_LOW == overheadMode) break block12;
                if (OverheadMode.DEFAULT != overheadMode) break block11;
            }
            overheadMode.getOverheadSettings();
            IOverheadHandler overheadHandler = OverheadSettings.getOverheadHandler((OverheadMode)overheadMode);
            if (overheadHandler != null) {
                overheadHandler.setCompilerSettingsBuilder((Object)builder);
                overheadHandler.controlOverhead(overheadMode.getOverheadSettings());
                return;
            }
        }
        if (this.fOverheadManager != null && (overheadMap = this.fOverheadManager.getTracerGroupMap()) != null) {
            for (String tracerGroupName : overheadMap.keySet()) {
                try {
                    FlagName fn = FlagName.getFlagName(tracerGroupName);
                    TracerGroupBuilder tg = builder.findTracerGroupBuilder(fn);
                    if (tg == null) {
                        this.fFeedback.error(this.kModule, "Unknown tracer group: " + tracerGroupName);
                        continue;
                    }
                    if (!tg.isChangeable() || OverheadSettings.isUnchangeable((String)tg.getName().getName())) {
                        this.fFeedback.warn(this.kModule, "Changing tracer group: " + tracerGroupName + " requires agent restart.");
                        continue;
                    }
                    Boolean b = (Boolean)overheadMap.get(tracerGroupName);
                    this.fFeedback.trace(this.kModule, "Inspecting tracer group: " + tg.getName().toString() + " isChangeable =  " + tg.isChangeable());
                    if (b == null) continue;
                    tg.setEnabled(b);
                    this.fFeedback.debug(this.kModule, "Setting tracer group: " + tg.getName().toString() + " isEnabled = " + b);
                }
                catch (DGInvalidFlagNameException e) {
                    this.fFeedback.error(this.kModule, "Invalid tracer group: " + tracerGroupName);
                }
            }
        }
    }

    public void notifyDirectivesLoaded(Object dgCompilerSettigs) {
        Map overheadMap;
        Map groups;
        DGCompilerSettings s;
        if (dgCompilerSettigs instanceof DGCompilerSettings) {
            if (!defaultSettingsInitialized) {
                DGCompilerSettings dGCompilerSettings = (DGCompilerSettings)dgCompilerSettigs;
            }
            if (OverheadAdministrator.getOverheadMode() == null || OverheadMode.DEFAULT == OverheadAdministrator.getOverheadMode()) {
                return;
            }
            s = (DGCompilerSettings)dgCompilerSettigs;
            groups = s.getGroupInstrumentableMap();
            OverheadMode overheadMode = OverheadAdministrator.getOverheadMode();
            if (overheadMode != null && (overheadMode == OverheadMode.LOW_WITH_ONLY_FRONTEND_BACKEND || OverheadMode.ABSOLUTE_LOW == overheadMode)) {
                overheadMode.getOverheadSettings();
                IOverheadHandler overheadHandler = OverheadSettings.getOverheadHandler((OverheadMode)overheadMode);
                if (overheadHandler != null) {
                    overheadHandler.controlOverhead(overheadMode.getOverheadSettings());
                    return;
                }
            }
        }
        s = (DGCompilerSettings)dgCompilerSettigs;
        groups = s.getGroupInstrumentableMap();
        if (this.fOverheadManager != null && (overheadMap = this.fOverheadManager.getTracerGroupMap()) != null) {
            for (TracerGroup tg : groups.keySet()) {
                Boolean instrumentable = (Boolean)groups.get(tg);
                Boolean b = (Boolean)overheadMap.get(tg.getName().toString());
                this.fFeedback.trace(this.kModule, "Inspecting tracer group: " + tg.toString() + ", instrumentable = " + instrumentable.toString() + " isLockedDisabled =  " + tg.isLockedDisabled() + " isChangeable  =" + tg.isChangeable());
                if (b == null) continue;
                tg.setEnabled(b);
                this.fFeedback.info(this.kModule, "Setting tracer group: " + tg.toString() + " isEnabled = " + b);
            }
        }
    }

    public void notifyRedefinitionComplete() {
    }

    public static String getOverheadMode() {
        return overheadModeAsString;
    }
}

