/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.probebuilder;

import com.wily.diagnos.cmp.DGCompilationFailedException;
import com.wily.diagnos.cmp.DGVersion;
import com.wily.diagnos.cmp.batch.CompilerEnvironment;
import com.wily.diagnos.cmp.batch.DGFileSettings;
import com.wily.diagnos.cmp.batch.IBatchCompiler;
import com.wily.diagnos.cmp.classfile.DGClassException;
import com.wily.diagnos.cmp.directives.DGCompilerSettings;
import com.wily.diagnos.cmp.directives.DirectivesException;
import com.wily.diagnos.cmp.directives.DirectivesFile;
import com.wily.diagnos.cmp.directives.DirectivesFileList;
import com.wily.diagnos.cmp.directives.builder.CompilerSettingsBuilder;
import com.wily.diagnos.cmp.directives.parser.DGParserException;
import com.wily.diagnos.cmp.log.DGCompilerLog;
import com.wily.diagnos.cmp.log.ICompilerLog;
import com.wily.diagnos.cmp.log.ISummaryInfo;
import com.wily.diagnos.cmp.log.NullCompilerLog;
import com.wily.diagnos.cmp.log.SummaryLog;
import com.wily.diagnos.personality.ICompilerPersonality;
import com.wily.diagnos.personality.NativePersonality;
import com.wily.introscope.etc.AIntroscopeApplication;
import com.wily.introscope.install.IntroscopeVersion;
import com.wily.introscope.probebuilder.AProbeBuilderCommandLine;
import com.wily.introscope.probebuilder.InternalDirectivesLoader;
import com.wily.introscope.probebuilder.NativeProbeBuilderCommandLineFactory;
import com.wily.introscope.probebuilder.ProbeBuilderUI;
import com.wily.util.clock.MasterClock;
import com.wily.util.commandline.ParsingException;
import com.wily.util.feedback.ApplicationFeedback;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.io.ExtendedFile;
import com.wily.util.text.ILocalizableMessage;
import com.wily.util.text.IStringLocalizer;
import com.wily.util.text.MultipleResourceBundleStringLocalizer;
import com.wily.util.text.SimpleLocalizableMessage;
import com.wily.util.validate.ValidationException;
import com.wily.util.version.IVersion;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;

public class ProbeBuilder
extends AIntroscopeApplication {
    private static final String kProbeBuilderErrorPrefix = "ProbeBuilder error: ";
    private final AProbeBuilderCommandLine fCommands;
    private final PrintWriter fOutputWriter;
    private final PrintWriter fErrorWriter;

    public static void main(String[] args) {
        PrintWriter outputWrapper = new PrintWriter(System.out, true);
        PrintWriter errorWrapper = new PrintWriter(System.err, true);
        try {
            ApplicationFeedback feedback = null;
            MultipleResourceBundleStringLocalizer localizer = null;
            try {
                feedback = new ApplicationFeedback("ProbeBuilder", false);
                localizer = new MultipleResourceBundleStringLocalizer((IModuleFeedbackChannel)feedback, ProbeBuilder.class.getClassLoader(), new String[]{"com.wily.introscope.probebuilder.properties.ProbeBuilderReleaseStrings", "com.wily.properties.CoreCommonStrings", "com.wily.properties.CoreErrorMessages", "com.wily.introscope.properties.IntroscopeCommonStrings", "com.wily.introscope.properties.IntroscopeVersionStrings", "com.wily.introscope.properties.IntroscopeErrorMessages", "com.wily.introscope.probebuilder.properties.ProbeBuilderStrings", "com.wily.diagnos.properties.DiagnosStrings"});
            }
            catch (Throwable t) {
                errorWrapper.println("Introscope Command-Line ProbeBuilder could not startup:" + t.getMessage());
                t.printStackTrace(errorWrapper);
                throw t;
            }
            try {
                AProbeBuilderCommandLine commands = NativeProbeBuilderCommandLineFactory.newNativeProbeBuilderCommandLine(args, (IStringLocalizer)localizer);
                commands.initialize();
                commands.parse();
                ProbeBuilder commandLineProbeBuilder = new ProbeBuilder(feedback, outputWrapper, errorWrapper, (IStringLocalizer)localizer, (IVersion)new IntroscopeVersion((IStringLocalizer)localizer), commands);
                commandLineProbeBuilder.runInstrumentation();
            }
            catch (ParsingException pe) {
                errorWrapper.println(localizer.IStringLocalizer_getFormattedLocalizedString("Probe_Builder_Command_Line_Invalid_Argument", pe.getMessage()));
                throw pe;
            }
        }
        catch (Throwable t) {
            System.exit(1);
        }
        System.exit(0);
    }

    public ProbeBuilder(ApplicationFeedback feedback, PrintWriter outputWriter, PrintWriter errorWriter, IStringLocalizer localizer, IVersion version, AProbeBuilderCommandLine commands) throws IOException {
        super(feedback, localizer, version, localizer.IStringLocalizer_getLocalizedString("Introscope_Probe_Builder_Long_Name"), localizer.IStringLocalizer_getLocalizedString("Introscope_Probe_Builder_Short_Name"), false);
        this.fCommands = commands;
        this.fOutputWriter = outputWriter;
        this.fErrorWriter = errorWriter;
    }

    private PrintWriter getOutputWriter() {
        return this.fOutputWriter;
    }

    private PrintWriter getErrorWriter() {
        return this.fErrorWriter;
    }

    private void runInstrumentation() throws Throwable {
        try {
            CompilerEnvironment env = this.fCommands.getProbeBuilderEnvironment();
            this.getOutputWriter().println();
            if (env.shouldGiveHelp()) {
                this.giveHelp();
            } else {
                long start = MasterClock.currentTimeMillis();
                this.instrument(env);
                long duration = MasterClock.currentTimeMillis() - start;
                this.getOutputWriter().println(this.getStringLocalizer().IStringLocalizer_getLocalizedString("Probe_Builder_Completed"));
                this.getOutputWriter().println(this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Probe_Builder_Duration", String.valueOf(duration / 1000L)));
            }
        }
        catch (DGCompilationFailedException dgcfe) {
            this.getOutputWriter().println(dgcfe.ILocalizableException_getLocalizableMessage().ILocalizableMessage_getLocalizedMessage(this.getStringLocalizer()));
            throw dgcfe;
        }
        catch (DGParserException dgpe) {
            this.getOutputWriter().println(dgpe.ILocalizableException_getLocalizableMessage().ILocalizableMessage_getLocalizedMessage(this.getStringLocalizer()));
            throw dgpe;
        }
        catch (DirectivesException de) {
            this.getOutputWriter().println(de.ILocalizableException_getLocalizableMessage().ILocalizableMessage_getLocalizedMessage(this.getStringLocalizer()));
            throw de;
        }
        catch (ValidationException ve) {
            this.getOutputWriter().println(this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Probe_Builder_Validation_Failure", ve.getRequiredCondition().ILocalizableMessage_getLocalizedMessage(this.getStringLocalizer())));
            this.getOutputWriter().println(this.getStringLocalizer().IStringLocalizer_getLocalizedString("Probe_Builder_Validation_Exception_Help_Message"));
            throw ve;
        }
        catch (FileNotFoundException fnfe) {
            this.getOutputWriter().println(this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Probe_Builder_File_Not_Found_Message", fnfe.getMessage()));
            this.getOutputWriter().println(this.getStringLocalizer().IStringLocalizer_getLocalizedString("Probe_Builder_Failure"));
            throw fnfe;
        }
        catch (Throwable t) {
            this.getOutputWriter().println(this.getStringLocalizer().IStringLocalizer_getLocalizedString("Probe_Builder_Failure"));
            t.printStackTrace(this.getErrorWriter());
            this.getOutputWriter().println(this.getStringLocalizer().IStringLocalizer_getLocalizedString("Probe_Builder_Validation_Exception_Help_Message"));
            throw t;
        }
    }

    public void giveHelp() {
        this.fCommands.printHelp(this.getOutputWriter());
    }

    private void showSummary(ISummaryInfo summary, String logPath) {
        PrintWriter out = this.getOutputWriter();
        out.println(this.getStringLocalizer().IStringLocalizer_getLocalizedString("Probe_Builder_Summary_Header"));
        out.println(this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Probe_Builder_Summary_Num_Classes", String.valueOf(summary.ISummaryInfo_getNumClasses())));
        out.println(this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Probe_Builder_Summary_Num_Modified_Classes", String.valueOf(summary.ISummaryInfo_getNumModifiedClasses())));
        out.println(this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Probe_Builder_Summary_Num_Skipped_Classes", String.valueOf(summary.ISummaryInfo_getNumSkippedClasses())));
        out.println(this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Probe_Builder_Summary_Num_Archives", String.valueOf(summary.ISummaryInfo_getNumArchives())));
        out.println(this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Probe_Builder_Summary_Copied_Files", String.valueOf(summary.ISummaryInfo_getNumCopiedFiles())));
        out.println(this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Probe_Builder_Summary_Num_Skipped_Files", String.valueOf(summary.ISummaryInfo_getNumSkippedFiles())));
        out.println(this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Probe_Builder_Summary_Num_Errors", String.valueOf(summary.ISummaryInfo_getNumErrors())));
        int errorCount = summary.ISummaryInfo_getNumErrors();
        switch (errorCount) {
            case 0: {
                out.println(this.getStringLocalizer().IStringLocalizer_getLocalizedString("Probe_Builder_Summary_No_Error_Message"));
                break;
            }
            case 1: {
                out.println(this.getStringLocalizer().IStringLocalizer_getLocalizedString("Probe_Builder_Summary_Single_Error_Message"));
                break;
            }
            default: {
                out.println(this.getStringLocalizer().IStringLocalizer_getLocalizedString("Probe_Builder_Summary_Multiple_Error_Message"));
            }
        }
        if (logPath != null) {
            out.println(this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Probe_Builder_Summary_Log_File_Location_Message", logPath));
        } else {
            out.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void instrument(CompilerEnvironment env) throws DGClassException, DGParserException, DirectivesException, IOException, ValidationException {
        env.IValidatable_validate();
        this.getOutputWriter().println(this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Probe_Builder_Processing", env.getTargetName()));
        ICompilerLog log = NullCompilerLog.getInstance();
        File logFile = env.getLogFilePath();
        File[] createdDirs = null;
        try {
            DGCompilerLog pbLog = new DGCompilerLog(logFile, this.getStringLocalizer().IStringLocalizer_getLocalizedString("Introscope_Probe_Builder_Long_Name"), this.getStringLocalizer(), this.getModuleFeedback());
            pbLog.ICompilerLog_logHeader(this.getStringLocalizer().IStringLocalizer_getLocalizedString("Long_Copyright"), this.getVersion().IVersion_getReleaseAndBuildString(this.getStringLocalizer()), DGVersion.getVersionString());
            createdDirs = pbLog.getCreatedDirectories();
            log = pbLog;
            this.getOutputWriter().println(this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Probe_Builder_Log_File_Opened", logFile.getAbsolutePath()));
        }
        catch (IOException ioe) {
            this.getOutputWriter().println(this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Probe_Builder_Could_Not_Create_Log_File", ExtendedFile.safeGetCanonicalPath((File)logFile), ioe.getMessage()));
            log = new SummaryLog();
            logFile = null;
        }
        ProbeBuilderUI ui = new ProbeBuilderUI(env, this.getOutputWriter(), this.getErrorWriter(), this.getStringLocalizer());
        try {
            ICompilerPersonality personality = NativePersonality.getNativePersonality();
            DirectivesFile requiredDirectives = InternalDirectivesLoader.loadRequiredDirectives(personality);
            if (requiredDirectives == null) {
                throw new ValidationException((ILocalizableMessage)new SimpleLocalizableMessage("Probe_Builder_Validation_Exception_No_Required_Directives_Specified_Error"));
            }
            String[] userDirectivesFiles = env.getUserDirectivesFiles();
            if (env.isVerbose()) {
                for (int x = 0; x < userDirectivesFiles.length; ++x) {
                    this.getOutputWriter().println(this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Probe_Builder_User_Directives_File", userDirectivesFiles[x]));
                }
            }
            DirectivesFileList directives = new DirectivesFileList(this.getModuleFeedback(), log, this.getStringLocalizer(), personality);
            directives.add(requiredDirectives);
            directives.add(userDirectivesFiles);
            CompilerSettingsBuilder builder = new CompilerSettingsBuilder(this.getModuleFeedback(), log, this.getStringLocalizer(), personality);
            directives.applyToSettings(builder, log);
            builder.setInstrumentationInfo(this.getVersion().IVersion_getReleaseAndBuildString(this.getStringLocalizer()));
            DGCompilerSettings settings = builder.generateSettings(log);
            DGFileSettings fileSettings = new DGFileSettings();
            fileSettings.setShouldCopyItems(env.getCopyItems());
            fileSettings.addSkippedFile(logFile);
            fileSettings.addIgnoredFiles(createdDirs);
            log.ICompilerLog_logFileSettings(fileSettings);
            IBatchCompiler cmp = personality.newBatchCompiler(env, settings, fileSettings, ui, log, this.getModuleFeedback(), this.getStringLocalizer());
            try {
                cmp.compileAll();
            }
            finally {
                try {
                    this.showSummary(log.ICompilerLog_getSummaryInfo(), log.ICompilerLog_getPath());
                }
                catch (Throwable throwable) {}
            }
        }
        catch (DGParserException dgpe) {
            log.ICompilerLog_logInvalidSettings(dgpe.ILocalizableException_getLocalizableMessage().ILocalizableMessage_getLocalizedMessage(this.getStringLocalizer()));
            throw dgpe;
        }
        catch (DirectivesException de) {
            log.ICompilerLog_logInvalidSettings(de.ILocalizableException_getLocalizableMessage().ILocalizableMessage_getLocalizedMessage(this.getStringLocalizer()));
            throw de;
        }
        catch (ValidationException ve) {
            log.ICompilerLog_logInvalidSettings(ve.getRequiredCondition().ILocalizableMessage_getLocalizedMessage(this.getStringLocalizer()));
            throw ve;
        }
        catch (DGCompilationFailedException dgcfe) {
            throw dgcfe;
        }
        catch (IOException e) {
            log.ICompilerLog_logMessage(kProbeBuilderErrorPrefix + e);
            log.ICompilerLog_logException(e);
            throw e;
        }
        finally {
            try {
                log.ICompilerLog_close();
            }
            catch (Throwable throwable) {}
        }
    }

    protected void doStart() throws Exception {
    }

    protected void doStop() throws Exception {
    }
}

