/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.probebuilder.validate;

import com.wily.diagnos.cmp.tracer.IMethodTracerValidator;
import com.wily.introscope.spec.metric.AgentMetricPrefix;
import com.wily.introscope.spec.metric.BadlyFormedNameException;
import com.wily.util.properties.AttributeListing;
import com.wily.util.text.FormattedLocalizableMessage;
import com.wily.util.text.ILocalizableMessage;
import com.wily.util.text.SimpleLocalizableMessage;
import com.wily.util.validate.ValidationException;
import java.util.Iterator;

public class ResourceNameAndThresholdValidator
implements IMethodTracerValidator {
    @Override
    public void IMethodTracerValidator_validateParameters(AttributeListing parameters) throws ValidationException {
        String name = null;
        String threshold = null;
        Iterator iterator = parameters.getKeys();
        while (iterator.hasNext()) {
            String parameter = (String)iterator.next();
            if (parameter.equals("name")) {
                name = parameters.get(parameter);
                continue;
            }
            if (parameter.equals("threshold")) {
                threshold = parameters.get(parameter);
                continue;
            }
            throw new ValidationException((ILocalizableMessage)new FormattedLocalizableMessage("Probe_Builder_Validation_Exception_Unexpected_Tracer_Parameter_Error", parameter));
        }
        if (name == null || name.length() == 0) {
            throw new ValidationException((ILocalizableMessage)new SimpleLocalizableMessage("Probe_Builder_Validation_Exception_Missing_Resource_Name_Error"));
        }
        try {
            AgentMetricPrefix.verifyValidResource((String)name);
        }
        catch (BadlyFormedNameException bfne) {
            throw new ValidationException((ILocalizableMessage)new FormattedLocalizableMessage("Probe_Builder_Validation_Exception_Invalid_Resource_Name_Error", name));
        }
        if (threshold == null || threshold.length() == 0) {
            throw new ValidationException((ILocalizableMessage)new SimpleLocalizableMessage("Probe_Builder_Validation_Exception_Missing_Threshold_Error"));
        }
        try {
            int intValue = Integer.parseInt(threshold);
            if (intValue < 0) {
                throw new ValidationException((ILocalizableMessage)new FormattedLocalizableMessage("Probe_Builder_Validation_Exception_Negative_Threshold_Error", String.valueOf(intValue)));
            }
        }
        catch (NumberFormatException nfe) {
            throw new ValidationException((ILocalizableMessage)new FormattedLocalizableMessage("Probe_Builder_Validation_Exception_Threshold_Not_An_Integer_Error", threshold));
        }
    }
}

