/*
 * Decompiled with CFR 0.152.
 */
package com.wily.isengard.postofficehub.link.http.client;

import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import javax.naming.NamingException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;

final class BasicHostnameVerifier {
    private static final int SUBJECT_ALTNAME_DNS = 2;
    private static final int SUBJECT_ALTNAME_IP = 7;
    private static final Pattern IPV4_PATTERN = Pattern.compile("^(25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)(\\.(25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)){3}$");
    private static final Pattern IPV6_STD_PATTERN = Pattern.compile("^(?:[0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}$");
    private static final Pattern IPV6_HEX_COMPRESSED_PATTERN = Pattern.compile("^((?:[0-9A-Fa-f]{1,4}(?::[0-9A-Fa-f]{1,4})*)?)::((?:[0-9A-Fa-f]{1,4}(?::[0-9A-Fa-f]{1,4})*)?)$");

    BasicHostnameVerifier() {
    }

    static void verify(String hostname, X509Certificate certificate) throws CertificateException {
        if (BasicHostnameVerifier.isIPv4Address(hostname) || BasicHostnameVerifier.isIPv6Address(hostname)) {
            BasicHostnameVerifier.verifyIp(hostname, certificate);
        } else {
            BasicHostnameVerifier.verifyDns(hostname, certificate);
        }
    }

    private static void verifyIp(String ip, X509Certificate certificate) throws CertificateException {
        List<String> alternatives = BasicHostnameVerifier.altNames(certificate, 7);
        if (alternatives.isEmpty()) {
            throw new CertificateException("Subject alternative names are required for IP hostname check");
        }
        for (String alt : alternatives) {
            if (!ip.equalsIgnoreCase(alt)) continue;
            return;
        }
        throw new CertificateException("No subject alternative names for IP=" + ip + " found. Existing alternatives in certificate: " + alternatives);
    }

    private static void verifyDns(String hostname, X509Certificate certificate) throws CertificateException {
        List<String> alternatives = BasicHostnameVerifier.altNames(certificate, 2);
        if (!alternatives.isEmpty()) {
            for (String alt : alternatives) {
                if (!BasicHostnameVerifier.matchName(hostname, alt)) continue;
                return;
            }
            throw new CertificateException("Certificate for " + hostname + " does not match any " + "of the subject alternative names in certificate: " + alternatives);
        }
        String cn = BasicHostnameVerifier.lookupCn(certificate);
        if (BasicHostnameVerifier.matchName(hostname, cn)) {
            return;
        }
        throw new CertificateException("Certificate for " + hostname + " does not match common name of the certificate subject: " + cn);
    }

    /*
     * Unable to fully structure code
     */
    private static String lookupCn(X509Certificate certificate) throws CertificateException {
        dn = certificate.getSubjectX500Principal().getName();
        try {
            ldapDN = new LdapName(dn);
            for (Rdn rdn : ldapDN.getRdns()) {
                if (rdn != null && (attr = (attributes = rdn.toAttributes()).get("CN")) != null && (values = attr.getAll()) != null) ** GOTO lbl10
                continue;
lbl-1000:
                // 1 sources

                {
                    o = values.next();
                    if (o == null || !(o instanceof String)) continue;
                    return (String)o;
lbl10:
                    // 2 sources

                    ** while (values.hasMoreElements())
                }
lbl11:
                // 1 sources

            }
        }
        catch (NamingException n) {
            throw new CertificateException("Can not parse CN", n);
        }
        throw new CertificateException("CN is not found in the certificate");
    }

    /*
     * Unable to fully structure code
     */
    private static boolean matchName(String hostname, String template) {
        nameTokenizer = new StringTokenizer(hostname.toLowerCase(), ".");
        templateTokenizer = new StringTokenizer(template.toLowerCase(), ".");
        if (nameTokenizer.countTokens() == templateTokenizer.countTokens()) ** GOTO lbl7
        return false;
lbl-1000:
        // 1 sources

        {
            if (BasicHostnameVerifier.matchNameComponent(nameTokenizer.nextToken(), templateTokenizer.nextToken())) continue;
            return false;
lbl7:
            // 2 sources

            ** while (nameTokenizer.hasMoreTokens())
        }
lbl8:
        // 1 sources

        return true;
    }

    private static boolean matchNameComponent(String name, String template) {
        int wildcardIdx = template.indexOf("*");
        if (wildcardIdx == -1) {
            return name.equals(template);
        }
        boolean isBeginning = true;
        String beforeWildcard = "";
        String afterWildcard = template;
        while (wildcardIdx != -1) {
            beforeWildcard = afterWildcard.substring(0, wildcardIdx);
            afterWildcard = afterWildcard.substring(wildcardIdx + 1);
            int beforeStartIdx = name.indexOf(beforeWildcard);
            if (beforeStartIdx == -1 || isBeginning && beforeStartIdx != 0) {
                return false;
            }
            isBeginning = false;
            name = name.substring(beforeStartIdx + beforeWildcard.length());
            wildcardIdx = afterWildcard.indexOf("*");
        }
        return name.endsWith(afterWildcard);
    }

    private static final List<String> altNames(X509Certificate certificate, int type) throws CertificateException {
        Collection<List<?>> altNames = certificate.getSubjectAlternativeNames();
        if (altNames == null) {
            return Collections.emptyList();
        }
        ArrayList<String> alternatives = new ArrayList<String>(altNames.size());
        for (List<?> alt : altNames) {
            Integer altType;
            Integer n = altType = alt.size() >= 2 ? (Integer)alt.get(0) : null;
            if (altType == null || altType != type) continue;
            alternatives.add((String)alt.get(1));
        }
        return alternatives;
    }

    private static boolean isIPv4Address(String input) {
        return IPV4_PATTERN.matcher(input).matches();
    }

    private static boolean isIPv6StdAddress(String input) {
        return IPV6_STD_PATTERN.matcher(input).matches();
    }

    private static boolean isIPv6HexCompressedAddress(String input) {
        return IPV6_HEX_COMPRESSED_PATTERN.matcher(input).matches();
    }

    private static boolean isIPv6Address(String input) {
        return BasicHostnameVerifier.isIPv6StdAddress(input) || BasicHostnameVerifier.isIPv6HexCompressedAddress(input);
    }
}

