/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.adt;

import com.wily.util.adt.ConcurrentHighPerformanceLRUHashMap;

public class ObjectInternLRUCache<T> {
    private final ConcurrentHighPerformanceLRUHashMap<T, T> map;
    private static final ObjectInternLRUCache<Object> IDENTITY = new ObjectInternLRUCache<Object>(1, 1){

        @Override
        public Object intern(Object obj) {
            return obj;
        }
    };

    public ObjectInternLRUCache(int concurrencyLevel, int maxSize) {
        int maxSegmentSize = maxSize / concurrencyLevel;
        this.map = new ConcurrentHighPerformanceLRUHashMap(concurrencyLevel, maxSegmentSize);
    }

    public T intern(T obj) {
        if (obj == null) {
            return obj;
        }
        T existing = this.map.putIfAbsent(obj, obj);
        if (existing != null) {
            return existing;
        }
        return obj;
    }

    public static <T> ObjectInternLRUCache<T> identidy() {
        return IDENTITY;
    }
}

