/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.adt.trie;

import com.wily.util.adt.primitive.CharObjHashMap;
import com.wily.util.adt.primitive.CharObjMapEntry;
import com.wily.util.adt.primitive.PrimitiveCharObjMap;
import com.wily.util.adt.primitive.PrimitiveIntObjMap;
import com.wily.util.adt.primitive.Synchronizer;
import java.util.concurrent.atomic.AtomicInteger;

public class ParentReferencingIntegerIdentifiedTrieNode {
    private char thisCharacter;
    private ParentReferencingIntegerIdentifiedTrieNode parent;
    private int id;
    private PrimitiveCharObjMap<ParentReferencingIntegerIdentifiedTrieNode> children;

    public ParentReferencingIntegerIdentifiedTrieNode(char thisChar, ParentReferencingIntegerIdentifiedTrieNode parent) {
        this.thisCharacter = thisChar;
        this.parent = parent;
        this.id = 0;
        this.children = null;
    }

    public char getThisCharacter() {
        return this.thisCharacter;
    }

    public ParentReferencingIntegerIdentifiedTrieNode getParent() {
        return this.parent;
    }

    public int getId() {
        return this.id;
    }

    public PrimitiveCharObjMap<ParentReferencingIntegerIdentifiedTrieNode> getChildren() {
        return this.children;
    }

    public PrimitiveCharObjMap<ParentReferencingIntegerIdentifiedTrieNode> getChildrenForInsert(boolean synch) {
        if (this.children == null) {
            this.children = new CharObjHashMap<ParentReferencingIntegerIdentifiedTrieNode>();
            if (synch) {
                this.children = Synchronizer.synchronizedPrimitiveCharObjMap(this.children);
            }
        }
        return this.children;
    }

    public boolean isEndOfWord() {
        return this.id != 0;
    }

    public void setEndOfWord(int id) {
        this.id = id;
    }

    public void setChildrenToNull() {
        this.children = null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ParentReferencingIntegerIdentifiedTrieNode that = (ParentReferencingIntegerIdentifiedTrieNode)o;
        if (this.thisCharacter != that.thisCharacter) {
            return false;
        }
        if (this.id != that.id) {
            return false;
        }
        if (this.parent != null ? !this.parent.equals(that.parent) : that.parent != null) {
            return false;
        }
        return this.children != null ? this.children.equals(that.children) : that.children == null;
    }

    public int hashCode() {
        int result = this.thisCharacter;
        result = 31 * result + (this.parent != null ? this.parent.hashCode() : 0);
        result = 31 * result + this.id;
        result = 31 * result + (this.children != null ? this.children.hashCode() : 0);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ParentReferencingIntegerIdentifiedTrieNode(ParentReferencingIntegerIdentifiedTrieNode other, ParentReferencingIntegerIdentifiedTrieNode newParent, AtomicInteger seed, PrimitiveIntObjMap<ParentReferencingIntegerIdentifiedTrieNode> reverseIndex, boolean synch) {
        this.thisCharacter = other.getThisCharacter();
        this.parent = newParent;
        this.id = 0;
        if (other.isEndOfWord()) {
            this.id = seed.incrementAndGet();
            reverseIndex.put(this.id, this);
        }
        if (other.getChildren() == null) {
            this.children = null;
            return;
        }
        this.children = new CharObjHashMap<ParentReferencingIntegerIdentifiedTrieNode>();
        if (synch) {
            this.children = Synchronizer.synchronizedPrimitiveCharObjMap(this.children);
        }
        PrimitiveCharObjMap<ParentReferencingIntegerIdentifiedTrieNode> primitiveCharObjMap = other.getChildren();
        synchronized (primitiveCharObjMap) {
            for (CharObjMapEntry<ParentReferencingIntegerIdentifiedTrieNode> charObjMapEntry : other.getChildren()) {
                this.children.put(charObjMapEntry.getKey(), new ParentReferencingIntegerIdentifiedTrieNode(charObjMapEntry.getValue(), this, seed, reverseIndex, synch));
            }
        }
    }
}

