/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.feedback.backend;

import com.wily.util.feedback.backend.IFeedbackBackend;
import com.wily.util.feedback.backend.NativeFeedbackBackendFactory;
import com.wily.util.feedback.backend.SystemOutBackend;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import java.util.concurrent.atomic.AtomicReference;

public class NativeFeedbackBackendRegistry {
    private static final List<String> KNOWN_BACKENDS = Collections.unmodifiableList(Arrays.asList("com.wily.util.feedback.backend.logback.LogbackBackendFactory", "com.wily.util.feedback.backend.log4j.Log4jBackendFactory"));
    private static final boolean disableStdoutFallback = Boolean.getBoolean("com.wily.util.feedback.backend.disableStdoutFallback");
    private final AtomicReference<NativeFeedbackBackendFactory> backend = new AtomicReference<NativeFeedbackBackendFactory>(NativeFeedbackBackendRegistry.findImpl());

    private static NativeFeedbackBackendFactory findImpl() throws NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        ServiceLoader<NativeFeedbackBackendFactory> loader = ServiceLoader.load(NativeFeedbackBackendFactory.class);
        Iterator<NativeFeedbackBackendFactory> iterator = loader.iterator();
        if (iterator.hasNext()) {
            return iterator.next();
        }
        return NativeFeedbackBackendRegistry.findImplFallback();
    }

    private static NativeFeedbackBackendFactory findImplFallback() throws NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        for (String backendImplClassName : KNOWN_BACKENDS) {
            Class<?> implClass;
            try {
                implClass = Class.forName(backendImplClassName);
            }
            catch (ClassNotFoundException classNotFoundException) {
                continue;
            }
            return (NativeFeedbackBackendFactory)implClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        if (disableStdoutFallback) {
            throw new IllegalStateException("Missing implementation of native backend for logging. Tried " + KNOWN_BACKENDS);
        }
        return SystemOutBackend.getInstance();
    }

    public IFeedbackBackend getNativeFeedbackBackend() {
        return this.backend.get().getNativeFeedbackBackend();
    }

    public NativeFeedbackBackendFactory registerNativeFeedbackBackendFactory(NativeFeedbackBackendFactory factory) {
        return this.backend.getAndSet(factory);
    }

    public static NativeFeedbackBackendRegistry getInstance() {
        return Holder.INSTANCE;
    }

    private static final class Holder {
        static final NativeFeedbackBackendRegistry INSTANCE;

        static {
            try {
                INSTANCE = new NativeFeedbackBackendRegistry();
            }
            catch (InvocationTargetException e) {
                throw new ExceptionInInitializerError(e);
            }
            catch (NoSuchMethodException e) {
                throw new ExceptionInInitializerError(e);
            }
            catch (InstantiationException e) {
                throw new ExceptionInInitializerError(e);
            }
            catch (IllegalAccessException e) {
                throw new ExceptionInInitializerError(e);
            }
            catch (RuntimeException e) {
                throw new ExceptionInInitializerError(e);
            }
        }

        private Holder() {
        }
    }
}

