/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.feedback.backend;

import com.wily.util.IConfigurationListener;
import com.wily.util.feedback.SeverityLevel;
import com.wily.util.feedback.backend.IFeedbackBackend;
import com.wily.util.properties.IndexedProperties;
import com.wily.util.resource.IResource;
import java.util.Enumeration;
import java.util.Properties;

public abstract class PropertyConfigurableBackend
implements IFeedbackBackend {
    private static final String defaultLevelPropertyPrefix = "introscope.log.level.";
    protected static String levelPropertyPrefix = "introscope.log.level.";
    public static final String rootLevelName = "root";
    protected SeverityLevel rootLevel = SeverityLevel.INFO;

    public static void setCustomLevelPropertyPrefix(String prefix) {
        levelPropertyPrefix = prefix;
    }

    public static String getCustomLevelPropertyPrefix(String prefix) {
        return levelPropertyPrefix;
    }

    protected PropertyConfigurableBackend() {
    }

    @Override
    public void setGlobalDefaults(String defaultOutputTarget) {
    }

    @Override
    public void setGlobalConfiguration(Properties props) {
        this.configureFromProperties(props);
    }

    @Override
    public void configureFromProperties(Properties properties) {
        Enumeration<?> e = properties.propertyNames();
        while (e.hasMoreElements()) {
            String attribute = (String)e.nextElement();
            if (!attribute.startsWith(levelPropertyPrefix)) continue;
            String loggerName = attribute.substring(levelPropertyPrefix.length()).trim();
            String levelName = properties.getProperty(attribute).trim().toUpperCase();
            SeverityLevel severityLevel = SeverityLevel.getLevelByName(levelName);
            if (levelName.equals(rootLevelName)) {
                this.setRootLevel(severityLevel);
                continue;
            }
            this.setLevel(this.getLoggerByName(loggerName), severityLevel);
        }
    }

    @Override
    public boolean containsLoggingConfiguration(Properties props) {
        Enumeration<?> e = props.propertyNames();
        while (e.hasMoreElements()) {
            String attribute = (String)e.nextElement();
            if (attribute.indexOf(levelPropertyPrefix) < 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setRootLevel(SeverityLevel level) {
        this.rootLevel = level;
    }

    @Override
    public boolean isRootEnabledFor(SeverityLevel level) {
        return !this.rootLevel.isLessThan(level);
    }

    @Override
    public IConfigurationListener createConfigurationListener(IResource configResource) {
        return new IConfigurationListener(){

            @Override
            public void onChange(IndexedProperties newProps) {
                PropertyConfigurableBackend.this.configureFromProperties(newProps);
            }
        };
    }
}

