/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public final class ObjectCounterInputStream
extends FilterInputStream {
    private final byte[] fBuffer = new byte[4];
    private int fCurrBufferIndex;
    private int fCount;
    private boolean fIsClosed;
    private int fNumBytesToNextObject;
    private int fCurrObjectSizeAndLength;
    private int fLastObjectSizeAndLength;

    public ObjectCounterInputStream(InputStream in) {
        super(in);
    }

    public int getCount() {
        return this.fCount >> 1;
    }

    public int getOverflow() {
        int overflow = this.fCurrObjectSizeAndLength - this.fNumBytesToNextObject;
        if ((this.fCount & 1) == 1) {
            overflow += this.fLastObjectSizeAndLength;
        }
        return overflow;
    }

    @Override
    public int read() throws IOException {
        int val = this.in.read();
        if (val != -1) {
            if (this.fNumBytesToNextObject == 0) {
                this.fBuffer[this.fCurrBufferIndex++] = (byte)val;
                ++this.fCurrObjectSizeAndLength;
                if (this.fCurrBufferIndex == 4) {
                    this.fNumBytesToNextObject = (this.fBuffer[0] & 0xFF) << 24 | (this.fBuffer[1] & 0xFF) << 16 | (this.fBuffer[2] & 0xFF) << 8 | this.fBuffer[3] & 0xFF;
                    this.fCurrObjectSizeAndLength += this.fNumBytesToNextObject;
                    this.fCurrBufferIndex = 0;
                }
            } else if (--this.fNumBytesToNextObject == 0) {
                this.fLastObjectSizeAndLength = this.fCurrObjectSizeAndLength;
                this.fCurrObjectSizeAndLength = 0;
                ++this.fCount;
            }
        }
        return val;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int num = this.in.read(b, off, len);
        if (num == -1) {
            return -1;
        }
        int i = off;
        int l = off + num;
        while (i < l) {
            if (this.fNumBytesToNextObject == 0) {
                this.fBuffer[this.fCurrBufferIndex++] = b[i];
                ++this.fCurrObjectSizeAndLength;
                if (this.fCurrBufferIndex == 4) {
                    this.fNumBytesToNextObject = (this.fBuffer[0] & 0xFF) << 24 | (this.fBuffer[1] & 0xFF) << 16 | (this.fBuffer[2] & 0xFF) << 8 | this.fBuffer[3] & 0xFF;
                    this.fCurrObjectSizeAndLength += this.fNumBytesToNextObject;
                    this.fCurrBufferIndex = 0;
                }
            } else {
                int remainingLoops = l - i;
                if (remainingLoops >= this.fNumBytesToNextObject) {
                    i += this.fNumBytesToNextObject - 1;
                    this.fNumBytesToNextObject = 0;
                    this.fLastObjectSizeAndLength = this.fCurrObjectSizeAndLength;
                    this.fCurrObjectSizeAndLength = 0;
                    ++this.fCount;
                } else {
                    this.fNumBytesToNextObject -= remainingLoops;
                    break;
                }
            }
            ++i;
        }
        return num;
    }

    public void resetCount() {
        this.fCount = (this.fCount & 1) == 1 ? 1 : 0;
    }

    @Override
    public void close() throws IOException {
        try {
            this.in.close();
        }
        finally {
            this.fIsClosed = true;
        }
    }

    public boolean isClosed() {
        return this.fIsClosed;
    }
}

