/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.transactiontrace;

import com.wily.introscope.agent.transactiontrace.ISamplingInput;
import com.wily.util.feedback.Module;
import java.util.EnumMap;
import java.util.Map;

public interface ISamplingResult {
    public static final Module kSamplingModule = new Module("TransactionSamplingStrategy");
    public static final ISamplingResult NO = new ConstantSamplingResult(false, null);

    public Answer shouldStartSampling();

    public void determineSampling(ISamplingInput var1, Callback var2);

    public ISamplingResult derivativeSamplingResult();

    public boolean isDerivative();

    public static final class ConstantSamplingResult
    implements ISamplingResult {
        private final Answer answer;

        public ConstantSamplingResult(boolean sample, String byWho) {
            this(new Answer(sample ? Choice.YES : Choice.NO, byWho));
        }

        protected ConstantSamplingResult(Answer answer) {
            this.answer = answer;
        }

        @Override
        public Answer shouldStartSampling() {
            return this.answer;
        }

        @Override
        public void determineSampling(ISamplingInput input, Callback callback) {
            if (!input.valid()) {
                callback.onSamplingDetermined(new Answer(Choice.NO, this.answer.byWho));
                return;
            }
            callback.onSamplingDetermined(this.answer);
        }

        @Override
        public ISamplingResult derivativeSamplingResult() {
            return this;
        }

        @Override
        public boolean isDerivative() {
            return false;
        }
    }

    public static interface Callback {
        public static final Callback NO_OP_CALLBACK = new Callback(){

            @Override
            public void onSamplingDetermined(Answer answer) {
            }
        };

        public void onSamplingDetermined(Answer var1);
    }

    public static class Answer {
        public final Choice choice;
        public final String byWho;
        private static final Map<Choice, Answer> UNKNOWN_ANSWERS = new EnumMap<Choice, Answer>(Choice.class);

        public static Answer create(Choice choice, String byWho) {
            Answer exitsting;
            if (byWho == null && (exitsting = UNKNOWN_ANSWERS.get((Object)choice)) != null) {
                return exitsting;
            }
            return new Answer(choice, byWho);
        }

        private Answer(Choice choice, String byWho) {
            this.choice = choice;
            this.byWho = byWho;
        }

        public String toString() {
            return "ISamplingResult.Answer=" + (Object)((Object)this.choice) + (this.byWho == null ? "" : " by " + this.byWho);
        }

        static {
            UNKNOWN_ANSWERS.put(Choice.YES, new Answer(Choice.YES, null));
            UNKNOWN_ANSWERS.put(Choice.NO, new Answer(Choice.NO, null));
            UNKNOWN_ANSWERS.put(Choice.MAYBE, new Answer(Choice.MAYBE, null));
            UNKNOWN_ANSWERS.put(Choice.LEAD_IS_NOT_READY, new Answer(Choice.LEAD_IS_NOT_READY, null));
        }
    }

    public static enum Choice {
        YES(true),
        NO(false),
        LEAD_IS_NOT_READY(true),
        MAYBE(true);

        public final boolean mayBeYes;

        private Choice(boolean mayBeYes) {
            this.mayBeYes = mayBeYes;
        }
    }
}

