/*
 * Decompiled with CFR 0.152.
 */
package com.wily.isengard.api;

import com.wily.isengard.api.IIsengardClient;
import com.wily.isengard.api.ServerInstanceLocator;
import com.wily.isengard.api.TransportConfiguration;
import com.wily.isengard.container.BeanContainerCore;
import com.wily.isengard.messageprimitives.ConnectionException;
import com.wily.isengard.postoffice.IPostOfficeNotification;
import com.wily.isengard.postoffice.PostOffice;
import com.wily.isengard.postoffice.PostOfficeHub;
import com.wily.isengard.postoffice.PostOfficeSpecifier;
import com.wily.isengard.postofficehub.ClonedRegistry;
import com.wily.isengard.util.tree.EntryAlreadyExistsException;
import com.wily.isengard.util.tree.InvalidPathException;
import com.wily.util.exception.UnexpectedExceptionError;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.thread.DefaultThreadFactory;
import com.wily.util.thread.IThreadFactory;
import com.wily.wilyassert.Assertion;
import java.io.IOException;

public class IsengardClient
implements IPostOfficeNotification {
    private static final Module sModule = new Module("IsengardClient");
    private String fGroupName;
    private String fCredentials;
    private volatile String fServerHubName;
    private volatile boolean fIsClosed = true;
    private PostOfficeHub fHub;
    private PostOffice fPO;
    private TransportConfiguration fTransportConfig;
    private ServerInstanceLocator fServerLocator;
    private BeanContainerCore fBeanContainer;
    private IIsengardClient fClientNotification;
    private ClassLoader fDefaultClassloader;
    private IThreadFactory fThreadFactory;
    private IModuleFeedbackChannel fFeedback;
    private boolean fCacheRegistry;

    public IsengardClient(IModuleFeedbackChannel feedback, String groupName, String credentials, TransportConfiguration transportConfig, ServerInstanceLocator serverLocator, IIsengardClient client, ClassLoader loader, IThreadFactory threadFactory) {
        this.fGroupName = groupName;
        this.fCredentials = credentials;
        this.fTransportConfig = transportConfig;
        this.fServerLocator = serverLocator;
        this.fClientNotification = client;
        this.fDefaultClassloader = loader;
        this.fThreadFactory = threadFactory;
        this.fFeedback = feedback;
        this.initialize();
    }

    public IsengardClient(IModuleFeedbackChannel feedback, String hostName, int port, String groupName, String credentials, IIsengardClient client) {
        this.fGroupName = groupName;
        this.fCredentials = credentials;
        this.fTransportConfig = TransportConfiguration.getDefaultClientConfiguration();
        this.fServerLocator = new ServerInstanceLocator(hostName, port, feedback);
        this.fClientNotification = client;
        this.fDefaultClassloader = this.getClass().getClassLoader();
        this.fThreadFactory = new DefaultThreadFactory(false);
        this.fFeedback = feedback;
        this.initialize();
    }

    private void initialize() {
        this.fCacheRegistry = true;
    }

    public ServerInstanceLocator getServerInstanceLocator() {
        return this.fServerLocator;
    }

    public void setUseExplicitSerialization() {
        this.fTransportConfig.setSerializationMode(49);
    }

    public void connect() throws IOException {
        this.connect(120000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(long timeout) throws IOException {
        Assertion.wilyAssert(this.fIsClosed, "Isengard client should be closed.");
        try {
            this.fHub = new PostOfficeHub("UnknownHub", null, this.fTransportConfig, this.getFeedbackChannel(), this.fDefaultClassloader, this.fThreadFactory);
            this.fHub.connectToServerHub(timeout, this.fGroupName, this.fCredentials, this.fServerLocator);
            this.fHub.setPostOfficeNotification(this);
            this.fPO = new PostOffice(this.fHub, "client_main", this.fTransportConfig.getIsengardClientPOThreadPoolSize(), this.fTransportConfig.getIncomingMessageQueueSize());
            this.getFeedbackChannel().debug(sModule, "Number of client po threads " + this.fTransportConfig.getIsengardClientPOThreadPoolSize());
            try {
                if (this.fCacheRegistry) {
                    this.fHub.createClonedRegistry();
                }
                this.getFeedbackChannel().debug(sModule, "Client successfully connected with Isengard server.");
                this.fBeanContainer = new BeanContainerCore(this.fPO, this.fHub.getHubName(), this.fDefaultClassloader);
            }
            catch (EntryAlreadyExistsException e) {
                throw new UnexpectedExceptionError(e);
            }
            catch (InvalidPathException e) {
                throw new UnexpectedExceptionError(e);
            }
            catch (ConnectionException connectionException) {
                throw new IOException("Caught ConnectionException while communicating with the remote host");
            }
            IsengardClient isengardClient = this;
            synchronized (isengardClient) {
                this.fIsClosed = false;
            }
        }
        finally {
            if (this.fIsClosed) {
                this.cleanup();
            }
        }
        this.fClientNotification.connectedToIsengardServer();
    }

    public PostOffice getMainPO() {
        return this.fPO;
    }

    public PostOfficeHub getPostOfficeHub() {
        return this.fHub;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        IsengardClient isengardClient = this;
        synchronized (isengardClient) {
            if (this.fIsClosed) {
                return;
            }
            this.fIsClosed = true;
        }
        this.cleanup();
        this.fClientNotification.lostConnectionToIsengardServer();
    }

    private void cleanup() {
        if (this.fBeanContainer != null) {
            this.fBeanContainer.shutdownContainer();
        }
        if (this.fPO != null) {
            this.fPO.close();
        }
        if (this.fHub != null) {
            this.fHub.close();
        }
    }

    @Override
    public void postOfficeAdded(PostOfficeSpecifier postOffice) {
        this.fServerHubName = "Server";
    }

    @Override
    public void postOfficeRemoved(PostOfficeSpecifier postOffice) {
        if (postOffice.getHubName().equals(this.fServerHubName) && !this.fIsClosed) {
            this.getFeedbackChannel().debug(sModule, "Lost connection to server tier");
            if (this.fCacheRegistry) {
                try {
                    ClonedRegistry clonedRegService = (ClonedRegistry)this.fPO.getRegistry();
                    clonedRegService.setRealRegistryTransportDown();
                }
                catch (Exception e) {
                    this.getFeedbackChannel().debug("Ignoring in IsengardClient#postOfficeRemoved. ", e);
                }
            }
            this.close();
        }
    }

    public IModuleFeedbackChannel getFeedbackChannel() {
        return this.fFeedback;
    }

    public BeanContainerCore getBeanContainer() {
        return this.fBeanContainer;
    }

    public boolean isConnected() {
        return !this.fIsClosed;
    }

    public void setCacheRegistry(boolean cacheRegistry) {
        this.fCacheRegistry = cacheRegistry;
    }

    public void hardDisconnect() {
        this.fHub.hardDisconnect();
    }
}

