/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.intelligent.entrypoint.stacktrace;

import com.wily.introscope.agent.intelligent.detection.BaseCandidateFinder;
import com.wily.introscope.agent.intelligent.detection.RecordingData;
import com.wily.introscope.agent.intelligent.detection.TraceRecordingFilter;
import com.wily.introscope.agent.intelligent.detection.TraceRecordingListener;
import com.wily.introscope.agent.intelligent.entrypoint.EntryPointCandidateFinder;
import com.wily.introscope.agent.intelligent.entrypoint.EntryPointDetectionConfiguration;

public class ThreadSelector
implements TraceRecordingFilter,
TraceRecordingListener {
    private volatile int numberIntervalsToElapse = EntryPointDetectionConfiguration.getNumberIntervalsToElapse();
    private final BaseCandidateFinder finder = EntryPointCandidateFinder.getInstance();

    private ThreadSelector() {
    }

    @Override
    public boolean shouldRecordTrace(RecordingData threadLocalData) {
        int runNumber = this.finder.currentRunNumber();
        return this.isQualifiedForRun(runNumber, threadLocalData.getRunSelectionId());
    }

    private boolean isQualifiedForRun(int runNumber, int runSelectionId) {
        return runNumber >= runSelectionId;
    }

    @Override
    public void notifyOnRecording(RecordingData threadLocalData) {
        threadLocalData.setRunSelectionId(this.finder.currentRunNumber() + this.numberIntervalsToElapse);
    }

    public void setNumberIntervalsToElapse(int numberIntervalsToElapse) {
        this.numberIntervalsToElapse = numberIntervalsToElapse;
    }

    public void resetSelectionId(RecordingData threadLocalData) {
        threadLocalData.setRunSelectionId(0);
    }

    public static ThreadSelector getInstance() {
        return SingletonHolder.INSTANCE;
    }

    private static class SingletonHolder {
        private static final ThreadSelector INSTANCE = new ThreadSelector();

        private SingletonHolder() {
        }
    }
}

