/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.stat.IDataAccumulator;
import com.wily.introscope.agent.stat.IIntegerRateDataAccumulator;
import com.wily.introscope.agent.trace.ASingleMetricTracerFactory;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.stat.blame.BlameStackSnapshot;
import com.wily.util.properties.AttributeListing;
import com.wily.wilyassert.Assertion;

public class MethodResultRateTracer
extends ASingleMetricTracerFactory {
    public MethodResultRateTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
    }

    @Override
    public void ITracer_startTrace(int tracerIndex, InvocationData data) {
        this.addToBlameStackIfEnabled(data);
    }

    @Override
    protected final IDataAccumulator createDataAccumulator(String formattedMetricName) {
        return this.getDataAccumulatorFactory().safeGetIntegerRateDataAccumulator(formattedMetricName);
    }

    @Override
    public void ITracer_finishTrace(int tracerIndex, InvocationData data) {
        BlameStackSnapshot snapshot = this.removeFromBlameStackIfEnabledAndReturnSnapshot(data);
        IIntegerRateDataAccumulator rate = (IIntegerRateDataAccumulator)this.getDataAccumulator(data);
        if (!rate.IDataAccumulator_isShutOff()) {
            if (data.hasMethodResultAvailable()) {
                Object returnValue = data.getInvocationReturnValueAsObject();
                if (returnValue == null) {
                    return;
                }
                if (returnValue instanceof Number) {
                    int returnValueAsInt = ((Number)returnValue).intValue();
                    rate.IIntegerRateDataAccumulator_addBatchIncidents(returnValueAsInt, snapshot);
                } else {
                    Assertion.wilyAssert("Instrumented method return value is not a Number");
                }
            } else {
                Assertion.wilyAssert("Instrumented method has no return value");
            }
        }
    }
}

