/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.servletheaderdecorator.common;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.servletheaderdecorator.common.MutableInteger;
import com.wily.introscope.agent.servletheaderdecorator.common.ThreadLevelReentrancyDummy;
import com.wily.introscope.agent.trace.ATracerFactory;
import com.wily.introscope.agent.trace.ITracer;
import com.wily.introscope.agent.trace.ITracerFactory;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.ReentrancyLevel;
import com.wily.util.properties.AttributeListing;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public final class ThreadLevelReentrancyDelegator
extends ATracerFactory {
    private ThreadLocal stackDepthLocal = new ThreadLocal(){

        public Object initialValue() {
            return new MutableInteger();
        }
    };
    public static final String kstDelegateClassParamName = "delegatetracer";
    private ITracerFactory delegate = null;
    private ThreadLevelReentrancyDummy dummy = null;

    public static String getTracerName() {
        return "ThreadLevelReentrancyDelegator";
    }

    public ThreadLevelReentrancyDelegator(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
        String delegateName = this.getParameter(kstDelegateClassParamName);
        if (kstDelegateClassParamName != null) {
            this.dummy = ThreadLevelReentrancyDummy.getInstance();
            try {
                ((Object)((Object)this)).getClass();
                Class<?> delegateClass = Class.forName(delegateName);
                Class[] paramTypes = new Class[]{IAgent.class, AttributeListing.class, ProbeIdentification.class, Object.class};
                Constructor<?> constructor = delegateClass.getConstructor(paramTypes);
                Object[] argl = new Object[]{agent, parameters, probe, sampleTracedObject};
                this.delegate = (ITracerFactory)constructor.newInstance(argl);
            }
            catch (ClassNotFoundException t) {
                this.getModuleFeedback().error(ThreadLevelReentrancyDelegator.getTracerName() + ": Cannot load delegate tracer: \"" + delegateName + "\".  Check your PBD.");
                this.getModuleFeedback().verbose((Throwable)t);
            }
            catch (NoSuchMethodException t) {
                this.getModuleFeedback().error(ThreadLevelReentrancyDelegator.getTracerName() + ": Cannot find constructor for delegate tracer: \"" + delegateName + "\".  Are you sure this is a tracer?");
                this.getModuleFeedback().verbose((Throwable)t);
            }
            catch (SecurityException t) {
                this.getModuleFeedback().error(ThreadLevelReentrancyDelegator.getTracerName() + ": Security exception with constructor for delegate tracer: \"" + delegateName + "\"");
                this.getModuleFeedback().verbose((Throwable)t);
            }
            catch (InstantiationException t) {
                this.getModuleFeedback().error(ThreadLevelReentrancyDelegator.getTracerName() + ": InstantiationException while constructing delegate tracer factory: \"" + delegateName + "\". Are you trying to instantiate an abstract tracer?");
                this.getModuleFeedback().verbose((Throwable)t);
            }
            catch (InvocationTargetException t) {
                this.getModuleFeedback().error(ThreadLevelReentrancyDelegator.getTracerName() + ": InvocationTargetException while constructing delegate tracer factory: \"" + delegateName + "\".");
                this.getModuleFeedback().error(t.getTargetException());
            }
            catch (IllegalAccessException t) {
                this.getModuleFeedback().error(ThreadLevelReentrancyDelegator.getTracerName() + ": IllegalAccessException while constructing delegate tracer factory: \"" + delegateName + "\".  Are you sure this is a tracer?");
                this.getModuleFeedback().verbose((Throwable)t);
            }
            catch (IllegalArgumentException t) {
                this.getModuleFeedback().error(ThreadLevelReentrancyDelegator.getTracerName() + ": IllegalArgumentException while constructing delegate tracer factory: \"" + delegateName + "\".  Are you sure this is a tracer?");
                this.getModuleFeedback().verbose((Throwable)t);
            }
            catch (ExceptionInInitializerError t) {
                this.getModuleFeedback().error(ThreadLevelReentrancyDelegator.getTracerName() + ": ExceptionInInitializerError while constructing delegate tracer factory: \"" + delegateName + "\".  TracerFactory failed static initialization.");
                this.getModuleFeedback().verbose((Throwable)t);
            }
        }
    }

    public int ITracerFactory_getVersion() {
        if (this.delegate == null) {
            return 0;
        }
        return this.delegate.ITracerFactory_getVersion();
    }

    public ReentrancyLevel ITracerFactory_getReentrancyLevel() {
        if (this.delegate == null) {
            return null;
        }
        return this.delegate.ITracerFactory_getReentrancyLevel();
    }

    public boolean ITracerFactory_isShutoff() {
        if (this.delegate == null) {
            return false;
        }
        return this.delegate.ITracerFactory_isShutoff();
    }

    public ITracer ITracerFactory_allocateTracer(int tracerIndex, InvocationData data) {
        MutableInteger stackDepth = (MutableInteger)this.stackDepthLocal.get();
        if (this.delegate == null || this.dummy == null) {
            return null;
        }
        stackDepth.inc();
        if (stackDepth.getValue() == 1) {
            return this.delegate.ITracerFactory_allocateTracer(tracerIndex, data);
        }
        return this.dummy;
    }

    public void ITracerFactory_releaseTracer(int tracerIndex, ITracer tracer) {
        MutableInteger stackDepth = (MutableInteger)this.stackDepthLocal.get();
        stackDepth.dec();
        if (stackDepth.getValue() == 0) {
            this.delegate.ITracerFactory_releaseTracer(tracerIndex, tracer);
        }
    }
}

