/*
 * Decompiled with CFR 0.152.
 */
package com.wily.diagnos.personality.java.classfile.constants;

import com.wily.diagnos.cmp.classfile.DGClassLoadingException;
import com.wily.diagnos.personality.java.classfile.constants.DGConstant;
import com.wily.diagnos.personality.java.classfile.constants.DGConstantPool;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

class DGNameAndTypeConstant
extends DGConstant {
    private int fCPI_name;
    private int fCPI_type;

    DGNameAndTypeConstant(DGConstantPool constantPool, DataInputStream in) throws IOException {
        super(constantPool, 12);
        this.fCPI_name = in.readUnsignedShort();
        this.fCPI_type = in.readUnsignedShort();
    }

    DGNameAndTypeConstant(DGConstantPool constantPool, int index, int cpiName, int cpiType) {
        super(constantPool, 12);
        this.fIndex = index;
        this.fCPI_name = cpiName;
        this.fCPI_type = cpiType;
    }

    @Override
    public void validate() throws DGClassLoadingException {
        this.fPool.validateType(this.fCPI_name, 1);
        this.fPool.validateType(this.fCPI_type, 1);
    }

    public String getName() {
        return this.fPool.getUtf(this.fCPI_name);
    }

    public String getType() {
        return this.fPool.getUtf(this.fCPI_type);
    }

    public String toString() {
        return "# " + this.fIndex + ": Kind = NameAndType (" + this.fTag + ")\n\tName = " + this.getName() + "(" + this.fCPI_name + ")\n\tType = " + this.getType() + "(" + this.fCPI_type + ")";
    }

    @Override
    public void adjustIndices(int delta, int base) {
        if (this.fCPI_name > base) {
            this.fCPI_name += delta;
        }
        if (this.fCPI_type > base) {
            this.fCPI_type += delta;
        }
        super.adjustIndices(delta, base);
    }

    @Override
    public void write(DataOutputStream out) throws IOException {
        out.writeByte(this.fTag);
        out.writeShort(this.fCPI_name);
        out.writeShort(this.fCPI_type);
    }
}

