/*
 * Decompiled with CFR 0.152.
 */
package com.wily.isengard.postofficehub.link.v1;

import com.wily.EDU.oswego.cs.dl.util.concurrent.BoundedChannel;
import com.wily.EDU.oswego.cs.dl.util.concurrent.BoundedLinkedQueue;
import com.wily.EDU.oswego.cs.dl.util.concurrent.Latch;
import com.wily.isengard.api.TransportConfiguration;
import com.wily.isengard.message.AMessage;
import com.wily.isengard.message.PingMessage;
import com.wily.isengard.postoffice.Address;
import com.wily.isengard.postoffice.PostOfficeHub;
import com.wily.isengard.postoffice.PostOfficeSpecifier;
import com.wily.isengard.postofficehub.AddRouteMessage;
import com.wily.isengard.postofficehub.DeliveryItem;
import com.wily.isengard.postofficehub.RemoveRouteMessage;
import com.wily.isengard.postofficehub.Route;
import com.wily.isengard.postofficehub.link.IRemoteTransport;
import com.wily.isengard.postofficehub.link.v1.CaptureOutputStream;
import com.wily.isengard.postofficehub.link.v1.IMessageDeliveryStrategy;
import com.wily.isengard.postofficehub.link.v1.InputStreamBufferer;
import com.wily.isengard.postofficehub.link.v1.TeeInputStream;
import com.wily.isengard.postofficehub.link.v1.TeeOutputStream;
import com.wily.isengard.util.io.DefaultSerializationHandler;
import com.wily.isengard.util.io.ISerializationHandler;
import com.wily.isengard.util.io.ThrowableOnlySerializationHandler;
import com.wily.util.clock.MasterClock;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.io.EncryptInputStream;
import com.wily.util.io.EncryptOutputStream;
import com.wily.util.io.NonSyncBufferedOutputStream;
import com.wily.util.obfuscation.SimpleDecryptor;
import com.wily.util.obfuscation.SimpleEncryptor;
import com.wily.util.thread.DefaultThreadFactory;
import com.wily.util.thread.IThreadFactory;
import com.wily.wilyassert.Assertion;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;

public abstract class ABaseTransport
implements IRemoteTransport {
    public static final Module sModule = new Module("Transport");
    private BoundedChannel fTransmitChannel;
    private PostOfficeHub fPostOfficeHub;
    private volatile boolean fIsClosed;
    private InputStream fInputStream;
    private OutputStream fOutputStream;
    private String fNodeName;
    private IThreadFactory fThreadFactory;
    private TransportConfiguration fTransportConfig;
    private IModuleFeedbackChannel fFeedback;
    private boolean fTransportUp;
    private String fRouteConnectionInfo = "{Unconnected}";
    private final PingMessage fPingMessage = new PingMessage();
    private Address fPingAddress;
    private ISerializationHandler fSerializationHandler;
    private int fIsengardProtocolVersion;
    private final Latch fSetupConnectionLatch = new Latch();
    private IMessageDeliveryStrategy fMessageDeliveryStrategy;
    private CaptureOutputStream fInputStreamCaptureStream = null;
    private CaptureOutputStream fOutputStreamCaptureStream = null;
    private long fLastSlowWarning;
    private static final long kSlowWarningInterval = 3000L;
    private static final long kWaitTimeInMilliseconds = 10000L;
    private static volatile int sConnectionID = 1;
    private static final boolean DEBUG_kPrintMessageCallStackOnErrors = false;
    private static final long kDeliveryMaxTime = 120000L;
    private Object fLastDeliveryCandidate;
    private long fLastDeliveryCheckPoint = MasterClock.currentTimeMillis();
    private volatile long fOutgoingQueueSlowedTime;
    private final Object fSlowedTimeMonitor = new Object();
    private volatile long fLastSlowWaitTimeStamp;
    private volatile boolean fSlowClientTimeLogged = false;
    private boolean fSlowClientTolerance = true;
    private long fSlowClientDisconnectLimit = 60000L;
    private long fSlowClientTimePeriod = 120000L;
    private static final long sOfferTimeout = ABaseTransport.getOfferTimeout();
    private static final long sDeliveryTimeout = ABaseTransport.getDeliveryTimeout();
    private static final long sDeliveryCheckInterval = sDeliveryTimeout / 5L;

    private static long getOfferTimeout() {
        return ABaseTransport.getPropertyLongValue("wily.MessageOfferTimeOut", 10000L);
    }

    private static long getDeliveryTimeout() {
        return ABaseTransport.getPropertyLongValue("wily.MessageDeliveryTimeOut", 120000L);
    }

    private static long getPropertyLongValue(String name, long defaultValue) {
        long v = 0L;
        try {
            String s = System.getProperty(name);
            if (s != null) {
                v = Long.parseLong(s);
            }
        }
        catch (Exception exception) {}
        if (v > 0L) {
            return v;
        }
        return defaultValue;
    }

    protected ABaseTransport(int version) {
        this.fThreadFactory = new DefaultThreadFactory(true);
        this.fTransportConfig = new TransportConfiguration();
        this.fSerializationHandler = new DefaultSerializationHandler();
        this.fIsengardProtocolVersion = version;
    }

    @Override
    public void setThreadFactory(IThreadFactory factory) {
        if (factory != null) {
            this.fThreadFactory = factory;
        }
    }

    @Override
    public void setTransportConfiguration(TransportConfiguration transportConfig) {
        if (transportConfig != null) {
            this.fTransportConfig = transportConfig;
        }
    }

    @Override
    public void initialize(PostOfficeHub hub) throws IOException {
        this.fPostOfficeHub = hub;
        this.fFeedback = hub.getFeedbackChannel();
        this.fTransmitChannel = new BoundedLinkedQueue(this.fTransportConfig.getOutgoingMessageQueueSize());
        this.fPingAddress = new Address(hub);
        this.fSlowClientTolerance = this.fTransportConfig.isClientTolerant();
        this.fSlowClientDisconnectLimit = this.fTransportConfig.getSlowClientTimeLimit();
        this.fSlowClientTimePeriod = this.fTransportConfig.getSlowClientTimePeriod();
    }

    @Override
    public boolean isClosed() {
        return this.fIsClosed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        ABaseTransport aBaseTransport = this;
        synchronized (aBaseTransport) {
            if (this.isClosed()) {
                return;
            }
            this.fIsClosed = true;
        }
        this.closeRemoteConnection();
        if (this.fMessageDeliveryStrategy != null) {
            this.fMessageDeliveryStrategy.tearDown();
        }
        if (this.fTransmitChannel != null) {
            try {
                while (this.fTransmitChannel.poll(1L) != null) {
                }
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    @Override
    public void sendMessage(AMessage message, Address address) {
        this.sendMessage(message, address, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessage(AMessage message, Address address, boolean dropIfQueueNonEmpty) {
        Assertion.wilyAssert(address != null, "The message address should not be null.");
        int interruptedExceptionCount = 0;
        while (true) {
            try {
                ABaseTransport aBaseTransport = this;
                synchronized (aBaseTransport) {
                    if (this.isClosed()) {
                        return;
                    }
                }
                this.sendMessageInternal(message, address, dropIfQueueNonEmpty);
                return;
            }
            catch (InterruptedException e) {
                if (this.fFeedback.isTraceEnabled(sModule)) {
                    this.fFeedback.trace(sModule, String.valueOf(ABaseTransport.class.getName()) + " " + this.getRouteConnectionInfo(), e);
                }
                if (interruptedExceptionCount >= 100 || ++interruptedExceptionCount != 100) continue;
                this.fFeedback.error(sModule, String.valueOf(ABaseTransport.class.getName()) + " running in tight loop. Already caught " + interruptedExceptionCount + " exceptions while sending outgoing message [" + message + "] to " + this.getRouteConnectionInfo() + ". Further exceptions will not be logged.", e);
                continue;
            }
            break;
        }
    }

    private void sendMessageInternal(AMessage message, Address address, boolean dropIfQueueNonEmpty) throws InterruptedException {
        String msg;
        if (!this.checkIsOutgoingMessageQueueMoving()) {
            return;
        }
        boolean success = false;
        if (dropIfQueueNonEmpty && ((BoundedLinkedQueue)this.fTransmitChannel).size() > 0) {
            return;
        }
        success = this.fTransmitChannel.offer(new DeliveryItem(message, address), 500L);
        if (!success) {
            if (System.currentTimeMillis() > this.fLastSlowWarning + 3000L) {
                this.fLastSlowWarning = System.currentTimeMillis();
                if (this.fFeedback.isVerboseEnabled()) {
                    Object[] args = new Object[]{String.valueOf(((BoundedLinkedQueue)this.fTransmitChannel).size()), this.getRouteConnectionInfo(), String.valueOf(sOfferTimeout)};
                    msg = MessageFormat.format("Outgoing message queue limit of {0} reached for connection {1}.  Waiting for {2} milliseconds ", args);
                    this.fFeedback.verbose(msg);
                }
            }
            if (System.currentTimeMillis() > this.fLastSlowWaitTimeStamp + this.fSlowClientTimePeriod) {
                this.safeSetOutgoingQueueSlowedTime(0L);
                this.fLastSlowWaitTimeStamp = System.currentTimeMillis();
                this.fSlowClientTimeLogged = false;
            }
            long start = System.currentTimeMillis();
            success = this.fTransmitChannel.offer(new DeliveryItem(message, address), sOfferTimeout);
            this.safeIncrementOutgoingQueueSlowedTime(System.currentTimeMillis() - start);
            if (this.fFeedback.isVerboseEnabled() && !this.fSlowClientTimeLogged && !this.fSlowClientTolerance && this.fOutgoingQueueSlowedTime > this.fSlowClientDisconnectLimit / 2L) {
                this.fSlowClientTimeLogged = true;
                long slowedInTimePeriod = System.currentTimeMillis() - this.fLastSlowWaitTimeStamp;
                Object[] args = new Object[]{String.valueOf(this.fOutgoingQueueSlowedTime), String.valueOf(slowedInTimePeriod), this.getRouteConnectionInfo()};
                String msg2 = MessageFormat.format("Collective wait time of {0} ms in the last {1} ms adding messages to outgoing queue by client {2}", args);
                this.fFeedback.verbose(msg2);
            }
        }
        if (!success) {
            Object[] args = new Object[]{String.valueOf(((BoundedLinkedQueue)this.fTransmitChannel).size()), this.getRouteConnectionInfo()};
            msg = MessageFormat.format("Timed out adding to outgoing message queue. Limit of {0} reached. Terminating connection: {1}", args);
            this.fFeedback.warn(msg);
            this.close();
            return;
        }
        if (!this.fSlowClientTolerance && this.fOutgoingQueueSlowedTime > this.fSlowClientDisconnectLimit) {
            long slowedInTimePeriod = System.currentTimeMillis() - this.fLastSlowWaitTimeStamp;
            Object[] args = new Object[]{String.valueOf(this.fOutgoingQueueSlowedTime), String.valueOf(slowedInTimePeriod), this.getRouteConnectionInfo()};
            String msg3 = MessageFormat.format("Collective wait time of {0} ms in the last {1} ms adding messages to outgoing queue. Terminating connection: {2}", args);
            this.fFeedback.warn(msg3);
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void safeSetOutgoingQueueSlowedTime(long time) {
        Object object = this.fSlowedTimeMonitor;
        synchronized (object) {
            this.fOutgoingQueueSlowedTime = time;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void safeIncrementOutgoingQueueSlowedTime(long time) {
        Object object = this.fSlowedTimeMonitor;
        synchronized (object) {
            this.fOutgoingQueueSlowedTime += time;
        }
    }

    private boolean checkIsOutgoingMessageQueueMoving() {
        long thisDeliveryCheckTime = MasterClock.currentTimeMillis();
        if (thisDeliveryCheckTime > this.fLastDeliveryCheckPoint + sDeliveryCheckInterval) {
            Object thisDeliveryCandidate = this.fTransmitChannel.peek();
            if (thisDeliveryCandidate != this.fLastDeliveryCandidate) {
                this.fLastDeliveryCheckPoint = thisDeliveryCheckTime;
                this.fLastDeliveryCandidate = thisDeliveryCandidate;
            } else if (thisDeliveryCandidate != null) {
                if (System.currentTimeMillis() > this.fLastSlowWarning + sDeliveryCheckInterval) {
                    this.fLastSlowWarning = System.currentTimeMillis();
                    if (this.fFeedback.isVerboseEnabled()) {
                        this.fFeedback.verbose("Outgoing message queue is moving slowly: " + this.getRouteConnectionInfo());
                    }
                }
                if (thisDeliveryCheckTime > this.fLastDeliveryCheckPoint + sDeliveryTimeout) {
                    this.fFeedback.warn("Outgoing message queue is not moving. Terminating connection: " + this.getRouteConnectionInfo());
                    this.close();
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public void routeUp(Route route) {
        PostOfficeSpecifier routeName = route.getPostOffice();
        this.sendMessage(new AddRouteMessage(routeName, route.getHops()), new Address(this.fPostOfficeHub));
    }

    @Override
    public void routeDown(Route route) {
        PostOfficeSpecifier routeName = route.getPostOffice();
        this.sendMessage(new RemoveRouteMessage(routeName), new Address(this.fPostOfficeHub));
    }

    @Override
    public String getRouteConnectionInfo() {
        return this.fRouteConnectionInfo;
    }

    @Override
    public int getIsengardProtocolVersion() {
        return this.fIsengardProtocolVersion;
    }

    @Override
    public void pingRemoteHost() throws Exception {
        this.fSetupConnectionLatch.acquire();
        this.sendMessage(this.fPingMessage, this.fPingAddress, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyTransportDown() {
        ABaseTransport aBaseTransport = this;
        synchronized (aBaseTransport) {
            if (!this.fTransportUp) {
                return;
            }
            this.fTransportUp = false;
        }
        this.fPostOfficeHub.notifyTransportDown(this);
    }

    public InputStream getInputStream() {
        return this.fInputStream;
    }

    public OutputStream getOutputStream() {
        return this.fOutputStream;
    }

    public ISerializationHandler getSerializationHandler() {
        return this.fSerializationHandler;
    }

    public IModuleFeedbackChannel getFeedbackChannel() {
        return this.fFeedback;
    }

    public IThreadFactory getThreadFactory() {
        return this.fThreadFactory;
    }

    public PostOfficeHub getPostOfficeHub() {
        return this.fPostOfficeHub;
    }

    public TransportConfiguration getTransportConfiguration() {
        return this.fTransportConfig;
    }

    public Latch getSetupConnectionLatch() {
        return this.fSetupConnectionLatch;
    }

    protected DataStreams createStreams(InputStream in, OutputStream out, boolean useEventBasedIncomingIO) throws IOException {
        this.fInputStream = this.decorateInputStream(in, useEventBasedIncomingIO);
        this.fOutputStream = this.decorateOutputStream(out);
        if (this.fInputStreamCaptureStream != null) {
            this.fInputStreamCaptureStream.setPeer(this.fOutputStreamCaptureStream);
        }
        if (this.fOutputStreamCaptureStream != null) {
            this.fOutputStreamCaptureStream.setPeer(this.fInputStreamCaptureStream);
        }
        return new DataStreams(this.fInputStream, this.fOutputStream);
    }

    protected void setNodeName(String nodeName) {
        this.fNodeName = nodeName;
    }

    public String getNodeName() {
        return this.fNodeName;
    }

    protected void setSerializationHandler(int mode) throws IOException {
        ISerializationHandler handler = null;
        if (mode == 48) {
            handler = new DefaultSerializationHandler();
        } else if (mode == 49) {
            handler = new ThrowableOnlySerializationHandler(this.getFeedbackChannel(), sModule);
        } else {
            throw new IOException("Unrecognized serialization mode: " + mode);
        }
        this.fSerializationHandler = handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void completeConnection(DataStreams streams, IMessageDeliveryStrategy deliveryStrategy, boolean outgoingConnection) throws IOException {
        int connectionID = 0;
        Class<ABaseTransport> clazz = ABaseTransport.class;
        synchronized (ABaseTransport.class) {
            connectionID = sConnectionID++;
            // ** MonitorExit[var5_5] (shouldn't be in output)
            String recvName = String.valueOf(this.fPostOfficeHub.getHubName()) + " Hub Receive " + connectionID;
            String transmitName = String.valueOf(this.fPostOfficeHub.getHubName()) + " Hub Transmit " + connectionID;
            try {
                deliveryStrategy.setUp(recvName, transmitName, outgoingConnection);
                this.fMessageDeliveryStrategy = deliveryStrategy;
                ABaseTransport aBaseTransport = this;
                synchronized (aBaseTransport) {
                    this.fTransportUp = true;
                }
            }
            finally {
                this.fSetupConnectionLatch.release();
            }
            this.updateRouteConnectionInfo();
            this.fPostOfficeHub.notifyTransportUp(this);
            return;
        }
    }

    protected abstract boolean isTrafficObfuscated();

    public void routeMessage(AMessage message, Address destination) {
        this.fPostOfficeHub.notifyMessageReceived(message, destination, this);
    }

    public BoundedChannel getTransmitChannel() {
        return this.fTransmitChannel;
    }

    protected InputStream decorateInputStream(InputStream input, boolean useEventBasedIncomingIO) {
        OutputStream logStream;
        if (!useEventBasedIncomingIO) {
            input = InputStreamBufferer.bufferStream(input);
        }
        if (this.isTrafficObfuscated()) {
            input = new EncryptInputStream(input, new SimpleDecryptor(180150000));
        }
        if ((logStream = this.fTransportConfig.getCaptureLogStream()) != null) {
            this.fInputStreamCaptureStream = new CaptureOutputStream("Rx", logStream, this.fTransportConfig.getCaptureLogLimit());
            input = new TeeInputStream(input, this.fInputStreamCaptureStream, true);
        }
        return input;
    }

    protected OutputStream decorateOutputStream(OutputStream output) {
        OutputStream logStream;
        output = new NonSyncBufferedOutputStream(output);
        if (this.isTrafficObfuscated()) {
            output = new EncryptOutputStream(output, new SimpleEncryptor(180150000));
        }
        if ((logStream = this.fTransportConfig.getCaptureLogStream()) != null) {
            this.fOutputStreamCaptureStream = new CaptureOutputStream("Tx", logStream, this.fTransportConfig.getCaptureLogLimit());
            output = new TeeOutputStream(output, this.fOutputStreamCaptureStream);
        }
        return output;
    }

    private void updateRouteConnectionInfo() {
        StringBuffer connectionInfo = new StringBuffer();
        connectionInfo.append("Node=").append(this.fNodeName).append(", ");
        connectionInfo.append("Address=").append(this.getRemoteAddress()).append(":").append(this.getRemotePort()).append(", ");
        connectionInfo.append("Type=").append(this.getType());
        this.fRouteConnectionInfo = connectionInfo.toString();
    }

    public void incrementCorruptedMessageCount() {
        this.fPostOfficeHub.incrementCorruptedMessageCount();
    }

    protected static class DataStreams {
        private final DataOutputStream fDataOutput;
        private final DataInputStream fDataInput;

        private DataStreams(InputStream input, OutputStream output) {
            this.fDataInput = new DataInputStream(input);
            this.fDataOutput = new DataOutputStream(output);
        }

        public DataInputStream getDataInputStream() {
            return this.fDataInput;
        }

        public DataOutputStream getDataOutputStream() {
            return this.fDataOutput;
        }
    }
}

