/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.webservices.extension.agent.trace.nameformatter;

import com.wily.introscope.agent.transactiontrace.CorrelationId;
import com.wily.powerpack.webservices.KConstants;
import com.wily.powerpack.webservices.WSMUtils;
import java.util.HashMap;

public class WSFlexibleUtil
implements KConstants {
    public static final String CorrelationReplaceExpression = "(?:CORRELATION_NAMESPACE)+";
    public static final String CorrelationInsertionExpression = "(?:correlationid)+";
    public static final String LocalCorrelationId = "Local_CorrelationId";
    public static final String LocalCorrelationId2 = "Local_CorrelationId2";
    public static final String SpaceReplacementExpression = "(?: )+";

    public static final String getDynamicParamsString(String formattedName) throws Exception {
        String formattingName = null;
        int startIndex = formattedName.indexOf("{DynamicParams");
        if (startIndex == -1) {
            throw new Exception("'{' is missing in trace param schema. ");
        }
        formattingName = formattedName.substring(startIndex);
        int finishIndex = formattingName.indexOf("}");
        if (finishIndex == -1) {
            throw new Exception("'}' is missing in trace param schema. ");
        }
        formattingName = formattingName.substring("{DynamicParams".length(), finishIndex);
        return formattingName;
    }

    public static final String processNamespace(String formattedName) {
        return formattedName.replaceAll(CorrelationReplaceExpression, "http://www.ca.com/apm");
    }

    public static final String processClientString(String formattedName, String correlationString) {
        correlationString = correlationString.replaceAll(SpaceReplacementExpression, "SPACEQQ");
        WSMUtils.getLogger().debug("WSFlexibleUtil processClientString correlationString=" + correlationString);
        return WSFlexibleUtil.processNamespace(formattedName.replaceAll(CorrelationInsertionExpression, correlationString));
    }

    public static final String createCorrelationString(Class cache) throws Exception {
        String correlationString = (String)WSMUtils.invokeMethodOnClass(cache, "getCorrelationContext");
        WSMUtils.getLogger().debug("WSFlexibleUtil createCorrelationString correlationString=" + correlationString);
        return correlationString.substring(correlationString.indexOf("=") + 1);
    }

    public static final void setCorrelationId(HashMap dynamicProperties) throws Exception {
        String returnCorrelationId = (String)dynamicProperties.get(LocalCorrelationId);
        if (returnCorrelationId != null && !returnCorrelationId.equals("")) {
            returnCorrelationId = (String)dynamicProperties.get(LocalCorrelationId2);
        }
        if (WSMUtils.getLogger().isDebugEnabled()) {
            WSMUtils.getLogger().debug("WSFlexibleUtil setCorrelationId returnCorrelationId=" + returnCorrelationId);
        }
        if (returnCorrelationId != null && !returnCorrelationId.equals("")) {
            CorrelationId correlationIdTmp = new CorrelationId(returnCorrelationId.toString());
            WSMUtils.getLogger().debug("WSClientFlexibleStartCorrelationTracer correlationId set in cache=" + returnCorrelationId.toString());
        }
    }

    public static final String removeFormatting(String name, String formattedName) {
        if (name != null) {
            int index = name.indexOf("{DynamicParams");
            if (index != -1) {
                String formattingName = name.substring(index);
                name = name.substring(0, index - 1);
                index = formattingName.indexOf("}");
                if (index != -1) {
                    String tailPart = formattingName.substring(index + 1);
                    name = name + formattedName + tailPart;
                } else {
                    WSMUtils.getLogger().debug("WSFlexibleNameFormatter removeFormatting'}' is missing in trace param schema. ");
                }
            } else {
                WSMUtils.getLogger().debug("WSFlexibleNameFormatter removeFormatting'{DynamicParams' is missing in trace param schema. ");
            }
        }
        return name;
    }
}

