/*
 * Decompiled with CFR 0.152.
 */
package com.wily.diagnos.cmp.classmatcher;

import com.wily.diagnos.cmp.classmatcher.ACachingImmutableClassMatcher;
import com.wily.diagnos.cmp.directives.utility.CompilerSettingsUtility;
import com.wily.diagnos.cmp.log.CompilerLogDetails;
import com.wily.diagnos.cmp.log.CompilerLogDetailsSession;
import com.wily.util.HashCodeUtils;
import com.wily.util.classfile.IClassName;
import com.wily.util.classfile.IModeledClass;
import java.util.HashMap;
import java.util.Map;

public class DGAnnotationClassMatcher
extends ACachingImmutableClassMatcher {
    private static final Map<String, DGAnnotationClassMatcher> singleton = new HashMap<String, DGAnnotationClassMatcher>();
    private final IClassName fClassName;

    private DGAnnotationClassMatcher(IClassName className) {
        if (singleton.containsKey(className.getReflectionFriendlyQualifiedNameString())) {
            throw new RuntimeException("Instance already created");
        }
        this.fClassName = className;
    }

    public static DGAnnotationClassMatcher getInstance(IClassName className) {
        String name = className.getReflectionFriendlyQualifiedNameString();
        if (!singleton.containsKey(name)) {
            singleton.put(name, new DGAnnotationClassMatcher(className));
        }
        return singleton.get(name);
    }

    @Override
    public boolean IClassMatcher_matches(IModeledClass cls) {
        boolean result = cls.containsAnnotation(this.fClassName);
        if (result) {
            CompilerLogDetails current = CompilerLogDetailsSession.getCurrent();
            current.setAnnotationName(this.fClassName.getContainerAndPackageAndNameString());
            current.setComment("DGAnnotationClassMatcher detected the annotation name as annotation in the modelled class");
            current.setSkipCause(256);
        }
        return result;
    }

    @Override
    public boolean IClassMatcher_supportsNameMatching() {
        return false;
    }

    @Override
    public boolean IClassMatcher_matches(IClassName className) {
        return false;
    }

    public IClassName getClassName() {
        return this.fClassName;
    }

    public int hashCode() {
        int result = 17;
        result = HashCodeUtils.accumulateHashCode((int)result, (Object)this.fClassName);
        return result;
    }

    public boolean equals(Object obj) {
        if (obj instanceof DGAnnotationClassMatcher) {
            DGAnnotationClassMatcher m = (DGAnnotationClassMatcher)obj;
            return this.fClassName.equals(m.fClassName);
        }
        return false;
    }

    @Override
    public String[] getMatcherKeys() {
        return new String[]{CompilerSettingsUtility.getKeyFromString(this.fClassName.getReflectionFriendlyQualifiedNameString())};
    }
}

