/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.webservices.extension.agent.trace.nameformatter;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.INameFormatter;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.powerpack.webservices.KConstants;
import com.wily.powerpack.webservices.WSMUtils;
import com.wily.powerpack.webservices.extension.agent.trace.nameformatter.DynamicParamsProcessor;
import java.util.HashMap;

public class WSFlexibleNameFormatter
implements INameFormatter,
KConstants {
    private final IAgent fAgent;
    private DynamicParamsProcessor paramsSchema;
    private String dynamicParamSyntax = null;
    private HashMap dynamicProperties = null;

    public WSFlexibleNameFormatter(IAgent agent) {
        this.fAgent = agent;
    }

    public String getServiceName(InvocationData data) {
        return "UnknownService";
    }

    public ClassLoader setClassLoader(ClassLoader cl, IAgent agent) {
        WSMUtils.getLogger().debug("WSFlexibleNameFormatter.setClassLoader()");
        return WSMUtils.setClassLoader(cl, agent);
    }

    protected Class getClassFromInvocationObjectLoader(String className, InvocationData data) throws ClassNotFoundException {
        Class<?> clazz = (Class<?>)data.get(className);
        if (clazz == null) {
            String classNameString = data.getInvocationObject().getClass().getName();
            ClassLoader cl = data.getInvocationObject().getClass().getClassLoader();
            if (classNameString.indexOf("com.wily") >= 0) {
                cl = cl.getParent();
            }
            WSMUtils.getLogger().debug("WSFlexibleNameFormatter.getClassFromInvocationObjectLoader(): " + data.getInvocationObject().getClass().getName());
            ClassLoader classLoader = this.setClassLoader(cl, this.getAgent());
            if (classLoader != null) {
                clazz = classLoader.loadClass(className);
                data.put(className, clazz);
            } else {
                WSMUtils.getLogger().error("WSFlexibleNameFormatter, wsdmclassloader is null");
            }
        }
        return clazz;
    }

    protected IAgent getAgent() {
        return this.fAgent;
    }

    private final String getDynamicParamsString(String formattedName) throws Exception {
        String formattingName = null;
        int startIndex = formattedName.indexOf("{DynamicParams");
        if (startIndex == -1) {
            throw new Exception("'{DynamicParams' is missing in trace param schema. ");
        }
        formattingName = formattedName.substring(startIndex);
        int finishIndex = formattingName.indexOf("}");
        if (finishIndex == -1) {
            throw new Exception("'}' is missing in trace param schema. ");
        }
        formattingName = formattingName.substring("{DynamicParams".length(), finishIndex);
        return formattingName;
    }

    public final String getOperationName() throws Exception {
        String operationName = "";
        try {
            operationName = this.dynamicProperties.get("operationname").toString();
        }
        catch (Exception e) {
            WSMUtils.getLogger().error("WSFlexibleNameFormatter getOperationName exception " + WSMUtils.dumpStackTrace(e));
        }
        WSMUtils.getLogger().debug("WSFlexibleNameFormatter getOperationName operationName=" + operationName);
        return operationName == null || operationName.trim().equals("") ? "UnknownOperationName" : operationName;
    }

    public final String getNamespace() throws Exception {
        String namespace = "";
        try {
            namespace = this.dynamicProperties.get("namespace").toString();
            int questionMarkPos = namespace.indexOf(63);
            if (questionMarkPos != -1) {
                namespace = namespace.substring(0, questionMarkPos);
            }
        }
        catch (Exception e) {
            WSMUtils.getLogger().error("WSFlexibleNameFormatter getNamespace exception " + WSMUtils.dumpStackTrace(e));
        }
        WSMUtils.getLogger().debug("WSFlexibleNameFormatter getNamespace namespace=" + namespace);
        return namespace == null || namespace.trim().equals("") ? "UnknownNamespace" : namespace;
    }

    public final String getServiceName() throws Exception {
        String serviceName = "";
        try {
            serviceName = this.dynamicProperties.get("servicename").toString();
        }
        catch (Exception e) {
            WSMUtils.getLogger().error("WSFlexibleNameFormatter serviceName exception " + WSMUtils.dumpStackTrace(e));
        }
        WSMUtils.getLogger().debug("WSFlexibleNameFormatter getServiceName serviceName=" + serviceName);
        return serviceName == null || serviceName.trim().equals("") ? "UnknownService" : serviceName;
    }

    private final void initialiseParams(String name, InvocationData data) throws Exception {
        if (this.dynamicParamSyntax == null) {
            String dynamicParamSyntax = this.getDynamicParamsString(name);
            this.paramsSchema = DynamicParamsProcessor.getInstance(this.getAgent().IAgent_getModuleFeedback(), dynamicParamSyntax, null);
            this.dynamicProperties = this.paramsSchema.processDynamicParams(data);
        }
    }

    public final String removeFormatting(String name, String formattedName) {
        if (name != null) {
            int index = name.indexOf("{DynamicParams");
            if (index != -1) {
                String formattingName = name.substring(index);
                name = name.substring(0, index - 1);
                index = formattingName.indexOf("}");
                if (index != -1) {
                    String tailPart = formattingName.substring(index + 1);
                    name = name + formattedName + tailPart;
                } else {
                    WSMUtils.getLogger().debug("WSFlexibleNameFormatter removeFormatting'}' is missing in trace param schema. ");
                }
            } else {
                WSMUtils.getLogger().debug("WSFlexibleNameFormatter removeFormatting'{DynamicParams' is missing in trace param schema. ");
            }
        }
        return name;
    }

    public String INameFormatter_format(String name, InvocationData data) {
        String namespace = null;
        String operationName = null;
        String formattedName = null;
        String formattedComponent = null;
        try {
            WSMUtils.refreshLogLevels();
            WSMUtils.getLogger().debug("WSFlexibleNameFormatter INameFormatter_format name=" + name);
            if (name.indexOf("namespace", 0) >= 0) {
                WSMUtils.getLogger().debug("WSFlexibleNameFormatter INameFormatter_format name.indexOf(kNamespacePlaceholder, 0) >= 0");
                namespace = (String)data.get("com.wily.powerpack.webservices.trace.NamespaceKey");
                if (namespace == null || namespace.equals("UnknownService")) {
                    this.initialiseParams(name, data);
                    namespace = this.getNamespace();
                    if (namespace == null) {
                        namespace = "UnknownService";
                    }
                }
                namespace = WSMUtils.formatToBeResourceSafe(namespace);
                data.put("com.wily.powerpack.webservices.trace.NamespaceKey", (Object)namespace);
            } else if (name.indexOf("servicename", 0) >= 0) {
                WSMUtils.getLogger().debug("WSFlexibleNameFormatter INameFormatter_format name.indexOf(kServiceNamePlaceholder, 0) >= 0");
                namespace = (String)data.get("com.wily.powerpack.webservices.trace.NamespaceKey");
                if (namespace == null || namespace.equals("UnknownService")) {
                    this.initialiseParams(name, data);
                    namespace = this.getServiceName();
                    if (namespace == null) {
                        namespace = "UnknownService";
                    }
                }
                namespace = WSMUtils.formatToBeResourceSafe(namespace);
                data.put("com.wily.powerpack.webservices.trace.NamespaceKey", (Object)namespace);
            }
            formattedComponent = "|" + namespace;
            if (name.indexOf("operationname", 0) >= 0) {
                WSMUtils.getLogger().debug("WSFlexibleNameFormatter INameFormatter_format name.indexOf(kOperationNamePlaceholder, 0) >= 0");
                operationName = (String)data.get("com.wily.powerpack.webservices.trace.OperationNameKey");
                if (operationName == null || operationName.equals("UnknownOperationName")) {
                    this.initialiseParams(name, data);
                    operationName = this.getOperationName();
                    if (operationName == null) {
                        operationName = "UnknownOperationName";
                    }
                }
                operationName = WSMUtils.formatToBeResourceSafe(operationName);
                data.put("com.wily.powerpack.webservices.trace.OperationNameKey", (Object)operationName);
                formattedComponent = formattedComponent + "|" + operationName;
            }
            formattedName = this.removeFormatting(name, formattedComponent);
            WSMUtils.getLogger().debug("WSFlexibleNameFormatter INameFormatter_format formattedName =" + formattedName);
        }
        catch (Exception e) {
            WSMUtils.getLogger().error("WSFlexibleNameFormatter INameFormatter_format exception " + WSMUtils.dumpStackTrace(e));
        }
        return formattedName;
    }
}

