/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.webservices.handlers;

import com.wily.powerpack.webservices.extension.wsdm71mmi.FaultInfo;
import com.wily.powerpack.webservices.handlers.WsdmLogger;
import com.wily.powerpack.webservices.handlers.WsdmMessageContext;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Map;
import javax.xml.rpc.handler.HandlerInfo;

public class WsdmHandlerUtil {
    private static WsdmLogger log = new WsdmLogger();
    private static final String CONFIG_OBSERVATION_TYPE = "observationType";
    public static final String sSERVER_OBSERVATION_TYPE = "1";
    public static final String sCLIENT_OBSERVATION_TYPE = "2";
    public static final int SERVER_OBSERVATION_TYPE = 1;
    public static final int CLIENT_OBSERVATION_TYPE = 2;
    private String observerIp;
    private String localhostAdd;
    private static final String OBSERVATION_TYPE = "observationType";

    protected WsdmHandlerUtil() {
        try {
            this.observerIp = InetAddress.getLocalHost().getHostAddress();
            this.localhostAdd = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException uhe) {
            this.observerIp = "";
        }
    }

    public static WsdmHandlerUtil getWsdmHandlerUtil() {
        WsdmHandlerUtil local = Holder.myWsdmHandlerUtil;
        return local;
    }

    public String getObserverIp() {
        return this.observerIp;
    }

    public void observeResponse(WsdmMessageContext context) {
        if (log.isDebugLogging().booleanValue() && context != null) {
            log.debug("observeResponse:operation name: " + context.getOperationName());
            log.debug("observeResponse:operation namespace: " + context.getOperationNameSpace());
        }
        context.setEndTime(System.currentTimeMillis());
    }

    public void observeRequest(WsdmMessageContext context) {
        if (log.isDebugLogging().booleanValue() && context != null) {
            log.debug("observeRequest:operation name: " + context.getOperationName());
            log.debug("observeRequest:operation namespace: " + context.getOperationNameSpace());
        }
        context.setEndTime(System.currentTimeMillis());
    }

    public void spoolFault(WsdmMessageContext context, String faultActor, String faultCode, String faultString, String[] sarr) {
        if (context.getObservationType() == 1) {
            this.sendServerFault(context, faultActor, faultCode, faultString, null, sarr);
        } else {
            this.sendClientFault(context, faultActor, faultCode, faultString, null, sarr);
        }
    }

    private void sendServerFault(WsdmMessageContext context, String faultActor, String faultCode, String faultString, String faultNode, String[] sarr) {
        this.observeFault(context, faultActor, faultCode, faultString, null, sarr);
    }

    private void sendClientFault(WsdmMessageContext context, String faultActor, String faultCode, String faultString, String faultNode, String[] sarr) {
        this.observeFault(context, faultActor, faultCode, faultString, null, sarr);
    }

    private void observeFault(WsdmMessageContext context, String faultActor, String faultCode, String faultString, String faultNode, String[] sarr) {
        context.setEndTime(System.currentTimeMillis());
        FaultInfo faultInfo = new FaultInfo();
        faultInfo.setFaultActor(faultActor);
        faultInfo.setFaultCode(faultCode);
        faultInfo.setFaultNode(faultNode);
        faultInfo.setFaultString(faultString);
        faultInfo.setFaultDetails(sarr);
        faultInfo.setWsdmfault(false);
        context.setFaultInfo(faultInfo);
    }

    public static int getObservationType(HandlerInfo config) {
        Map map = config.getHandlerConfig();
        String observationType = null;
        int oType = 1;
        if (map.containsKey("observationType")) {
            observationType = (String)map.get("observationType");
            if (observationType != null && !observationType.equals("")) {
                oType = observationType != null && observationType.equals(sCLIENT_OBSERVATION_TYPE) ? 2 : 1;
            }
        } else {
            log.error("observation type not determinable from handler configuration, server assumed");
        }
        return oType;
    }

    private static class Holder {
        public static WsdmHandlerUtil myWsdmHandlerUtil = null;

        private Holder() {
        }

        static {
            myWsdmHandlerUtil = new WsdmHandlerUtil();
        }
    }
}

