/*
 * Decompiled with CFR 0.152.
 */
package com.wily.isengard.container;

import com.wily.isengard.IsengardException;
import com.wily.isengard.IsengardStrings;
import com.wily.isengard.container.BeanActivationException;
import com.wily.isengard.container.BeanActivator;
import com.wily.isengard.container.BeanUpdateException;
import com.wily.isengard.container.IContainerControlService;
import com.wily.isengard.container.beans.IsengardBeanDescriptor;
import com.wily.isengard.messageprimitives.ConnectionException;
import com.wily.isengard.messageprimitives.InvalidIsengardInterface;
import com.wily.isengard.messageprimitives.service.MessageServiceFactory;
import com.wily.isengard.messageprimitives.service.RegisteredMessageService;
import com.wily.isengard.postoffice.PostOffice;
import com.wily.isengard.util.tree.EntryAlreadyExistsException;
import com.wily.isengard.util.tree.InvalidPathException;
import com.wily.util.exception.UnexpectedExceptionError;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.text.IStringLocalizer;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public class BeanContainerCore
implements IContainerControlService {
    private static Module sModule = new Module("BeanContainerCore");
    private final PostOffice fPostOffice;
    private final Map fBeans;
    private final Set fInitialBeans;
    private boolean fActive;
    private final RegisteredMessageService fControlService;
    private int fOrder = 0;
    private HashMap fSharedState = new HashMap();
    private String fName;
    private IModuleFeedbackChannel fFeedback;

    public BeanContainerCore(PostOffice postOffice, String containerName) throws EntryAlreadyExistsException, InvalidPathException, ConnectionException {
        this(postOffice, containerName, null);
    }

    public BeanContainerCore(PostOffice postOffice, String containerName, ClassLoader classLoader) throws EntryAlreadyExistsException, InvalidPathException, ConnectionException {
        ClassLoader cl;
        this.fPostOffice = postOffice;
        this.fFeedback = postOffice.getFeedbackChannel();
        this.fName = containerName;
        this.fBeans = new HashMap();
        this.fInitialBeans = new HashSet();
        try {
            this.fControlService = new RegisteredMessageService(this.fPostOffice);
            this.fControlService.registerService(IContainerControlService.class, containerName, this);
        }
        catch (InvalidIsengardInterface e) {
            throw new UnexpectedExceptionError(e);
        }
        this.fActive = true;
        ClassLoader classLoader2 = cl = classLoader == null ? this.getClass().getClassLoader() : classLoader;
        if (this.getFeedbackChannel().isDebugEnabled(sModule)) {
            IStringLocalizer localizer = IsengardStrings.getInstance(this.getFeedbackChannel(), cl).getStringLocalizer();
            this.getFeedbackChannel().debug(sModule, localizer.IStringLocalizer_getFormattedLocalizedString("BEAN_CONTAINER_CORE_ACTIVATION", containerName));
        }
    }

    public static IContainerControlService getContainerControlService(PostOffice po, String containerName) throws ConnectionException {
        return MessageServiceFactory.getInterface(po, IContainerControlService.class, containerName);
    }

    public synchronized boolean isActive() {
        return this.fActive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void passivate() {
        BeanContainerCore beanContainerCore = this;
        synchronized (beanContainerCore) {
            this.fActive = false;
        }
        LinkedList beans = new LinkedList(this.fBeans.values());
        Collections.sort(beans, new BeanActivatorComparator());
        for (BeanActivator activator : beans) {
            activator.passivateBean();
        }
        this.fBeans.clear();
        beans.clear();
        beans.addAll(this.fInitialBeans);
        Collections.sort(beans, new BeanActivatorComparator());
        for (BeanActivator activator : beans) {
            activator.passivateBean();
        }
        this.fInitialBeans.clear();
        beans.clear();
        this.fControlService.close();
        this.fActive = false;
    }

    private void passivateBean(String name) {
        BeanActivator activator = (BeanActivator)this.fBeans.get(name);
        if (activator != null) {
            activator.passivateBean();
        }
    }

    @Override
    public synchronized void addBean(IsengardBeanDescriptor bean) throws BeanActivationException {
        if (!this.fActive) {
            throw new BeanActivationException("Container Closed");
        }
        BeanActivator activator = new BeanActivator(this, this.fOrder++, bean);
        activator.activateBean();
        BeanActivator oldBean = this.fBeans.put(bean.getInstanceName(), activator);
        if (oldBean != null) {
            oldBean.passivateBean();
        }
    }

    @Override
    public synchronized Object updateBean(IsengardBeanDescriptor bean, Object data) throws BeanUpdateException {
        try {
            BeanActivator activator = (BeanActivator)this.fBeans.get(bean.getInstanceName());
            return activator.getBean().updateInstanceData(data);
        }
        catch (IsengardException e) {
            throw new BeanUpdateException(e);
        }
    }

    @Override
    public synchronized void removeBean(IsengardBeanDescriptor bean) {
        String beanName = bean.getInstanceName();
        this.passivateBean(beanName);
        this.fBeans.remove(beanName);
    }

    public PostOffice getPostOffice() {
        return this.fPostOffice;
    }

    public IModuleFeedbackChannel getFeedbackChannel() {
        return this.fFeedback;
    }

    @Override
    public void shutdownContainer() {
        this.passivate();
    }

    public synchronized Object getSharedState(Object key) {
        return this.fSharedState.get(key);
    }

    public synchronized void setSharedState(Object key, Object value) {
        this.fSharedState.put(key, value);
    }

    public String getName() {
        return this.fName;
    }

    private static class BeanActivatorComparator
    implements Comparator {
        private BeanActivatorComparator() {
        }

        public int compare(Object o1, Object o2) {
            BeanActivator bean1 = (BeanActivator)o1;
            BeanActivator bean2 = (BeanActivator)o2;
            return bean2.fStartupOrder - bean1.fStartupOrder;
        }
    }
}

