/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.heartbeat;

import com.wily.util.IComparer;
import com.wily.util.adt.PriorityQueue;
import com.wily.util.clock.MasterClock;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.feedback.SeverityLevel;
import com.wily.util.heartbeat.IRegisteredBehavior;
import com.wily.util.heartbeat.ITimestampedRunnable;
import com.wily.util.text.IStringLocalizer;
import com.wily.util.thread.DefaultThreadFactory;
import com.wily.util.thread.IThreadFactory;
import com.wily.wilyassert.Assertion;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;

public final class IntervalHeartbeat {
    public static final boolean kRunFirst = true;
    public static final boolean kWaitFirst = false;
    public static final boolean kActive = true;
    public static final boolean kInactive = false;
    private static final Module sModule = new Module("IntervalHeartbeat");
    private final String fName;
    private final IModuleFeedbackChannel fFeedback;
    private final IStringLocalizer fLocalizer;
    private final Thread fUnderlyingThread;
    private BehaviorNode fCurrentlyExecuting;
    private ArrayList fBehaviorList;
    private PriorityQueue fBehaviorQueue;
    private long fMinimumPeriodInMillis;
    private boolean fDead;
    private long fLastSystemTimeInMillis;
    private static final long kMaxClockAdjustInMillis = 15000L;
    protected static final long kMaxBehaviorExecTime = 60000L;
    private static final long kCheckBehaviorInterval = 120000L;
    private boolean fDebug = false;
    private static final ArrayList sStartedHeartbeats = new ArrayList();
    private static BehaviorNode[] kEmptyBehaviorNodeArray = new BehaviorNode[0];
    private static Object sCheckBehaviorLock = new Object();
    private static long sLastCheckBehaviorTime = 0L;

    public IntervalHeartbeat(String name, IThreadFactory threadFactory, IModuleFeedbackChannel feedback, IStringLocalizer localizer, long minimumPeriodInMillis) {
        Assertion.wilyAssert(false);
        this.fName = name;
        this.fFeedback = feedback;
        this.fLocalizer = localizer;
        this.fUnderlyingThread = threadFactory.IThreadFactory_createNewThread(String.valueOf(name) + " Heartbeat", new HeartbeatRunnable());
        this.fBehaviorList = new ArrayList();
        this.fBehaviorQueue = new PriorityQueue(new NodeComparer());
        this.fCurrentlyExecuting = null;
        this.fMinimumPeriodInMillis = minimumPeriodInMillis;
        this.fLastSystemTimeInMillis = MasterClock.currentTimeMillis();
        this.fDebug = feedback.isDebugEnabled(sModule);
    }

    public IntervalHeartbeat(String name, IModuleFeedbackChannel feedback, IStringLocalizer localizer, long minimumPeriodInMillis) {
        this(name, new DefaultThreadFactory(true), feedback, localizer, minimumPeriodInMillis);
    }

    public IntervalHeartbeat(String name, IModuleFeedbackChannel feedback, IStringLocalizer localizer) {
        this(name, feedback, localizer, 0L);
    }

    public IntervalHeartbeat(String name, IThreadFactory threadFactory, IModuleFeedbackChannel feedback, IStringLocalizer localizer) {
        this(name, threadFactory, feedback, localizer, 0L);
    }

    public IModuleFeedbackChannel getModuleFeedback() {
        return this.fFeedback;
    }

    public IStringLocalizer getStringLocalizer() {
        return this.fLocalizer;
    }

    public String getName() {
        return this.fName;
    }

    public long getMinimumPeriodInMillis() {
        return this.fMinimumPeriodInMillis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getBehaviorCount() {
        Object object = this.getStateLock();
        synchronized (object) {
            return this.fBehaviorList.size();
        }
    }

    public IRegisteredBehavior addBehavior(ITimestampedRunnable target, String name, boolean initiallyActive, long delayInMillis, boolean runFirst) {
        BehaviorNode result = new BehaviorNode(MasterClock.currentTimeMillis(), target, name, initiallyActive, delayInMillis, this.computeActualDelay(delayInMillis), runFirst);
        this.addBehaviorCommon(result);
        return result;
    }

    public IRegisteredBehavior addBehavior(ITimestampedRunnable target, String name, boolean initiallyActive, long delayInMillis, long firstRunTime) {
        BehaviorNode result = new BehaviorNode(MasterClock.currentTimeMillis(), target, name, initiallyActive, delayInMillis, this.computeActualDelay(delayInMillis), firstRunTime);
        this.addBehaviorCommon(result);
        return result;
    }

    public IRegisteredBehavior addBehavior(ITimestampedRunnable target, String name, boolean initiallyActive, long delayInMillis, boolean runFirst, int totalExecutionCount) {
        Assertion.wilyAssert(false);
        if (totalExecutionCount <= 0) {
            totalExecutionCount = 1;
        }
        BehaviorNode result = new BehaviorNode(MasterClock.currentTimeMillis(), target, name, initiallyActive, delayInMillis, this.computeActualDelay(delayInMillis), runFirst, totalExecutionCount);
        this.addBehaviorCommon(result);
        return result;
    }

    public boolean removeBehavior(IRegisteredBehavior behavior) {
        Assertion.wilyAssert(false, "null behavior in IntervalHeartbeat.removeBehavior");
        return this.removeCommon(behavior);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncAllBehaviors() {
        Object object = this.getStateLock();
        synchronized (object) {
            long now = MasterClock.currentTimeMillis();
            BehaviorNode[] all = (BehaviorNode[])this.fBehaviorQueue.toArray(kEmptyBehaviorNodeArray);
            int i = 0;
            while (i < all.length) {
                BehaviorNode b = all[i];
                b.scheduleBasedOnRunFirstFlagAndFirstRunTime(now);
                ++i;
            }
            this.fBehaviorQueue = new PriorityQueue(new NodeComparer(), all.length);
            i = 0;
            while (i < all.length) {
                this.fBehaviorQueue.insert(all[i]);
                ++i;
            }
            if (all.length != 0) {
                this.interruptUnderlyingThreadIfNecessary();
            }
        }
    }

    public void start() {
        try {
            IntervalHeartbeat.audit_track(this);
            this.fUnderlyingThread.start();
        }
        catch (IllegalThreadStateException illegalThreadStateException) {}
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addBehaviorCommon(BehaviorNode node) {
        Object object = this.getStateLock();
        synchronized (object) {
            this.fBehaviorList.add(node);
            if (node.isActive()) {
                this.fBehaviorQueue.insert(node);
            }
            this.interruptUnderlyingThreadIfNecessary();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeCommon(IRegisteredBehavior behavior) {
        Object object = this.getStateLock();
        synchronized (object) {
            boolean queueResult = false;
            boolean listResult = false;
            listResult = this.fBehaviorList.remove(behavior);
            if (behavior.IRegisteredBehavior_isActive()) {
                if (behavior == this.fCurrentlyExecuting) {
                    this.fCurrentlyExecuting.markAsDeleted();
                    queueResult = true;
                } else {
                    queueResult = this.fBehaviorQueue.remove(behavior);
                }
            } else {
                queueResult = true;
            }
            return listResult && queueResult;
        }
    }

    private void removeBehaviorIgnoringFailures(IRegisteredBehavior behavior) {
        this.removeCommon(behavior);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tearDownIntervalHeartbeat() {
        this.setDead();
        Object object = this.getStateLock();
        synchronized (object) {
            this.interruptUnderlyingThreadIfNecessary();
        }
    }

    private Object getStateLock() {
        return this;
    }

    private Thread getUnderlyingThread() {
        return this.fUnderlyingThread;
    }

    private void interruptUnderlyingThreadIfNecessary() {
        if (this.fCurrentlyExecuting == null) {
            this.getUnderlyingThread().interrupt();
        }
    }

    private long computeActualDelay(long requestedDelayInMillis) {
        Assertion.wilyAssert(false);
        if (requestedDelayInMillis >= this.getMinimumPeriodInMillis()) {
            return requestedDelayInMillis;
        }
        return this.getMinimumPeriodInMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isQueueEmpty() {
        Object object = this.getStateLock();
        synchronized (object) {
            return this.fBehaviorQueue.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long executeNextBehaviorAndCalculateSleepTime() {
        if (this.isQueueEmpty()) {
            return 0L;
        }
        long now = MasterClock.currentTimeMillis();
        if (this.fLastSystemTimeInMillis - now > 15000L) {
            this.getModuleFeedback().logImmediate(SeverityLevel.WARN, sModule, this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("System_Clock_Turned_Back_Message", Long.toString(15L)));
            Object object = this.getStateLock();
            synchronized (object) {
                BehaviorNode[] nodes = (BehaviorNode[])this.fBehaviorQueue.toArray(new BehaviorNode[this.fBehaviorQueue.getSize()]);
                int i = 0;
                while (nodes.length > i) {
                    BehaviorNode node = nodes[i];
                    if (node.getNextExecutionAppointment() > node.getActualDelayInMillis() + now && this.fBehaviorQueue.remove(node)) {
                        node.scheduleForNowPlusDelay(now);
                        this.fBehaviorQueue.insert(node);
                    }
                    ++i;
                }
            }
        }
        this.fLastSystemTimeInMillis = now;
        BehaviorNode behaviorNode = this.computeNextStep(now);
        if (behaviorNode != null) {
            behaviorNode.execute(now);
        }
        long waitPeriod = this.reinsertAndComputeWaitTime(behaviorNode, now);
        IntervalHeartbeat.checkForStuckBehaviors(this.fFeedback, now);
        return waitPeriod;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BehaviorNode computeNextStep(long now) {
        Assertion.wilyAssert(false);
        Object object = this.getStateLock();
        synchronized (object) {
            BehaviorNode bNode = (BehaviorNode)this.fBehaviorQueue.peek();
            if (bNode.isEligible(now)) {
                this.fCurrentlyExecuting = (BehaviorNode)this.fBehaviorQueue.dequeue();
                Thread.interrupted();
                return this.fCurrentlyExecuting;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long reinsertAndComputeWaitTime(BehaviorNode node, long now) {
        Object object = this.getStateLock();
        synchronized (object) {
            if (node != null) {
                if (node.shouldRequeue()) {
                    this.fBehaviorQueue.insert(node);
                } else if (node.isCountdown() && node.finishedCountingDown()) {
                    this.removeBehaviorIgnoringFailures(node);
                }
                this.fCurrentlyExecuting = null;
            }
            BehaviorNode newHead = (BehaviorNode)this.fBehaviorQueue.peek();
            long result = 0L;
            if (newHead != null) {
                result = newHead.computeWaitTimeInMillis(now);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void waitForBehaviorIfEmpty() {
        Object object = this.getStateLock();
        synchronized (object) {
            while (this.isQueueEmpty()) {
                if (this.isDead()) {
                    return;
                }
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changeEnableState(BehaviorNode node, boolean newState) {
        Object object = this.getStateLock();
        synchronized (object) {
            boolean current = node.isActive();
            if (current != newState) {
                if (this.fBehaviorList.contains(node) && this.fCurrentlyExecuting != node) {
                    if (newState) {
                        Assertion.wilyAssert(false);
                        this.fBehaviorQueue.insert(node);
                    } else {
                        Assertion.wilyAssert(false);
                        this.fBehaviorQueue.remove(node);
                    }
                    this.interruptUnderlyingThreadIfNecessary();
                }
                node.setActive(newState);
            }
        }
    }

    private void setDead() {
        this.fDead = true;
    }

    private boolean isDead() {
        return this.fDead;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void audit_track(IntervalHeartbeat heartbeat) {
        ArrayList arrayList = sStartedHeartbeats;
        synchronized (arrayList) {
            sStartedHeartbeats.add(new WeakReference<IntervalHeartbeat>(heartbeat));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void auditStartedHeartbeats(IAuditIntervalHeartBeatAction action) {
        ArrayList arrayList = sStartedHeartbeats;
        synchronized (arrayList) {
            Iterator it = sStartedHeartbeats.iterator();
            while (it.hasNext()) {
                WeakReference ref = (WeakReference)it.next();
                IntervalHeartbeat heartbeat = (IntervalHeartbeat)ref.get();
                if (heartbeat == null) {
                    it.remove();
                    continue;
                }
                action.auditHeartbeat(heartbeat);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkForStuckBehaviors(IModuleFeedbackChannel fb, long nowInMillis) {
        final IModuleFeedbackChannel feedback = fb;
        final long now = nowInMillis;
        Object object = sCheckBehaviorLock;
        synchronized (object) {
            if (sLastCheckBehaviorTime + 120000L > now) {
                return;
            }
            sLastCheckBehaviorTime = now;
        }
        feedback.debug("Checking IntervalHeartbeats.");
        IntervalHeartbeat.auditStartedHeartbeats(new IAuditIntervalHeartBeatAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void auditHeartbeat(IntervalHeartbeat heartbeat) {
                Object object = heartbeat.getStateLock();
                synchronized (object) {
                    Object[] allNodes = heartbeat.fBehaviorList.toArray();
                    int x = 0;
                    while (x < allNodes.length) {
                        long execTime;
                        BehaviorNode current = (BehaviorNode)allNodes[x];
                        if (current != null && (execTime = current.computeExecutionTimeInMillis(now)) > 60000L) {
                            feedback.warn("Heartbeat: " + heartbeat.getName() + ", Behavior: " + current.getName() + " has been running for excessively long time (" + execTime + " ms).");
                        }
                        ++x;
                    }
                }
            }
        });
    }

    public static void debugLogAll(IModuleFeedbackChannel fb) {
        final IModuleFeedbackChannel feedback = fb;
        if (!feedback.isDebugEnabled(sModule)) {
            feedback.debug("IntervalHeartbeat debugLog facility not available. Turn debug on to use.");
        } else {
            feedback.debug("Logging all IntervalHeartbeats");
            IntervalHeartbeat.auditStartedHeartbeats(new IAuditIntervalHeartBeatAction(){

                @Override
                public void auditHeartbeat(IntervalHeartbeat heartbeat) {
                    feedback.debug("--------------");
                    heartbeat.debugLog(feedback);
                }
            });
        }
    }

    public void debugLog(IModuleFeedbackChannel feedback) {
        Object[] allNodes = this.fBehaviorQueue.toArray();
        feedback.debug("IntervalHeartbeat: \"" + this.getName() + "\" has node count of: " + allNodes.length);
        int x = 0;
        while (x < allNodes.length) {
            BehaviorNode current = (BehaviorNode)allNodes[x];
            feedback.debug("\t" + current.toString());
            ++x;
        }
    }

    public final class BehaviorNode
    implements IRegisteredBehavior {
        private final ITimestampedRunnable fBehavior;
        private final String fName;
        private final long fRequestedDelayInMillis;
        private long fActualDelayInMillis;
        public long fNextExecutionTimeInMillis;
        private boolean fHasBeenRemoved;
        private final boolean fRunFirst;
        private boolean fCurrentlyActive;
        private final boolean fHasCountdown;
        private final int fTargetExecutions;
        private int fTotalExecutions;
        private final long fFirstRunTime;
        private final Object fExecutionTimeLock;
        private long fExecutionStartTimeStamp;

        private BehaviorNode(long now, ITimestampedRunnable target, String name, boolean initiallyActive, long requestedDelayInMillis, long actualDelayInMillis, boolean runFirst, boolean doCountdown, int countdownValue, long firstRunTime) {
            Assertion.wilyAssert(false);
            Assertion.wilyAssert(false);
            Assertion.wilyAssert(false);
            Assertion.wilyAssert(false);
            Assertion.wilyAssert(false);
            Assertion.wilyAssert(false);
            Assertion.wilyAssert(false);
            this.fBehavior = target;
            this.fName = name;
            this.fCurrentlyActive = initiallyActive;
            this.fRequestedDelayInMillis = requestedDelayInMillis;
            this.fActualDelayInMillis = actualDelayInMillis;
            this.fRunFirst = runFirst;
            this.fHasCountdown = doCountdown;
            this.fTargetExecutions = countdownValue;
            this.fTotalExecutions = 0;
            this.fFirstRunTime = firstRunTime;
            this.fExecutionTimeLock = new Object();
            this.fExecutionStartTimeStamp = 0L;
            this.scheduleBasedOnRunFirstFlagAndFirstRunTime(now);
        }

        public BehaviorNode(long now, ITimestampedRunnable target, String name, boolean initiallyActive, long requestedDelayInMillis, long actualDelayInMillis, boolean runFirst) {
            this(now, target, name, initiallyActive, requestedDelayInMillis, actualDelayInMillis, runFirst, false, 0, 0L);
        }

        public BehaviorNode(long now, ITimestampedRunnable target, String name, boolean initiallyActive, long requestedDelayInMillis, long actualDelayInMillis, long firstRunTime) {
            this(now, target, name, initiallyActive, requestedDelayInMillis, actualDelayInMillis, false, false, 0, firstRunTime);
        }

        public BehaviorNode(long now, ITimestampedRunnable target, String name, boolean initiallyActive, long requestedDelayInMillis, long actualDelayInMillis, boolean runFirst, int countdown) {
            this(now, target, name, initiallyActive, requestedDelayInMillis, actualDelayInMillis, runFirst, true, countdown, 0L);
            Assertion.wilyAssert(false);
        }

        public void markAsDeleted() {
            this.fHasBeenRemoved = true;
        }

        private boolean isAlive() {
            return !this.fHasBeenRemoved;
        }

        public boolean isActive() {
            return this.fCurrentlyActive;
        }

        public void setActive(boolean newState) {
            this.fCurrentlyActive = newState;
        }

        public boolean finishedCountingDown() {
            boolean result = false;
            result = this.fHasCountdown ? this.fTotalExecutions >= this.fTargetExecutions : false;
            return result;
        }

        public boolean shouldRequeue() {
            return this.isAlive() && this.isActive() && !this.finishedCountingDown();
        }

        public void scheduleForNowPlusDelay(long now) {
            Assertion.wilyAssert(false);
            this.fNextExecutionTimeInMillis = now + this.getActualDelayInMillis();
        }

        public void scheduleForFirstRunTime(long firstRunTime) {
            Assertion.wilyAssert(false);
            this.fNextExecutionTimeInMillis = firstRunTime;
        }

        public void scheduleForNow(long now) {
            Assertion.wilyAssert(false);
            this.fNextExecutionTimeInMillis = now;
        }

        public void scheduleBasedOnRunFirstFlagAndFirstRunTime(long now) {
            Assertion.wilyAssert(false);
            if (this.fRunFirst) {
                this.scheduleForNow(now);
            } else if (this.fFirstRunTime != 0L) {
                this.scheduleForFirstRunTime(this.fFirstRunTime);
            } else {
                this.scheduleForNowPlusDelay(now);
            }
        }

        public long getNextExecutionAppointment() {
            return this.fNextExecutionTimeInMillis;
        }

        public boolean isEligible(long nowInMillis) {
            Assertion.wilyAssert(false);
            return this.getNextExecutionAppointment() <= nowInMillis;
        }

        public long computeWaitTimeInMillis(long nowInMillis) {
            Assertion.wilyAssert(false);
            Assertion.wilyAssert(false);
            long target = this.getNextExecutionAppointment();
            if (nowInMillis >= target) {
                return 0L;
            }
            return target - nowInMillis;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long computeExecutionTimeInMillis(long nowInMillis) {
            Object object = this.fExecutionTimeLock;
            synchronized (object) {
                long execTime;
                block6: {
                    block5: {
                        if (this.fExecutionStartTimeStamp != 0L) break block5;
                        return 0L;
                    }
                    execTime = nowInMillis - this.fExecutionStartTimeStamp;
                    if (execTime >= 0L) break block6;
                    return 0L;
                }
                return execTime;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void updateExecutionTimeInMillis(long nowInMillis) {
            Object object = this.fExecutionTimeLock;
            synchronized (object) {
                this.fExecutionStartTimeStamp = nowInMillis;
            }
        }

        public long getActualDelayInMillis() {
            return this.fActualDelayInMillis;
        }

        public void setActualDelayInMillis(long delay) {
            this.fActualDelayInMillis = delay;
        }

        public String getName() {
            return this.fName;
        }

        public void execute(long nowInMilliseconds) {
            try {
                this.updateExecutionTimeInMillis(nowInMilliseconds);
                this.fBehavior.ITimestampedRunnable_execute(nowInMilliseconds);
                this.updateExecutionTimeInMillis(0L);
                ++this.fTotalExecutions;
            }
            catch (Throwable t) {
                try {
                    this.updateExecutionTimeInMillis(0L);
                    IModuleFeedbackChannel feedbackChannel = IntervalHeartbeat.this.getModuleFeedback();
                    feedbackChannel.error("IntervalHeartbeat.execute threw executing: " + this, t);
                }
                catch (Throwable throwable) {}
            }
            this.scheduleForNowPlusDelay(nowInMilliseconds);
        }

        public String toString() {
            return this.getName();
        }

        public boolean isCountdown() {
            return this.fHasCountdown;
        }

        public String toDebugString() {
            return String.valueOf(this.getName()) + " askPeriod: " + this.fRequestedDelayInMillis + " actualPeriod: " + this.fActualDelayInMillis + " nextTime: " + this.fNextExecutionTimeInMillis + " dead: " + this.fHasBeenRemoved + " active: " + this.fCurrentlyActive + " runFirst: " + this.fRunFirst + " countdown: " + this.fHasCountdown + " countdownTarget: " + this.fTargetExecutions + " total: " + this.fTotalExecutions;
        }

        @Override
        public String IRegisteredBehavior_getName() {
            return this.getName();
        }

        @Override
        public ITimestampedRunnable IRegisteredBehavior_getRunnable() {
            return this.fBehavior;
        }

        @Override
        public long IRegisteredBehavior_getPeriod() {
            return this.getActualDelayInMillis();
        }

        @Override
        public boolean IRegisteredBehavior_getRunFirst() {
            return this.fRunFirst;
        }

        @Override
        public boolean IRegisteredBehavior_isActive() {
            return this.isActive();
        }

        @Override
        public boolean IRegisteredBehavior_isCountdown() {
            return this.isCountdown();
        }

        @Override
        public int IRegisteredBehavior_getCountdown() {
            return this.fTargetExecutions - this.fTotalExecutions;
        }

        @Override
        public void IRegisteredBehavior_setEnableState(boolean isEnabled) {
            IntervalHeartbeat.this.changeEnableState(this, isEnabled);
        }

        @Override
        public void IRegisteredBehavior_setPeriod(long period) {
            this.setActualDelayInMillis(period);
        }

        @Override
        public void close() {
            IntervalHeartbeat.this.removeBehavior(this);
        }
    }

    private class HeartbeatRunnable
    implements Runnable {
        @Override
        public void run() {
            IntervalHeartbeat.this.syncAllBehaviors();
            while (!IntervalHeartbeat.this.isDead()) {
                try {
                    try {
                        IntervalHeartbeat.this.waitForBehaviorIfEmpty();
                        long sleepTime = IntervalHeartbeat.this.executeNextBehaviorAndCalculateSleepTime();
                        if (sleepTime <= 0L) continue;
                        Thread.sleep(sleepTime);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                catch (Throwable t) {
                    IntervalHeartbeat.this.getModuleFeedback().error(t);
                }
            }
        }
    }

    private static interface IAuditIntervalHeartBeatAction {
        public void auditHeartbeat(IntervalHeartbeat var1);
    }

    private static class NodeComparer
    implements IComparer {
        private NodeComparer() {
        }

        @Override
        public boolean lessThan(Object obj1, Object obj2) {
            return ((BehaviorNode)obj1).fNextExecutionTimeInMillis < ((BehaviorNode)obj2).fNextExecutionTimeInMillis;
        }

        @Override
        public boolean equalTo(Object obj1, Object obj2) {
            return obj1.equals(obj2);
        }
    }
}

