/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import com.wily.introscope.agent.AgentShim;
import java.io.IOException;
import java.net.AgentSocketInputStream;
import java.net.PlainSocketImpl;
import java.net.SocketInputStream;

public final class ManagedSocketInputStreamHighPerformance
extends SocketInputStream {
    private final AgentSocketInputStream managedSocketInputStream = new AgentSocketInputStream();

    ManagedSocketInputStreamHighPerformance(PlainSocketImpl impl) throws IOException {
        super(impl);
        this.managedSocketInputStream.setCache(impl.socket);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read() throws IOException {
        int byteRead;
        String methodName = "read()";
        if (this.managedSocketInputStream.getCache() == null) {
            return super.read();
        }
        Object tl = AgentShim.getAgentShimThreadLocal();
        if (AgentShim.isThreadInAgentCode(tl)) {
            return super.read();
        }
        boolean addedToConcurrentReaders = false;
        try {
            AgentShim.setThreadInAgentCode(tl);
            addedToConcurrentReaders = this.managedSocketInputStream.addToConcurrentReaders("read()");
            if (this.managedSocketInputStream.getCache().isClientConnection()) {
                this.managedSocketInputStream.annotateBlameStack();
                this.managedSocketInputStream.suggestStackTraceRecording();
            }
        }
        finally {
            AgentShim.clearThreadInAgentCode(tl);
        }
        try {
            byteRead = super.read();
            AgentShim.setThreadInAgentCode(tl);
            this.managedSocketInputStream.addToInputBandwidth(byteRead);
        }
        catch (ThreadDeath td) {
            throw td;
        }
        finally {
            this.managedSocketInputStream.removeFromConcurrentReaders(addedToConcurrentReaders, "read()");
            AgentShim.clearThreadInAgentCode(tl);
        }
        return byteRead;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(byte[] b, int off, int length) throws IOException {
        int numberOfBytesRead;
        String methodName = "read(byte[],int,int)";
        if (this.managedSocketInputStream.getCache() == null) {
            return super.read(b, off, length);
        }
        Object tl = AgentShim.getAgentShimThreadLocal();
        if (AgentShim.isThreadInAgentCode(tl)) {
            return super.read(b, off, length);
        }
        boolean addedToConcurrentReaders = false;
        try {
            AgentShim.setThreadInAgentCode(tl);
            addedToConcurrentReaders = this.managedSocketInputStream.addToConcurrentReaders("read(byte[],int,int)");
            if (this.managedSocketInputStream.getCache().isClientConnection()) {
                this.managedSocketInputStream.annotateBlameStack();
                this.managedSocketInputStream.suggestStackTraceRecording();
            }
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            try {
                AgentShim.handleError("Exception in preparing read(byte[],int,int) from High Performance socket input stream", t);
            }
            catch (ThreadDeath td2) {
                throw td2;
            }
            catch (Throwable td2) {
                // empty catch block
            }
        }
        finally {
            AgentShim.clearThreadInAgentCode(tl);
        }
        try {
            numberOfBytesRead = super.read(b, off, length);
            AgentShim.setThreadInAgentCode(tl);
            this.managedSocketInputStream.addToInputBandwidth(numberOfBytesRead);
        }
        catch (ThreadDeath td) {
            throw td;
        }
        finally {
            this.managedSocketInputStream.removeFromConcurrentReaders(addedToConcurrentReaders, "read(byte[],int,int)");
            AgentShim.clearThreadInAgentCode(tl);
        }
        return numberOfBytesRead;
    }
}

