/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.spec.server.transactiontrace;

import com.wily.introscope.spec.server.transactiontrace.ATransactionTraceFilter;
import com.wily.introscope.spec.server.transactiontrace.IFailFastTransactionTraceFilter;
import com.wily.introscope.spec.server.transactiontrace.TransactionComponentData;
import com.wily.util.text.IStringLocalizer;
import com.wily.wilyassert.Assertion;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Locale;
import java.util.Map;

public final class ParameterValueTransactionTraceFilter
extends ATransactionTraceFilter
implements IFailFastTransactionTraceFilter,
Externalizable {
    private static final long serialVersionUID = 8983660570510856056L;
    public static final int kEqualsMatchType = 0;
    public static final int kStartsWithMatchType = 1;
    public static final int kEndsWithMatchType = 2;
    public static final int kContainsMatchType = 3;
    public static final int kExistsMatchType = 4;
    private static final int kNot = 16;
    private String fParameterName;
    private String fParameterValue;
    private int fOperationType;
    private boolean fNot;
    private Locale fLocale = Locale.getDefault();

    public ParameterValueTransactionTraceFilter() {
    }

    public ParameterValueTransactionTraceFilter(int operationType, String name, String value) {
        Assertion.wilyAssert(false);
        this.fParameterName = name;
        this.fOperationType = ParameterValueTransactionTraceFilter.getOperationType(operationType);
        this.fNot = ParameterValueTransactionTraceFilter.isNotOperation(operationType);
        this.fParameterValue = this.fOperationType == 4 ? "" : value;
    }

    public ParameterValueTransactionTraceFilter(int operationType, boolean not, String name, String value) {
        Assertion.wilyAssert(false);
        this.fParameterName = name;
        this.fOperationType = operationType;
        this.fNot = not;
        this.fParameterValue = this.fOperationType == 4 ? "" : value;
    }

    @Override
    public boolean shouldCollect(Map parameters) {
        Assertion.wilyAssert(false);
        boolean result = this.evaluateParameterNameValueOperation(parameters);
        return result;
    }

    private boolean servletParameterMatches(TransactionComponentData data) {
        if (data == null) {
            return false;
        }
        Map<String, String> params = data.getParameters();
        return this.shouldCollect(params);
    }

    @Override
    public boolean ITransactionTraceFilter_passesFilter(TransactionComponentData root) {
        return this.passesFilter(root);
    }

    private boolean passesFilter(TransactionComponentData root) {
        boolean result = false;
        if (this.servletParameterMatches(root)) {
            result = true;
        } else if (!this.fNot) {
            TransactionComponentData child1 = null;
            if (root.getSubNodeCount() > 0 && (child1 = root.getCalledComponent(0)) != null) {
                if (this.servletParameterMatches(child1)) {
                    result = true;
                } else {
                    TransactionComponentData child1of1 = null;
                    if (child1.getSubNodeCount() > 0 && (child1of1 = child1.getCalledComponent(0)) != null && this.servletParameterMatches(child1of1)) {
                        result = true;
                    }
                }
            }
        }
        return result;
    }

    private boolean evaluateParameterNameValueOperation(Map parameters) {
        if (this.fOperationType == 0) {
            if (this.fNot) {
                return !this.fParameterValue.equals(parameters.get(this.fParameterName));
            }
            return this.fParameterValue.equals(parameters.get(this.fParameterName));
        }
        if (this.fOperationType == 3) {
            String value = (String)parameters.get(this.fParameterName);
            if (value == null) {
                return this.fNot;
            }
            if (this.fNot) {
                return value.indexOf(this.fParameterValue) <= -1;
            }
            return value.indexOf(this.fParameterValue) > -1;
        }
        if (this.fOperationType == 1) {
            String value = (String)parameters.get(this.fParameterName);
            if (value == null) {
                return false;
            }
            return value.startsWith(this.fParameterValue);
        }
        if (this.fOperationType == 2) {
            String value = (String)parameters.get(this.fParameterName);
            if (value == null) {
                return false;
            }
            return value.endsWith(this.fParameterValue);
        }
        if (this.fOperationType == 4) {
            String value = (String)parameters.get(this.fParameterName);
            if (this.fNot) {
                return value == null;
            }
            return value != null;
        }
        return false;
    }

    private Boolean evaluateParameterNameValueOperationPartial(Map parameters) {
        boolean exists;
        Object param = parameters.get(this.fParameterName);
        boolean bl = exists = param != null;
        if (!exists && this.fOperationType != 4) {
            return null;
        }
        if (this.fOperationType == 0) {
            if (this.fParameterValue.equals(param)) {
                if (this.fNot) {
                    return Boolean.FALSE;
                }
                return Boolean.TRUE;
            }
            return null;
        }
        if (this.fOperationType == 3) {
            String value = (String)param;
            if (value.indexOf(this.fParameterValue) > -1) {
                if (this.fNot) {
                    return Boolean.FALSE;
                }
                return Boolean.TRUE;
            }
            return null;
        }
        if (this.fOperationType == 1) {
            String value = (String)param;
            if (value.startsWith(this.fParameterValue)) {
                if (this.fNot) {
                    return Boolean.FALSE;
                }
                return Boolean.TRUE;
            }
            return null;
        }
        if (this.fOperationType == 2) {
            String value = (String)param;
            if (value.endsWith(this.fParameterValue)) {
                if (this.fNot) {
                    return Boolean.FALSE;
                }
                return Boolean.TRUE;
            }
            return null;
        }
        if (this.fOperationType == 4) {
            if (exists) {
                if (this.fNot) {
                    return Boolean.FALSE;
                }
                return Boolean.TRUE;
            }
            return null;
        }
        return null;
    }

    private boolean evaluateParameterNameValueOperationFinal() {
        return this.fNot;
    }

    public static int getFilterType() {
        return 2;
    }

    @Override
    public int ITransactionTraceFilter_getFilterType() {
        return ParameterValueTransactionTraceFilter.getFilterType();
    }

    @Override
    public String ITransactionTraceFilter_getLocalizedDescription(IStringLocalizer localizer) {
        return localizer.IStringLocalizer_getFormattedLocalizedString("Transaction_Trace_Generic_Filter_Description_Message", this.ITransactionTraceFilter_getLocalizedStatusMessage(localizer));
    }

    public static ParameterValueTransactionTraceFilter read(DataInput in) throws IOException {
        ParameterValueTransactionTraceFilter filter = new ParameterValueTransactionTraceFilter();
        filter.readInternal(in);
        return filter;
    }

    public int getOperationType() {
        return this.fOperationType;
    }

    public String getParameterName() {
        return this.fParameterName;
    }

    public String getParameterValue() {
        return this.fParameterValue;
    }

    public int hashCode() {
        return this.fParameterName.hashCode() ^ this.fParameterValue.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ParameterValueTransactionTraceFilter) {
            ParameterValueTransactionTraceFilter filter = (ParameterValueTransactionTraceFilter)obj;
            return this.fOperationType == filter.fOperationType && this.fParameterName.equals(filter.fParameterName) && this.fParameterValue.equals(filter.fParameterValue);
        }
        return false;
    }

    @Override
    public void ITransactionTraceFilter_write(DataOutput out) throws IOException {
        this.writeInternal(out);
    }

    @Override
    public final void writeExternal(ObjectOutput out) throws IOException {
        this.writeInternal(out);
    }

    @Override
    public final void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.readInternal(in);
    }

    public void writeInternal(DataOutput out) throws IOException {
        out.writeInt(this.fOperationType);
        out.writeBoolean(this.fNot);
        out.writeUTF(this.fParameterName);
        out.writeUTF(this.fParameterValue);
    }

    private void readInternal(DataInput in) throws IOException {
        this.fOperationType = in.readInt();
        this.fNot = in.readBoolean();
        this.fParameterName = in.readUTF();
        this.fParameterValue = in.readUTF();
    }

    public String toString() {
        return "[parametername = " + this.fParameterName + ",parametervalue=" + this.fParameterValue + ",operator=" + this.fOperationType + ",not=" + this.fNot + "]";
    }

    public static String getLocalizedParameterName(IStringLocalizer localizer, String name, Locale locale) {
        if (name.startsWith("httprequest.attribute.")) {
            return localizer.IStringLocalizer_getFormattedLocalizedString(locale, "Transaction_Trace_Request_Attribute_Parameter_Label", name.substring("httprequest.attribute.".length()));
        }
        if (name.startsWith("httprequest.parameter.")) {
            return localizer.IStringLocalizer_getFormattedLocalizedString(locale, "Transaction_Trace_Request_Parameter_Parameter_Label", name.substring("httprequest.parameter.".length()));
        }
        if (name.startsWith("httprequest.header.")) {
            return localizer.IStringLocalizer_getFormattedLocalizedString(locale, "Transaction_Trace_Request_Header_Parameter_Label", name.substring("httprequest.header.".length()));
        }
        if (name.startsWith("httpsession.attribute.")) {
            return localizer.IStringLocalizer_getFormattedLocalizedString(locale, "Transaction_Trace_Session_Attribute_Parameter_Label", name.substring("httpsession.attribute.".length()));
        }
        if (name.equals("User ID")) {
            return localizer.IStringLocalizer_getLocalizedString(locale, "Transaction_Trace_User_ID_Parameter_Label");
        }
        if (name.equals("Session ID")) {
            return localizer.IStringLocalizer_getLocalizedString(locale, "Transaction_Trace_Session_ID_Parameter_Label");
        }
        if (name.startsWith("Cor")) {
            name = name.substring("Cor".length());
        }
        StringBuilder paramNameKey = new StringBuilder(name.length() + 40);
        paramNameKey.append("Transaction_Trace_");
        int i = 0;
        while (i < name.length()) {
            char c = name.charAt(i);
            if (c == ' ') {
                c = '_';
            }
            paramNameKey.append(c);
            ++i;
        }
        paramNameKey.append("_Parameter_Label");
        String label = localizer.IStringLocalizer_getLocalizedString(locale, paramNameKey.toString());
        if (label != null && !label.equalsIgnoreCase(paramNameKey.toString())) {
            return label;
        }
        return name;
    }

    public static String getLocalizedParameterName(IStringLocalizer localizer, String name) {
        return ParameterValueTransactionTraceFilter.getLocalizedParameterName(localizer, name, Locale.ENGLISH);
    }

    @Override
    public String ITransactionTraceFilter_getLocalizedStatusMessage(IStringLocalizer localizer) {
        String name = ParameterValueTransactionTraceFilter.getLocalizedParameterName(localizer, this.fParameterName);
        String operation = ParameterValueTransactionTraceFilter.getLocalizedOperationName(localizer, ParameterValueTransactionTraceFilter.getOperationType(this.fOperationType, this.fNot));
        String value = this.fParameterValue == null ? "" : this.fParameterValue;
        String text = localizer.IStringLocalizer_getFormattedLocalizedString("Transaction_Trace_Status_Bar_Parameter_Filter_Message", new String[]{name, operation, value});
        return text;
    }

    @Override
    public String ITransactionTraceFilter_getLocalizedStatusMessage(IStringLocalizer localizer, Locale locale) {
        this.fLocale = locale;
        String name = ParameterValueTransactionTraceFilter.getLocalizedParameterName(localizer, this.fParameterName);
        String operation = ParameterValueTransactionTraceFilter.getLocalizedOperationName(localizer, ParameterValueTransactionTraceFilter.getOperationType(this.fOperationType, this.fNot));
        String value = this.fParameterValue == null ? "" : this.fParameterValue;
        String text = localizer.IStringLocalizer_getFormattedLocalizedString(locale, "Transaction_Trace_Status_Bar_Parameter_Filter_Message", new String[]{name, operation, value});
        return text;
    }

    public static int getOperationType(int operation) {
        return operation & 0xF;
    }

    private static boolean isNotOperation(int operation) {
        return (operation & 0x10) == 16;
    }

    public static int getOperationType(int operation, boolean not) {
        if (!not) {
            return operation;
        }
        return operation | 0x10;
    }

    public static String getLocalizedOperationName(IStringLocalizer localizer, int operation, Locale locale) {
        int operationType = ParameterValueTransactionTraceFilter.getOperationType(operation);
        if (2 == operationType) {
            return localizer.IStringLocalizer_getLocalizedString(locale, "Transaction_Trace_Parameter_Operator_Ends_With_Text");
        }
        if (1 == operationType) {
            return localizer.IStringLocalizer_getLocalizedString(locale, "Transaction_Trace_Parameter_Operator_Starts_With_Text");
        }
        if (operationType == 0) {
            if (ParameterValueTransactionTraceFilter.isNotOperation(operation)) {
                return localizer.IStringLocalizer_getLocalizedString(locale, "Transaction_Trace_Parameter_Operator_Does_Not_Equal_Text");
            }
            return localizer.IStringLocalizer_getLocalizedString(locale, "Transaction_Trace_Parameter_Operator_Equals_Text");
        }
        if (3 == operationType) {
            if (ParameterValueTransactionTraceFilter.isNotOperation(operation)) {
                return localizer.IStringLocalizer_getLocalizedString(locale, "Transaction_Trace_Parameter_Operator_Does_Not_Contain_Text");
            }
            return localizer.IStringLocalizer_getLocalizedString(locale, "Transaction_Trace_Parameter_Operator_Contains_Text");
        }
        if (4 == operationType) {
            if (ParameterValueTransactionTraceFilter.isNotOperation(operation)) {
                return localizer.IStringLocalizer_getLocalizedString(locale, "Transaction_Trace_Parameter_Operator_Does_Not_Exist_Text");
            }
            return localizer.IStringLocalizer_getLocalizedString(locale, "Transaction_Trace_Parameter_Operator_Exists_Text");
        }
        return "";
    }

    public static String getLocalizedOperationName(IStringLocalizer localizer, int operation) {
        int operationType = ParameterValueTransactionTraceFilter.getOperationType(operation);
        if (2 == operationType) {
            return localizer.IStringLocalizer_getLocalizedString("Transaction_Trace_Parameter_Operator_Ends_With_Text");
        }
        if (1 == operationType) {
            return localizer.IStringLocalizer_getLocalizedString("Transaction_Trace_Parameter_Operator_Starts_With_Text");
        }
        if (operationType == 0) {
            if (ParameterValueTransactionTraceFilter.isNotOperation(operation)) {
                return localizer.IStringLocalizer_getLocalizedString("Transaction_Trace_Parameter_Operator_Does_Not_Equal_Text");
            }
            return localizer.IStringLocalizer_getLocalizedString("Transaction_Trace_Parameter_Operator_Equals_Text");
        }
        if (3 == operationType) {
            if (ParameterValueTransactionTraceFilter.isNotOperation(operation)) {
                return localizer.IStringLocalizer_getLocalizedString("Transaction_Trace_Parameter_Operator_Does_Not_Contain_Text");
            }
            return localizer.IStringLocalizer_getLocalizedString("Transaction_Trace_Parameter_Operator_Contains_Text");
        }
        if (4 == operationType) {
            if (ParameterValueTransactionTraceFilter.isNotOperation(operation)) {
                return localizer.IStringLocalizer_getLocalizedString("Transaction_Trace_Parameter_Operator_Does_Not_Exist_Text");
            }
            return localizer.IStringLocalizer_getLocalizedString("Transaction_Trace_Parameter_Operator_Exists_Text");
        }
        return "";
    }

    @Override
    public boolean isHeadFilter() {
        return true;
    }

    @Override
    public Boolean shouldCollectHead(Map parameters) {
        return this.evaluateParameterNameValueOperationPartial(parameters);
    }

    @Override
    public boolean shouldCollectFinal() {
        return this.evaluateParameterNameValueOperationFinal();
    }
}

