/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.environment;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Deque;

public class JsonGenerator {
    private StringBuilder sb;
    private Deque<State> stack = new ArrayDeque<State>();
    private State currentState = null;
    private boolean first = true;

    public JsonGenerator() {
        this.sb = new StringBuilder();
    }

    public void writeStringField(String key, String value) throws IOException {
        if (!State.IN_OBJECT.equals((Object)this.currentState)) {
            throw new IOException("Invalid current state writing pair: " + (Object)((Object)this.currentState));
        }
        if (!this.first) {
            this.sb.append(",");
        }
        JsonGenerator.writeQuotedString(this.sb, key);
        this.sb.append(":");
        JsonGenerator.writeQuotedString(this.sb, value);
        this.first = false;
    }

    public void writeLongField(String key, long value) throws IOException {
        if (!State.IN_OBJECT.equals((Object)this.currentState)) {
            throw new IOException("Invalid current state writing pair: " + (Object)((Object)this.currentState));
        }
        if (!this.first) {
            this.sb.append(",");
        }
        JsonGenerator.writeQuotedString(this.sb, key);
        this.sb.append(":");
        this.sb.append(value);
        this.first = false;
    }

    public void writeStartObject() throws IOException {
        State.assertWriteValue(this.currentState);
        if (!this.first) {
            this.sb.append(",");
        }
        this.stack.addLast(State.IN_OBJECT);
        this.currentState = State.IN_OBJECT;
        this.sb.append("{");
        this.first = true;
    }

    public void writeStartArray() throws IOException {
        State.assertWriteValue(this.currentState);
        if (!this.first) {
            this.sb.append(",");
        }
        this.stack.addLast(State.IN_ARRAY);
        this.currentState = State.IN_ARRAY;
        this.sb.append("[");
        this.first = true;
    }

    public void writeFieldName(String string) throws IOException {
        if (!State.IN_OBJECT.equals((Object)this.currentState)) {
            throw new IOException("Invalid current state for writing field name: " + (Object)((Object)this.currentState));
        }
        if (!this.first) {
            this.sb.append(",");
        }
        this.stack.addLast(State.FIELD_VALUE);
        this.currentState = State.FIELD_VALUE;
        JsonGenerator.writeQuotedString(this.sb, string);
        this.sb.append(":");
        this.first = true;
    }

    public void writeString(String string) throws IOException {
        State.assertWriteValue(this.currentState);
        if (!this.first) {
            this.sb.append(",");
        }
        JsonGenerator.writeQuotedString(this.sb, string);
        if (State.FIELD_VALUE.equals((Object)this.currentState)) {
            this.pollState();
        }
        this.first = false;
    }

    public void writeEndObject() throws IOException {
        if (!State.IN_OBJECT.equals((Object)this.currentState)) {
            throw new IOException("Invalid current state for closing object: " + (Object)((Object)this.currentState));
        }
        this.pollState();
        this.sb.append("}");
        this.first = false;
    }

    public void writeEndArray() throws IOException {
        if (!State.IN_ARRAY.equals((Object)this.currentState)) {
            throw new IOException("Invalid current state for closing array: " + (Object)((Object)this.currentState));
        }
        this.pollState();
        this.sb.append("]");
        this.first = false;
    }

    private void pollState() throws IOException {
        this.stack.pollLast();
        State state = this.currentState = this.stack.isEmpty() ? null : this.stack.getLast();
        if (State.FIELD_VALUE.equals((Object)this.currentState)) {
            this.stack.pollLast();
            State state2 = this.currentState = this.stack.isEmpty() ? null : this.stack.getLast();
            if (!State.IN_OBJECT.equals((Object)this.currentState)) {
                throw new IOException("Assert when closing field: " + (Object)((Object)this.currentState));
            }
        }
    }

    private static void writeQuotedString(StringBuilder sb, String string) {
        if (string == null) {
            sb.append("null");
            return;
        }
        if (string.length() == 0) {
            sb.append("\"\"");
            return;
        }
        int len = string.length();
        sb.append('\"');
        block9: for (int i = 0; i < len; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\"': 
                case '\\': {
                    sb.append('\\');
                    sb.append(c);
                    continue block9;
                }
                case '/': {
                    sb.append('\\');
                    sb.append(c);
                    continue block9;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block9;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block9;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block9;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block9;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block9;
                }
                default: {
                    if (c < ' ') {
                        String t = "000" + Integer.toHexString(c);
                        sb.append("\\u" + t.substring(t.length() - 4));
                        continue block9;
                    }
                    sb.append(c);
                }
            }
        }
        sb.append('\"');
    }

    public String toString() {
        return this.sb.toString();
    }

    private static enum State {
        IN_OBJECT,
        IN_ARRAY,
        FIELD_VALUE;


        public static void assertWriteValue(State currentState) throws IOException {
            if (currentState == null) {
                return;
            }
            switch (currentState) {
                case FIELD_VALUE: 
                case IN_ARRAY: {
                    return;
                }
            }
            throw new IOException("Invalid current state for writing value: " + (Object)((Object)currentState));
        }
    }
}

