/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.recording;

import com.wily.introscope.agent.recording.IMetricAgedListener;
import com.wily.introscope.agent.recording.IMetricRecordingListener;
import com.wily.introscope.agent.recording.MetricRecordingAdministrator;
import com.wily.introscope.agent.stat.IDataAccumulator;
import com.wily.introscope.spec.metric.AgentMetric;
import java.util.Vector;

public final class MetricRecordingTracker {
    private static final boolean kShutOff = true;
    private static final boolean kNotShutOff = false;
    private final MetricRecordingAdministrator fAdministrator;
    private final AgentMetric fMetric;
    private final IDataAccumulator fDataAccumulator;
    private final Vector fMetricRecordingListeners;
    private boolean fGlobalShutOff;
    private boolean fMetricShutOff;
    private boolean fIsBasedOnSharedElement;

    MetricRecordingTracker(MetricRecordingAdministrator administrator, AgentMetric metric, boolean globalShutOff, boolean metricShutOff, IDataAccumulator dataAccumulator) {
        this.fAdministrator = administrator;
        this.fMetric = metric;
        this.fGlobalShutOff = globalShutOff;
        this.fDataAccumulator = dataAccumulator;
        this.fMetricRecordingListeners = new Vector(1);
        this.fMetricShutOff = metricShutOff;
        this.addMetricRecordingListenerWithRewind(new AccumulatorStateUpdater());
    }

    synchronized boolean turnGlobalToggleOn() {
        boolean changed = false;
        if (this.isMetricShutOff()) {
            this.fGlobalShutOff = false;
            if (!this.isMetricShutOff()) {
                this.notifyListeners(false);
                changed = true;
            }
        }
        return changed;
    }

    synchronized boolean shutGlobalToggleOff() {
        boolean changed = false;
        if (!this.isMetricShutOff()) {
            this.notifyListeners(true);
            changed = true;
        }
        this.fGlobalShutOff = true;
        return changed;
    }

    synchronized boolean turnMetricOn() {
        boolean changed = false;
        if (this.isMetricShutOff()) {
            this.fMetricShutOff = false;
            if (!this.isMetricShutOff()) {
                this.notifyListeners(false);
                changed = true;
            }
        }
        return changed;
    }

    synchronized boolean shutMetricOff() {
        boolean changed = false;
        if (!this.isMetricShutOff()) {
            this.notifyListeners(true);
            changed = true;
        }
        this.fMetricShutOff = true;
        return changed;
    }

    private void notifyListeners(boolean shutoffState) {
        for (int i = 0; i < this.fMetricRecordingListeners.size(); ++i) {
            IMetricRecordingListener listener = (IMetricRecordingListener)this.fMetricRecordingListeners.elementAt(i);
            if (shutoffState) {
                this.fAdministrator.notifyListenerOfShutOffMetric(listener, this.fMetric);
                continue;
            }
            this.fAdministrator.notifyListenerOfTurnedOnMetric(listener, this.fMetric);
        }
    }

    void notifyListenersOfAgedMetric() {
        for (int i = 0; i < this.fMetricRecordingListeners.size(); ++i) {
            Object listener = this.fMetricRecordingListeners.elementAt(i);
            if (!(listener instanceof IMetricAgedListener)) continue;
            ((IMetricAgedListener)listener).IMetricAgedListener_metricIsAged(this.fMetric);
        }
    }

    boolean isMetricShutOff() {
        return this.fGlobalShutOff || this.fMetricShutOff;
    }

    IDataAccumulator getDataAccumulator() {
        return this.fDataAccumulator;
    }

    synchronized void addMetricRecordingListenerWithRewind(IMetricRecordingListener listener) {
        this.fMetricRecordingListeners.addElement(listener);
        this.rewindStateForListener(listener);
    }

    private void rewindStateForListener(IMetricRecordingListener listener) {
        if (this.isMetricShutOff()) {
            this.fAdministrator.notifyListenerOfShutOffMetric(listener, this.fMetric);
        } else {
            this.fAdministrator.notifyListenerOfTurnedOnMetric(listener, this.fMetric);
        }
    }

    synchronized void removeMetricRecordingListener(IMetricRecordingListener listener) {
        this.fMetricRecordingListeners.removeElement(listener);
    }

    synchronized void removeAllListeners() {
        this.fMetricRecordingListeners.removeAllElements();
    }

    public void setBasedOnSharedElement(boolean fIsBasedOnSharedElement) {
        this.fIsBasedOnSharedElement = fIsBasedOnSharedElement;
    }

    public boolean isBasedOnSharedElement() {
        return this.fIsBasedOnSharedElement;
    }

    private final class AccumulatorStateUpdater
    implements IMetricRecordingListener {
        private AccumulatorStateUpdater() {
        }

        @Override
        public void IMetricRecordingListener_metricIsShutOff(AgentMetric metric) {
            MetricRecordingTracker.this.getDataAccumulator().IDataAccumulator_setShutOff(true);
        }

        @Override
        public void IMetricRecordingListener_metricIsTurnedOn(AgentMetric metric) {
            MetricRecordingTracker.this.getDataAccumulator().IDataAccumulator_setShutOff(false);
        }
    }
}

