/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.util;

import com.wily.introscope.agent.AgentNotAvailableException;
import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.util.ReflectionLookupException;
import com.wily.util.feedback.IModuleFeedbackChannel;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;

public class ReflectionLookupStore {
    private static final String[] EMPTY_STRING = new String[0];
    private static Map<String, WeakReference<Method>> methodReflectionCache;
    private static Map<String, WeakReference<Class>> classReflectionCache;
    private static Map<String, WeakReference<Field>> fieldReflectionCache;

    private static Map<String, WeakReference<Method>> getMethodReflectionCache() {
        if (null == methodReflectionCache) {
            try {
                methodReflectionCache = AgentShim.getAgent().IAgent_getConcurrentMapFactory().getConcurrentCappedMap("GenericMethodCache");
            }
            catch (AgentNotAvailableException e) {
                return null;
            }
        }
        return methodReflectionCache;
    }

    private static Map<String, WeakReference<Class>> getClassReflectionCache() {
        if (null == classReflectionCache) {
            try {
                classReflectionCache = AgentShim.getAgent().IAgent_getConcurrentMapFactory().getConcurrentCappedMap("GenericClassCache");
            }
            catch (AgentNotAvailableException e) {
                return null;
            }
        }
        return classReflectionCache;
    }

    private static Map<String, WeakReference<Field>> getFieldReflectionCache() {
        if (null == fieldReflectionCache) {
            try {
                fieldReflectionCache = AgentShim.getAgent().IAgent_getConcurrentMapFactory().getConcurrentCappedMap("GenericFieldCache");
            }
            catch (AgentNotAvailableException e) {
                return null;
            }
        }
        return fieldReflectionCache;
    }

    public static Method lookupMethod(Object instance, String name, boolean publicModifier, IModuleFeedbackChannel feedback) throws ReflectionLookupException {
        return ReflectionLookupStore.lookupMethod(instance, name, EMPTY_STRING, publicModifier, feedback);
    }

    public static Method lookupMethod(Object instance, String name, String[] strings, boolean publicModifier, IModuleFeedbackChannel feedback) throws ReflectionLookupException {
        return ReflectionLookupStore.lookupMethodOnClass(instance.getClass(), name, strings, publicModifier, feedback);
    }

    public static Method lookupMethodOnClass(Class className, String methodName, String[] strings, boolean publicModifier, IModuleFeedbackChannel feedback) throws ReflectionLookupException {
        Class[] arguments = null;
        try {
            Method method;
            String key = ReflectionLookupStore.getCacheKey(className.getClassLoader(), className.getName(), methodName);
            WeakReference<Method> weakRefMethod = ReflectionLookupStore.getMethodReflectionCache().get(key);
            Method method2 = method = weakRefMethod == null ? null : (Method)weakRefMethod.get();
            if (method == null) {
                arguments = ReflectionLookupStore.resolveParameterStrings(strings, className.getClassLoader());
                if (publicModifier) {
                    method = className.getMethod(methodName, arguments);
                    StringBuilder argumentsBuffer = new StringBuilder();
                    if (arguments != null) {
                        for (Class class1 : arguments) {
                            argumentsBuffer.append(class1.getName());
                            argumentsBuffer.append(";");
                        }
                    }
                } else {
                    method = className.getDeclaredMethod(methodName, arguments);
                    StringBuilder argumentsBuffer = new StringBuilder();
                    if (arguments != null) {
                        for (Class class1 : arguments) {
                            argumentsBuffer.append(class1.getName());
                            argumentsBuffer.append(";");
                        }
                    }
                }
                method.setAccessible(true);
                ReflectionLookupStore.getMethodReflectionCache().put(key, new WeakReference<Method>(method));
            }
            return method;
        }
        catch (Exception e) {
            Method[] methods;
            StringBuilder argumentsBuffer = new StringBuilder();
            if (arguments != null) {
                for (void var11_22 : arguments) {
                    argumentsBuffer.append(var11_22.getName());
                    argumentsBuffer.append(";");
                }
            }
            StringBuilder methodsBuffer = new StringBuilder();
            for (Method method : methods = className.getMethods()) {
                methodsBuffer.append(method.toString());
                methodsBuffer.append(";");
            }
            feedback.debug("Available methods on class " + className.getName() + ": " + methodsBuffer.toString());
            throw new ReflectionLookupException("Error looking up method " + methodName + " on " + className + " with parameters " + argumentsBuffer.toString(), e);
        }
    }

    public static Method lookupMethodOnClass(Class className, String methodName, Class[] arguments, boolean publicModifier, IModuleFeedbackChannel feedback, boolean useCaching) throws ReflectionLookupException {
        try {
            Method method;
            String key = ReflectionLookupStore.getCacheKey(className.getClassLoader(), className.getName(), methodName);
            WeakReference<Method> weakRefMethod = ReflectionLookupStore.getMethodReflectionCache().get(key);
            Method method2 = method = weakRefMethod == null ? null : (Method)weakRefMethod.get();
            if (method == null) {
                method = publicModifier ? className.getMethod(methodName, arguments) : className.getDeclaredMethod(methodName, arguments);
                method.setAccessible(true);
                ReflectionLookupStore.getMethodReflectionCache().put(key, new WeakReference<Method>(method));
            }
            return method;
        }
        catch (Exception e) {
            Method[] methods;
            StringBuffer argumentsBuffer = new StringBuffer();
            if (arguments != null) {
                for (Class class1 : arguments) {
                    argumentsBuffer.append(class1.getName());
                    argumentsBuffer.append(";");
                }
            }
            StringBuffer methodsBuffer = new StringBuffer();
            for (Method method : methods = className.getMethods()) {
                methodsBuffer.append(method.toString());
                methodsBuffer.append(";");
            }
            feedback.error("Available methods on class " + className.getName() + ": " + methodsBuffer.toString());
            throw new ReflectionLookupException("Error looking up method " + methodName + " on " + className + " with parameters " + argumentsBuffer.toString(), e);
        }
    }

    public static Method lookupMethod(Object instance, String methodName, Class[] parameterTypes, boolean publicModifier, IModuleFeedbackChannel feedback, boolean useCaching) throws ReflectionLookupException {
        return ReflectionLookupStore.lookupMethodOnClass(instance.getClass(), methodName, parameterTypes, publicModifier, feedback, useCaching);
    }

    public static Class[] resolveParameterStrings(String[] strings, ClassLoader classloader) throws ReflectionLookupException {
        Class[] classNames = new Class[strings.length];
        for (int i = 0; i < strings.length; ++i) {
            String className = strings[i];
            classNames[i] = ReflectionLookupStore.lookupClass(className, classloader);
        }
        return classNames;
    }

    public static Class lookupClass(String className, ClassLoader classloader) throws ReflectionLookupException {
        try {
            Class<?> lookupClass;
            String key = ReflectionLookupStore.getCacheKey(classloader, className);
            WeakReference<Class> weakRefClass = ReflectionLookupStore.getClassReflectionCache().get(key);
            Class<?> clazz = lookupClass = weakRefClass == null ? null : (Class<?>)weakRefClass.get();
            if (lookupClass == null) {
                lookupClass = Class.forName(className, false, classloader);
                ReflectionLookupStore.getClassReflectionCache().put(key, new WeakReference(lookupClass));
            }
            return lookupClass;
        }
        catch (Exception e) {
            throw new ReflectionLookupException("Error looking up class " + className, e);
        }
    }

    static String getCacheKey(ClassLoader classloader, String className) {
        return ReflectionLookupStore.getCacheKey(classloader, className, null);
    }

    static String getCacheKey(ClassLoader classloader, String className, String methodOrFieldName) {
        StringBuilder key = new StringBuilder();
        if (classloader != null) {
            key.append(classloader.getClass().getName()).append("#").append(Integer.toHexString(classloader.hashCode())).append("#");
        }
        key.append(className);
        if (methodOrFieldName != null && !methodOrFieldName.isEmpty()) {
            key.append("#").append(methodOrFieldName);
        }
        return key.toString();
    }

    public static Class<?> lookupClass(String className, ClassLoader classLoader, boolean initialize) throws ReflectionLookupException {
        try {
            Class<?> lookupClass;
            String key = ReflectionLookupStore.getCacheKey(classLoader, className);
            WeakReference<Class> weakRefClass = ReflectionLookupStore.getClassReflectionCache().get(key);
            Class<?> clazz = lookupClass = weakRefClass == null ? null : (Class<?>)weakRefClass.get();
            if (lookupClass == null) {
                lookupClass = Class.forName(className, initialize, classLoader);
                ReflectionLookupStore.getClassReflectionCache().put(key, new WeakReference(lookupClass));
            }
            return lookupClass;
        }
        catch (Exception e) {
            throw new ReflectionLookupException("Error looking up class " + className, e);
        }
    }

    public static Field lookupField(ClassLoader classLoader, String className, String fieldName, boolean publicModifier) throws ReflectionLookupException {
        try {
            Class searchClass = ReflectionLookupStore.lookupClass(className, classLoader);
            Field searchField = ReflectionLookupStore.lookupField(searchClass, fieldName, publicModifier);
            return searchField;
        }
        catch (Exception e) {
            throw new ReflectionLookupException("Error looking up field " + fieldName + " on class " + className, e);
        }
    }

    static Field lookupField(Class classInstance, String fieldName, boolean publicModifier) throws ReflectionLookupException, NoSuchFieldException, SecurityException {
        Field lookupField;
        String key = ReflectionLookupStore.getCacheKey(classInstance.getClassLoader(), classInstance.getName(), fieldName);
        WeakReference<Field> weakRefField = ReflectionLookupStore.getFieldReflectionCache().get(key);
        Field field = lookupField = weakRefField == null ? null : (Field)weakRefField.get();
        if (lookupField == null) {
            lookupField = publicModifier ? classInstance.getField(fieldName) : classInstance.getDeclaredField(fieldName);
            lookupField.setAccessible(true);
            ReflectionLookupStore.getFieldReflectionCache().put(key, new WeakReference<Field>(lookupField));
        }
        return lookupField;
    }
}

