/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.spec.server.graph;

import com.wily.introscope.common15.properties.Messages;
import com.wily.introscope.spec.server.graph.ADirectedGraphVisitor;
import com.wily.introscope.spec.server.graph.DependencyCount;
import com.wily.introscope.spec.server.graph.IEdge;
import com.wily.introscope.spec.server.graph.IVertex;
import com.wily.introscope.spec.server.graph.TraversalEdgeType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class DependencyCountVisitor<V extends IVertex, E extends IEdge>
extends ADirectedGraphVisitor<V, E> {
    public static final int DEFAULT_MAX_NUMBER_DEPENDENCY_COUNTS = 10;
    private final HashMap<String, Integer> fOutgoingCount = new HashMap();
    private final HashMap<String, Integer> fIncomingCount = new HashMap();
    private final HashMap<String, Integer> fOutgoingImmediate = new HashMap();
    private final HashMap<String, Integer> fIncomingImmediate = new HashMap();
    private final HashMap<String, HashSet<V>> fKnownDependencies = new HashMap();
    private boolean fConverged = false;
    private DependencyCount[] fOutgoingCountArray = null;
    private DependencyCount[] fIncomingCountArray = null;
    private DependencyCount[] fOutgoingImmediateArray = null;
    private DependencyCount[] fIncomingImmediateArray = null;
    private int fHoldNumber = 10;

    public DependencyCountVisitor() {
    }

    public DependencyCountVisitor(int maxNumberDependencyCounts) {
        if (maxNumberDependencyCounts <= 0) {
            throw new IllegalArgumentException(Messages.getString("DependencyCountVisitor.DependencyCountError"));
        }
        this.fHoldNumber = maxNumberDependencyCounts;
    }

    @Override
    public void acceptEdge(V fromVertex, E visitEdge, TraversalEdgeType et, V toVertex) {
        String fromLabel = fromVertex.getLabel();
        String toLabel = toVertex.getLabel();
        this.incrementCount(this.fOutgoingCount, fromLabel);
        this.incrementCount(this.fOutgoingImmediate, fromLabel);
        this.incrementCount(this.fIncomingCount, toLabel);
        this.incrementCount(this.fIncomingImmediate, toLabel);
        HashSet<Object> known = this.fKnownDependencies.get(toLabel);
        if (known != null) {
            if (!known.contains(fromVertex)) {
                known.add(fromVertex);
                HashSet<V> indirect = this.fKnownDependencies.get(fromLabel);
                if (indirect != null) {
                    for (IVertex candidate : indirect) {
                        if (!known.add(candidate)) continue;
                        this.incrementCount(this.fOutgoingCount, candidate.getLabel());
                        this.incrementCount(this.fIncomingCount, toLabel);
                    }
                }
            }
        } else {
            known = new HashSet();
            known.add(fromVertex);
            HashSet<V> indirect = this.fKnownDependencies.get(fromLabel);
            if (indirect != null) {
                for (IVertex candidate : indirect) {
                    if (!known.add(candidate)) continue;
                    this.incrementCount(this.fOutgoingCount, candidate.getLabel());
                    this.incrementCount(this.fIncomingCount, toLabel);
                }
            }
            this.fKnownDependencies.put(toLabel, known);
        }
    }

    @Override
    public void acceptVertex(V visitVertex) {
        String vertexLabel = visitVertex.getLabel();
        if (!this.fOutgoingCount.containsKey(vertexLabel)) {
            this.fOutgoingCount.put(vertexLabel, 0);
        }
        if (!this.fIncomingCount.containsKey(vertexLabel)) {
            this.fIncomingCount.put(vertexLabel, 0);
        }
        if (!this.fOutgoingImmediate.containsKey(vertexLabel)) {
            this.fOutgoingImmediate.put(vertexLabel, 0);
        }
        if (!this.fIncomingImmediate.containsKey(vertexLabel)) {
            this.fIncomingImmediate.put(vertexLabel, 0);
        }
    }

    private void convergeKnownDependencies() {
        boolean converging = true;
        while (converging) {
            converging = false;
            for (Map.Entry<String, HashSet<V>> en : this.fKnownDependencies.entrySet()) {
                HashSet<V> known = en.getValue();
                HashSet<IVertex> newKnown = new HashSet<IVertex>();
                for (IVertex dependent : known) {
                    HashSet<V> indirect;
                    if (dependent.getLabel().equals(en.getKey()) || (indirect = this.fKnownDependencies.get(dependent.getLabel())) == null) continue;
                    for (IVertex candidate : indirect) {
                        if (known.contains(candidate) || newKnown.contains(candidate)) continue;
                        newKnown.add(candidate);
                        this.incrementCount(this.fOutgoingCount, candidate.getLabel());
                        this.incrementCount(this.fIncomingCount, en.getKey());
                    }
                }
                if (newKnown.isEmpty()) continue;
                known.addAll(newKnown);
                converging = true;
            }
        }
        this.fConverged = true;
    }

    public DependencyCount[] getIncomingCount() {
        this.postProcess();
        return this.fIncomingCountArray;
    }

    public DependencyCount[] getIncomingImmediate() {
        this.postProcess();
        return this.fIncomingImmediateArray;
    }

    public DependencyCount[] getOutgoingCount() {
        this.postProcess();
        return this.fOutgoingCountArray;
    }

    public DependencyCount[] getOutgoingImmediate() {
        this.postProcess();
        return this.fOutgoingImmediateArray;
    }

    private void incrementCount(HashMap<String, Integer> table, String label) {
        Integer count = table.get(label);
        if (count == null) {
            table.put(label, 1);
        } else {
            table.put(label, count + 1);
        }
    }

    private DependencyCount[] populateArray(HashMap<String, Integer> c) {
        ArrayList<DependencyCount> arr = new ArrayList<DependencyCount>(c.size());
        for (Map.Entry<String, Integer> en : c.entrySet()) {
            arr.add(new DependencyCount(en.getKey(), en.getValue()));
        }
        c.clear();
        Collections.sort(arr, Collections.reverseOrder());
        int lim = this.fHoldNumber < arr.size() ? this.fHoldNumber : arr.size();
        List lis = arr.subList(0, lim);
        return lis.toArray(new DependencyCount[lis.size()]);
    }

    private void postProcess() {
        if (!this.fConverged) {
            this.convergeKnownDependencies();
            this.fOutgoingCountArray = this.populateArray(this.fOutgoingCount);
            this.fIncomingCountArray = this.populateArray(this.fIncomingCount);
            this.fOutgoingImmediateArray = this.populateArray(this.fOutgoingImmediate);
            this.fIncomingImmediateArray = this.populateArray(this.fIncomingImmediate);
            this.fKnownDependencies.clear();
        }
    }
}

