/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.util;

import com.wily.introscope.agent.AgentNotAvailableException;
import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.IAgent;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.feedback.SeverityLevel;

public class Logger {
    private final IModuleFeedbackChannel feedback;
    private final Module module;

    protected Logger(String name) {
        IModuleFeedbackChannel f = null;
        try {
            IAgent agent = AgentShim.getAgent();
            f = agent.IAgent_getModuleFeedback();
            Module module = new Module(name);
        }
        catch (AgentNotAvailableException agentNotAvailableException) {
            // empty catch block
        }
        this.feedback = f;
        this.module = new Module(name);
    }

    public static Logger getLogger(String name) {
        return new Logger(name);
    }

    public static Logger getLogger(Class<?> clazz) {
        return new Logger(clazz.getName());
    }

    public void debug(Object message, Throwable t) {
        if (this.feedback == null) {
            return;
        }
        this.feedback.debug(this.module, message.toString(), t);
    }

    public void debug(Object message) {
        if (this.feedback == null) {
            return;
        }
        this.feedback.debug(this.module, message.toString());
    }

    public boolean equals(Object obj) {
        return this.equals(obj);
    }

    public void error(Object message, Throwable t) {
        if (this.feedback == null) {
            return;
        }
        this.feedback.error(this.module, message.toString(), t);
    }

    public void error(Object message) {
        if (this.feedback == null) {
            return;
        }
        this.feedback.error(this.module, message.toString());
    }

    public void fatal(Object message, Throwable t) {
        if (this.feedback == null) {
            return;
        }
        this.feedback.error(this.module, message.toString(), t);
    }

    public void fatal(Object message) {
        if (this.feedback == null) {
            return;
        }
        this.feedback.error(this.module, message.toString());
    }

    public boolean getAdditivity() {
        return false;
    }

    public SeverityLevel getEffectiveLevel() {
        if (this.feedback == null) {
            return SeverityLevel.OFF;
        }
        return this.feedback.getEffectiveLevel(this.module);
    }

    public final SeverityLevel getLevel() {
        if (this.feedback == null) {
            return SeverityLevel.OFF;
        }
        return this.feedback.getLevel(this.module);
    }

    public final String getName() {
        return this.module.getName();
    }

    public final SeverityLevel getPriority() {
        if (this.feedback == null) {
            return SeverityLevel.OFF;
        }
        return this.feedback.getLevel(this.module);
    }

    public int hashCode() {
        return this.hashCode();
    }

    public void info(Object message, Throwable t) {
        if (this.feedback == null) {
            return;
        }
        this.feedback.info(this.module, message.toString(), t);
    }

    public void info(Object message) {
        if (this.feedback == null) {
            return;
        }
        this.feedback.info(this.module, message.toString());
    }

    public boolean isDebugEnabled() {
        if (this.feedback == null) {
            return false;
        }
        return this.feedback.isDebugEnabled(this.module);
    }

    public boolean isEnabledFor(SeverityLevel level) {
        if (this.feedback == null) {
            return false;
        }
        SeverityLevel effectiveLevel = this.getEffectiveLevel();
        return !effectiveLevel.isLessThan(level);
    }

    public boolean isInfoEnabled() {
        if (this.feedback == null) {
            return false;
        }
        return this.feedback.isInfoEnabled(this.module);
    }

    public boolean isTraceEnabled() {
        if (this.feedback == null) {
            return false;
        }
        return this.feedback.isTraceEnabled(this.module);
    }

    public void log(SeverityLevel priority, Object message, Throwable t) {
        if (this.feedback == null) {
            return;
        }
        if (priority.equals(SeverityLevel.TRACE)) {
            this.feedback.trace(this.module, message.toString(), t);
        } else if (priority.equals(SeverityLevel.DEBUG)) {
            this.feedback.debug(this.module, message.toString(), t);
        } else if (priority.equals(SeverityLevel.VERBOSE)) {
            this.feedback.verbose(this.module, message.toString(), t);
        } else if (priority.equals(SeverityLevel.WARN)) {
            this.feedback.warn(this.module, message.toString(), t);
        } else if (priority.equals(SeverityLevel.ERROR)) {
            this.feedback.error(this.module, message.toString(), t);
        }
    }

    public void log(SeverityLevel priority, Object message) {
        if (this.feedback == null) {
            return;
        }
        this.log(priority, message, null);
    }

    public void log(String callerFQCN, SeverityLevel level, Object message, Throwable t) {
        if (this.feedback == null) {
            return;
        }
        this.log(level, message, t);
    }

    public void setLevel(SeverityLevel level) {
        if (this.feedback == null) {
            return;
        }
        this.feedback.setLevel(level, this.module);
    }

    public void setPriority(SeverityLevel level) {
        if (this.feedback == null) {
            return;
        }
        this.feedback.setLevel(level, this.module);
    }

    public void trace(Object message) {
        if (this.feedback == null) {
            return;
        }
        this.feedback.trace(this.module, message.toString());
    }

    public void trace(Object message, Throwable t) {
        if (this.feedback == null) {
            return;
        }
        this.feedback.trace(this.module, message.toString(), t);
    }

    public String toString() {
        if (this.feedback == null) {
            return null;
        }
        return this.feedback.toString();
    }

    public void warn(Object message, Throwable t) {
        if (this.feedback == null) {
            return;
        }
        this.feedback.warn(this.module, message.toString(), t);
    }

    public void warn(Object message) {
        if (this.feedback == null) {
            return;
        }
        this.feedback.warn(this.module, message.toString());
    }
}

