/*
 * Decompiled with CFR 0.152.
 */
package com.wily.isengard.postofficehub.link.http.client;

import com.wily.isengard.postofficehub.link.http.client.BasicHostnameVerifier;
import com.wily.isengard.postofficehub.link.net.ASSLSocketFactory;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.apache.commons.httpclient.ConnectTimeoutException;
import org.apache.commons.httpclient.params.HttpConnectionParams;
import org.apache.commons.httpclient.protocol.SecureProtocolSocketFactory;

public class TrustingSSLProtocolSocketFactory
implements SecureProtocolSocketFactory {
    private final SSLContext fContext;
    private final boolean fValidateHostname;
    private final String[] fCipherSuites;
    private final String[] fProtocols;
    private final IModuleFeedbackChannel fFeedback;
    private final Module fModule;

    public TrustingSSLProtocolSocketFactory(SSLContext context, boolean validateHostname, String[] cipherSuites, String[] protocols, IModuleFeedbackChannel feedback, Module module) {
        this.fContext = context;
        this.fValidateHostname = validateHostname;
        this.fCipherSuites = cipherSuites == null ? new String[]{} : cipherSuites;
        this.fProtocols = protocols == null ? new String[]{} : protocols;
        this.fFeedback = feedback;
        this.fModule = module;
    }

    private SSLContext getSSLContext() {
        return this.fContext;
    }

    private String[] getCipherSuites() {
        return this.fCipherSuites;
    }

    private String[] getProtocols() {
        return this.fProtocols;
    }

    public Socket createSocket(String host, int port, InetAddress clientHost, int clientPort) throws IOException, UnknownHostException {
        SSLSocket socket = (SSLSocket)this.getSSLContext().getSocketFactory().createSocket(host, port, clientHost, clientPort);
        this.validateHostname(host, socket);
        if (this.getCipherSuites().length > 0) {
            socket.setEnabledCipherSuites(this.getCipherSuites());
        }
        if (this.getProtocols().length > 0) {
            socket.setEnabledProtocols(this.getProtocols());
        }
        return socket;
    }

    public Socket createSocket(String host, int port, InetAddress localAddress, int localPort, HttpConnectionParams params) throws IOException, UnknownHostException, ConnectTimeoutException {
        SSLSocket socket;
        if (params == null) {
            throw new IllegalArgumentException("Parameters may not be null");
        }
        int timeout = params.getConnectionTimeout();
        SSLSocketFactory socketfactory = this.getSSLContext().getSocketFactory();
        if (timeout == 0) {
            socket = (SSLSocket)socketfactory.createSocket(host, port, localAddress, localPort);
        } else {
            socket = (SSLSocket)socketfactory.createSocket();
            InetSocketAddress localaddr = new InetSocketAddress(localAddress, localPort);
            InetSocketAddress remoteaddr = new InetSocketAddress(host, port);
            socket.bind(localaddr);
            socket.connect(remoteaddr, timeout);
        }
        this.validateHostname(host, socket);
        if (this.getCipherSuites().length > 0) {
            socket.setEnabledCipherSuites(this.getCipherSuites());
        }
        if (this.getProtocols().length > 0) {
            socket.setEnabledProtocols(this.getProtocols());
        }
        return socket;
    }

    private void validateHostname(final String host, SSLSocket socket) {
        if (!this.fValidateHostname) {
            return;
        }
        if (ASSLSocketFactory.enableHostnameValidation(socket)) {
            return;
        }
        socket.addHandshakeCompletedListener(new HandshakeCompletedListener(){

            private void close(HandshakeCompletedEvent event) {
                try {
                    event.getSocket().close();
                }
                catch (IOException iOException) {}
            }

            @Override
            public void handshakeCompleted(HandshakeCompletedEvent event) {
                Certificate[] certificates;
                try {
                    certificates = event.getPeerCertificates();
                }
                catch (SSLPeerUnverifiedException sslException) {
                    TrustingSSLProtocolSocketFactory.this.fFeedback.warn(TrustingSSLProtocolSocketFactory.this.fModule, "Cannot verify remote host, close the connection: " + sslException.getMessage());
                    this.close(event);
                    return;
                }
                try {
                    BasicHostnameVerifier.verify(host, (X509Certificate)certificates[0]);
                }
                catch (CertificateException e) {
                    TrustingSSLProtocolSocketFactory.this.fFeedback.warn(TrustingSSLProtocolSocketFactory.this.fModule, "Invalid identity of remote host: " + e.getMessage());
                    this.close(event);
                    return;
                }
            }
        });
    }

    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        SSLSocket socket = (SSLSocket)this.getSSLContext().getSocketFactory().createSocket(host, port);
        this.validateHostname(host, socket);
        if (this.getCipherSuites().length > 0) {
            socket.setEnabledCipherSuites(this.getCipherSuites());
        }
        if (this.getProtocols().length > 0) {
            socket.setEnabledProtocols(this.getProtocols());
        }
        return socket;
    }

    public Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException, UnknownHostException {
        SSLSocket socket2 = (SSLSocket)this.getSSLContext().getSocketFactory().createSocket(socket, host, port, autoClose);
        this.validateHostname(host, socket2);
        if (this.getCipherSuites().length > 0) {
            socket2.setEnabledCipherSuites(this.getCipherSuites());
        }
        if (this.getProtocols().length > 0) {
            socket2.setEnabledProtocols(this.getProtocols());
        }
        return socket2;
    }

    public boolean equals(Object obj) {
        return obj != null && obj.getClass().equals(TrustingSSLProtocolSocketFactory.class);
    }

    public int hashCode() {
        return TrustingSSLProtocolSocketFactory.class.hashCode();
    }
}

