/*
 * Decompiled with CFR 0.152.
 */
package com.wily.isengard.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.lang.reflect.Proxy;

public class SanitizingClassLoaderObjectInputStream
extends ObjectInputStream {
    private final ClassLoader classLoader;
    String[] allowedClasses;
    String[] deniedClasses;

    public SanitizingClassLoaderObjectInputStream(ClassLoader classLoader, InputStream inputStream) throws IOException {
        super(inputStream);
        this.classLoader = classLoader;
    }

    public SanitizingClassLoaderObjectInputStream(ClassLoader classLoader, InputStream inputStream, String[] allowedClasses, String[] deniedClasses) throws IOException {
        this(classLoader, inputStream);
        this.allowedClasses = allowedClasses == null || allowedClasses.length == 0 ? new String[]{} : allowedClasses;
        this.deniedClasses = deniedClasses == null || deniedClasses.length == 0 ? new String[]{} : deniedClasses;
    }

    protected Class resolveClass(ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
        String className = objectStreamClass.getName();
        if (this.deniedClasses.length != 0 && this.isFiltered(className, this.deniedClasses)) {
            throw new SecurityException("Deserialization is blocked for security reasons for class: " + className);
        }
        if (this.allowedClasses.length != 0 && !this.isFiltered(className, this.allowedClasses)) {
            throw new SecurityException("Deserialization is blocked for security reasons for class: " + className);
        }
        try {
            return Class.forName(className, false, this.classLoader);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return super.resolveClass(objectStreamClass);
        }
    }

    protected Class resolveProxyClass(String[] interfaces) throws IOException, ClassNotFoundException {
        Class[] interfaceClasses = new Class[interfaces.length];
        int i = 0;
        while (i < interfaces.length) {
            interfaceClasses[i] = Class.forName(interfaces[i], false, this.classLoader);
            ++i;
        }
        try {
            return Proxy.getProxyClass(this.classLoader, interfaceClasses);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return super.resolveProxyClass(interfaces);
        }
    }

    boolean isFiltered(String className, String[] classes) {
        int z = 0;
        while (z < classes.length) {
            String filteredClass = classes[z];
            if (className.equals(filteredClass)) {
                return true;
            }
            ++z;
        }
        return false;
    }
}

