/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.webservices.extension.agent.trace.nameformatter.websphere;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.powerpack.webservices.WSMUtils;
import com.wily.powerpack.webservices.extension.agent.trace.nameformatter.JAXWSNameFormatter;
import java.io.ByteArrayInputStream;
import java.util.Arrays;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;

public class JAXWSServerEndpointCtrlNameformatter
extends JAXWSNameFormatter {
    public JAXWSServerEndpointCtrlNameformatter(IAgent agent) {
        super(agent);
    }

    @Override
    public final String getServiceName(InvocationData data) {
        Object serviceURI;
        block21: {
            serviceURI = (String)data.get("com.wily.powerpack.webservices.trace.ServiceNameKey");
            if (serviceURI != null) {
                return serviceURI;
            }
            try {
                Object objEndpointInvocation;
                Object objRequestMessageContext;
                Object objOperationClient;
                Object objGetOperationContext;
                Object objServiceContext;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("JAXWSServerEndpointCtrlNameformatter:getServiceName");
                }
                if ((objServiceContext = WSMUtils.invokeMethodOnObject(objGetOperationContext = WSMUtils.invokeMethodOnObject(objOperationClient = WSMUtils.invokeMethodOnObject(objRequestMessageContext = WSMUtils.invokeMethodOnObject(objEndpointInvocation = data.getInvocationParameterAsObject(0), "getRequestMessageContext"), "getAxisMessageContext"), "getOperationContext"), "getServiceContext")) == null) break block21;
                try {
                    Object endpointReference;
                    Object transportInDesc = WSMUtils.invokeMethodOnObject(objOperationClient, "getTransportIn");
                    String transportIn = (String)WSMUtils.invokeMethodOnObject(transportInDesc, "getName");
                    if (this.logger.isTraceEnabled()) {
                        this.logger.debug("JAXWSServerEndpointCtrlNameformatter::TransportIn " + transportIn);
                    }
                    if ((endpointReference = WSMUtils.invokeMethodOnObject(objServiceContext, "getMyEPR", new Class[]{String.class}, new Object[]{transportIn})) != null) {
                        serviceURI = (String)WSMUtils.invokeMethodOnObject(endpointReference, "getAddress");
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug("JAXWSServerEndpointCtrlNameformatter::getServiceName  getMyEPR(transport) serviceURI=" + (String)serviceURI);
                        }
                    } else {
                        Object axisService = WSMUtils.invokeMethodOnObject(objOperationClient, "getAxisService");
                        Object[] eprs = (String[])WSMUtils.invokeMethodOnObject(axisService, "getEPRs");
                        if (eprs != null) {
                            if (this.logger.isDebugEnabled()) {
                                this.logger.debug("JAXWSServerEndpointCtrlNameformatter::getServiceName Available EPRs :\n" + Arrays.toString(eprs));
                            }
                            if (eprs.length == 1) {
                                serviceURI = eprs[0];
                            } else {
                                for (int i = 0; i < eprs.length; ++i) {
                                    if (eprs[i] == null || !((String)eprs[i]).toLowerCase().startsWith(transportIn.toLowerCase() + ":")) continue;
                                    serviceURI = eprs[i];
                                    break;
                                }
                            }
                            if (this.logger.isDebugEnabled()) {
                                this.logger.debug("JAXWSServerEndpointCtrlNameformatter::getServiceName  getEPRs returned serviceURI=" + (String)serviceURI);
                            }
                        }
                    }
                }
                catch (Exception e) {
                    try {
                        Object endpointReference = WSMUtils.invokeMethodOnObject(objServiceContext, "getMyEPR");
                        if (endpointReference != null) {
                            serviceURI = (String)WSMUtils.invokeMethodOnObject(endpointReference, "getAddress");
                            if (this.logger.isDebugEnabled()) {
                                this.logger.debug("JAXWSServerEndpointCtrlNameformatter::getServiceName  serviceURI=" + (String)serviceURI);
                            }
                        }
                    }
                    catch (Exception ee) {
                        WSMUtils.handleException(this.getAgent(), "JAXWSServerEndpointCtrlNameformatter:getServiceName exception", ee);
                    }
                }
            }
            catch (Throwable bomb) {
                WSMUtils.handleException(this.getAgent(), "JAXWSServerEndpointCtrlNameformatter:getServiceName exception", bomb);
            }
        }
        if (serviceURI == null || ((String)serviceURI).equals("")) {
            serviceURI = "UnknownService";
        }
        data.put("com.wily.powerpack.webservices.trace.ServiceNameKey", serviceURI);
        return serviceURI;
    }

    @Override
    public final String getOperationName(InvocationData data) {
        String operationName = (String)data.get("com.wily.powerpack.webservices.trace.OperationNameKey");
        if (operationName != null) {
            return operationName;
        }
        try {
            block45: {
                Object objEndpointInvocation = data.getInvocationParameterAsObject(0);
                Object objRequestMessageContext = WSMUtils.invokeMethodOnObject(objEndpointInvocation, "getRequestMessageContext");
                Object objOperationClient = WSMUtils.invokeMethodOnObject(objRequestMessageContext, "getAxisMessageContext");
                Object objGetOperationContext = WSMUtils.invokeMethodOnObject(objOperationClient, "getOperationContext");
                Object strOperationName = WSMUtils.invokeMethodOnObject(objGetOperationContext, "getOperationName");
                if (strOperationName != null) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("JAXWSServerEndpointCtrlNameformatter:getOperationName operationname=" + strOperationName.toString());
                    }
                    operationName = WSMUtils.formatToBeResourceSafe(strOperationName.toString());
                } else {
                    operationName = "UnknownOperationName";
                }
                if ("jaxwsNoWSDLProviderOperation".equalsIgnoreCase(operationName)) {
                    try {
                        String opName;
                        block44: {
                            String ns;
                            Object soapBody;
                            block43: {
                                Object ns1;
                                Object ns12;
                                block41: {
                                    Object soapEnvelope = WSMUtils.invokeMethodOnObject(objOperationClient, "getEnvelope");
                                    soapBody = WSMUtils.invokeMethodOnObject(soapEnvelope, "getBody");
                                    if (this.logger.isTraceEnabled()) {
                                        this.logger.trace("JAXWSServerEndpointCtrlNameformatter :: soapBody = " + soapBody);
                                    }
                                    opName = null;
                                    ns = null;
                                    try {
                                        opName = (String)WSMUtils.invokeMethodOnObject(soapBody, "getFirstElementLocalName");
                                        if (this.logger.isDebugEnabled()) {
                                            this.logger.debug("JAXWSServerEndpointCtrlNameformatter :: getFirstElementLocalName = " + opName);
                                        }
                                        Object nameSpace = WSMUtils.invokeMethodOnObject(soapBody, "getFirstElementNS");
                                        ns = (String)WSMUtils.invokeMethodOnObject(nameSpace, "getNamespaceURI");
                                        data.put("com.wily.powerpack.webservices.trace.NamespaceKey", (Object)ns);
                                        if (this.logger.isDebugEnabled()) {
                                            this.logger.debug("JAXWSServerEndpointCtrlNameformatter :: getFirstElementNS = " + ns);
                                        }
                                    }
                                    catch (Exception e1) {
                                        if (!this.logger.isDebugEnabled()) break block41;
                                        this.logger.debug("JAXWSServerEndpointCtrlNameformatter :: Exception : " + e1.getMessage());
                                    }
                                }
                                if (opName == null || ns == null) {
                                    try {
                                        Object firstElement = WSMUtils.invokeMethodOnObject(soapBody, "getFirstElement");
                                        try {
                                            opName = (String)WSMUtils.invokeMethodOnObject(firstElement, "getLocalName");
                                            if (this.logger.isDebugEnabled()) {
                                                this.logger.debug("JAXWSServerEndpointCtrlNameformatter :: getFirstElement().getLocalName() = " + opName);
                                            }
                                            ns12 = WSMUtils.invokeMethodOnObject(firstElement, "getTextAsQName");
                                            ns = ns12.toString();
                                            data.put("com.wily.powerpack.webservices.trace.NamespaceKey", (Object)ns);
                                            if (this.logger.isDebugEnabled()) {
                                                this.logger.debug("JAXWSServerEndpointCtrlNameformatter :: getFirstElement().getTextAsQName = " + ns);
                                            }
                                        }
                                        catch (Exception eee) {
                                            if (this.logger.isDebugEnabled()) {
                                                this.logger.debug("JAXWSServerEndpointCtrlNameformatter :: Exception : " + eee.getMessage(), (Throwable)eee);
                                            }
                                            Object nextSibling = WSMUtils.invokeMethodOnObject(firstElement, "getNextSibling");
                                            opName = (String)WSMUtils.invokeMethodOnObject(nextSibling, "getLocalName");
                                            if (this.logger.isDebugEnabled()) {
                                                this.logger.debug("JAXWSServerEndpointCtrlNameformatter :: getOperationName :: getFirstElement().getNextSibling().getLocalName() = " + opName);
                                            }
                                            ns1 = WSMUtils.invokeMethodOnObject(nextSibling, "getTextAsQName");
                                            ns = ns1.toString();
                                            data.put("com.wily.powerpack.webservices.trace.NamespaceKey", (Object)ns);
                                            if (this.logger.isDebugEnabled()) {
                                                this.logger.debug("JAXWSServerEndpointCtrlNameformatter :: getFirstElement().getNextSibling().getTextAsQName = " + ns);
                                            }
                                        }
                                    }
                                    catch (Exception e1) {
                                        this.logger.debug("JAXWSServerEndpointCtrlNameformatter :: Exception : " + e1.getMessage(), (Throwable)e1);
                                    }
                                }
                                if (opName == null || ns == null) {
                                    try {
                                        Object firstChild = WSMUtils.invokeMethodOnObject(soapBody, "getFirstOMChild");
                                        try {
                                            opName = (String)WSMUtils.invokeDeclaredMethodOnObject(firstChild, "getLocalName");
                                            if (this.logger.isDebugEnabled()) {
                                                this.logger.debug("JAXWSServerEndpointCtrlNameformatter :: getFirstOMChild().getLocalName() = " + opName);
                                            }
                                            ns12 = WSMUtils.invokeMethodOnObject(firstChild, "getTextAsQName");
                                            ns = ns12.toString();
                                            data.put("com.wily.powerpack.webservices.trace.NamespaceKey", (Object)ns);
                                            if (this.logger.isDebugEnabled()) {
                                                this.logger.debug("JAXWSServerEndpointCtrlNameformatter :: getFirstOMChild().getTextAsQName = " + ns);
                                            }
                                        }
                                        catch (Exception eee) {
                                            if (this.logger.isDebugEnabled()) {
                                                this.logger.debug("Exception : " + eee.getMessage(), (Throwable)eee);
                                            }
                                            Object nextOMSibling = WSMUtils.invokeMethodOnObject(firstChild, "getNextOMSibling");
                                            opName = (String)WSMUtils.invokeMethodOnObject(nextOMSibling, "getLocalName");
                                            if (this.logger.isDebugEnabled()) {
                                                this.logger.debug("JAXWSServerEndpointCtrlNameformatter :: getOperationName :: getFirstOMChild().getNextOMSibling().getLocalName() = " + opName);
                                            }
                                            ns1 = WSMUtils.invokeMethodOnObject(nextOMSibling, "getTextAsQName");
                                            ns = ns1.toString();
                                            data.put("com.wily.powerpack.webservices.trace.NamespaceKey", (Object)ns);
                                            if (this.logger.isDebugEnabled()) {
                                                this.logger.debug("JAXWSServerEndpointCtrlNameformatter :: getFirstOMChild().getNextOMSibling().getTextAsQName = " + ns);
                                            }
                                        }
                                    }
                                    catch (Exception e1) {
                                        if (!this.logger.isDebugEnabled()) break block43;
                                        this.logger.debug("JAXWSServerEndpointCtrlNameformatter :: Exception : " + e1.getMessage(), (Throwable)e1);
                                    }
                                }
                            }
                            if (opName == null || ns == null) {
                                try {
                                    String sb = (String)WSMUtils.invokeMethodOnObject(soapBody, "toString");
                                    XMLInputFactory inputFactory = XMLInputFactory.newInstance();
                                    XMLStreamReader xmlStreamReader = inputFactory.createXMLStreamReader(new ByteArrayInputStream(sb.getBytes("UTF-8")));
                                    xmlStreamReader.next();
                                    if (this.logger.isDebugEnabled()) {
                                        this.logger.debug("JAXWSServerEndpointCtrlNameformatter :: First Element parsed = " + xmlStreamReader.getLocalName());
                                    }
                                    xmlStreamReader.next();
                                    opName = xmlStreamReader.getLocalName();
                                    if (this.logger.isDebugEnabled()) {
                                        this.logger.debug("JAXWSServerEndpointCtrlNameformatter :: Second Element :: Operation Name = " + opName);
                                    }
                                    ns = xmlStreamReader.getNamespaceURI();
                                    if (this.logger.isDebugEnabled()) {
                                        this.logger.debug("JAXWSServerEndpointCtrlNameformatter :: Second Element :: nameSpace = " + ns);
                                    }
                                }
                                catch (Exception e) {
                                    if (!this.logger.isDebugEnabled()) break block44;
                                    this.logger.debug("JAXWSServerEndpointCtrlNameformatter :: Exception : " + e.getMessage(), (Throwable)e);
                                }
                            }
                        }
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug("JAXWSServerEndpointCtrlNameformatter :: opName = " + opName);
                        }
                        operationName = opName;
                    }
                    catch (Exception e) {
                        if (!this.logger.isDebugEnabled()) break block45;
                        this.logger.debug("JAXWSServerEndpointCtrlNameformatter :: Exception : " + e.getMessage(), (Throwable)e);
                    }
                }
            }
            data.put("com.wily.powerpack.webservices.trace.OperationNameKey", (Object)operationName);
            return operationName;
        }
        catch (Throwable bomb) {
            WSMUtils.handleException(this.getAgent(), "JAXWSServerEndpointCtrlNameformatter:getOperationName exception", bomb);
            return "UnknownOperationName";
        }
    }

    @Override
    public final String getNamespace(InvocationData data) {
        this.getOperationName(data);
        String namespaceURI = (String)data.get("com.wily.powerpack.webservices.trace.NamespaceKey");
        if (namespaceURI != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("JAXWSServerEndpointCtrlNameformatter: getNamespace fromCache=" + namespaceURI);
            }
            return namespaceURI;
        }
        try {
            this.logger.debug("JAXWSServerEndpointCtrlNameformatter:getNamespace");
            Object objEndpointInvocation = data.getInvocationParameterAsObject(0);
            Object objRequestMessageContext = WSMUtils.invokeMethodOnObject(objEndpointInvocation, "getRequestMessageContext");
            Object objOperationClient = WSMUtils.invokeMethodOnObject(objRequestMessageContext, "getAxisMessageContext");
            Object objGetOperationContext = WSMUtils.invokeMethodOnObject(objOperationClient, "getOperationContext");
            Object objServiceContext = WSMUtils.invokeMethodOnObject(objGetOperationContext, "getServiceContext");
            Object objService = WSMUtils.invokeMethodOnObject(objServiceContext, "getAxisService");
            Object targetNamespace = WSMUtils.invokeMethodOnObject(objService, "getTargetNamespace");
            if (targetNamespace != null) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("JAXWSServerEndpointCtrlNameformatter:getNamespace namespace=" + targetNamespace.toString());
                }
                namespaceURI = WSMUtils.formatToBeResourceSafe(targetNamespace.toString());
            } else {
                namespaceURI = this.getServiceName(data);
            }
        }
        catch (Throwable bomb) {
            WSMUtils.handleException(this.getAgent(), "JAXWSServerEndpointCtrlNameformatter:getNamespace exception", bomb);
            return this.getServiceName(data);
        }
        if (namespaceURI == null || namespaceURI.equals("")) {
            namespaceURI = "UnknownService";
        }
        data.put("com.wily.powerpack.webservices.trace.NamespaceKey", (Object)namespaceURI);
        return namespaceURI;
    }
}

