/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.stat.IIntegerFluctuatingCounterDataAccumulator;
import com.wily.introscope.agent.trace.ASingleInstanceTracerFactory;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.ReentrancyLevel;
import com.wily.introscope.stat.blame.BlameStackSnapshot;
import com.wily.util.properties.AttributeListing;

public class MethodInvocationCounter
extends ASingleInstanceTracerFactory {
    private InvocationMetricHolder fHolder;

    public MethodInvocationCounter(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
    }

    @Override
    public final ReentrancyLevel ITracerFactory_getReentrancyLevel() {
        return ReentrancyLevel.kMethodName;
    }

    @Override
    public boolean ITracerFactory_isShutoff() {
        return false;
    }

    @Override
    public void ITracer_startTrace(int tracerIndex, InvocationData data) {
        InvocationMetricHolder holder = this.getInvocationMetricHolder(data);
        BlameStackSnapshot snapshot = this.getBlameStackSnapshot(data, holder);
        holder.getCategoryCount().IIntegerFluctuatingCounterDataAccumulator_increment(snapshot);
        holder.getInstanceCount().IIntegerFluctuatingCounterDataAccumulator_increment(snapshot);
        holder.getMethodCount().IIntegerFluctuatingCounterDataAccumulator_increment(snapshot);
    }

    protected BlameStackSnapshot getBlameStackSnapshot(InvocationData data, InvocationMetricHolder holder) {
        return BlameStackSnapshot.kEmptyBlameStackSnapshot;
    }

    @Override
    public void ITracer_finishTrace(int tracerIndex, InvocationData data) {
    }

    protected final InvocationMetricHolder getInvocationMetricHolder(InvocationData data) {
        if (this.canUseCaching()) {
            if (this.fHolder == null) {
                this.fHolder = new InvocationMetricHolder(data);
            }
            return this.fHolder;
        }
        return new InvocationMetricHolder(data);
    }

    protected final class InvocationMetricHolder {
        private final String fComponent;
        private final IIntegerFluctuatingCounterDataAccumulator fCategoryCount;
        private final IIntegerFluctuatingCounterDataAccumulator fInstanceCount;
        private final IIntegerFluctuatingCounterDataAccumulator fMethodCount;

        public InvocationMetricHolder(InvocationData data) {
            String category = MethodInvocationCounter.this.formatParameterizedName(data);
            String categoryMetric = category + ":" + "Total Method Invocations";
            this.fCategoryCount = MethodInvocationCounter.this.getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator(categoryMetric);
            String instance = category + "|" + MethodInvocationCounter.this.getProbeIdentification().getProbeClassName();
            String instanceMetric = instance + ":" + "Total Method Invocations";
            this.fInstanceCount = MethodInvocationCounter.this.getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator(instanceMetric);
            this.fComponent = instance + "|" + MethodInvocationCounter.this.getProbeIdentification().getProbeMethodName();
            String methodMetric = this.fComponent + ":" + "Total Method Invocations";
            this.fMethodCount = MethodInvocationCounter.this.getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator(methodMetric);
        }

        public final String getComponent() {
            return this.fComponent;
        }

        public final IIntegerFluctuatingCounterDataAccumulator getCategoryCount() {
            return this.fCategoryCount;
        }

        public final IIntegerFluctuatingCounterDataAccumulator getInstanceCount() {
            return this.fInstanceCount;
        }

        public final IIntegerFluctuatingCounterDataAccumulator getMethodCount() {
            return this.fMethodCount;
        }
    }
}

