/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.spec.agent.beans.dynamicinstrumentation;

import com.wily.introscope.spec.agent.beans.dynamicinstrumentation.DynamicInstrumentationResult;
import com.wily.introscope.spec.agent.beans.dynamicinstrumentation.IDynamicInstrumentationListener;
import com.wily.introscope.spec.server.beans.dynamicinstrumentationtrace.BaseDINotification;
import com.wily.introscope.spec.server.beans.dynamicinstrumentationtrace.DynamicInstrumentationNotificationConnector;
import com.wily.introscope.spec.server.beans.dynamicinstrumentationtrace.IBaseDINotification;
import com.wily.introscope.spec.server.beans.dynamicinstrumentationtrace.TemporaryInstrumentationNotification;
import com.wily.isengard.messageprimitives.ConnectionException;
import com.wily.isengard.messageprimitives.callback.Callback;
import com.wily.isengard.messageprimitives.callback.CallbackConnector;
import com.wily.isengard.messageprimitives.callback.ICallback;
import com.wily.isengard.messageprimitives.callback.ICallbackConnectorCloseNotification;
import com.wily.isengard.messageprimitives.pipe.EndpointNotFoundException;
import com.wily.isengard.postoffice.PostOffice;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import java.util.ArrayList;
import java.util.List;

public class DynamicInstrumentationListener
implements IDynamicInstrumentationListener {
    protected final DynamicInstrumentationNotificationConnector fNotificationConnector;
    protected final List fRemoteNotifications;
    private final PostOffice fPostOffice;
    private final IModuleFeedbackChannel kLog;
    private final Module kModule;

    DynamicInstrumentationListener(PostOffice po, TemporaryInstrumentationNotification notification) throws EndpointNotFoundException {
        this.kLog = null;
        this.kModule = null;
        this.fPostOffice = po;
        if (notification != null) {
            this.fRemoteNotifications = new ArrayList();
            ICallbackConnectorCloseNotification closeNotification = new ICallbackConnectorCloseNotification(){

                @Override
                public void closing(CallbackConnector connector) {
                    DynamicInstrumentationListener.this.teardown();
                }
            };
            this.fNotificationConnector = new DynamicInstrumentationNotificationConnector(this.fPostOffice, notification, closeNotification);
        } else {
            this.fRemoteNotifications = new ArrayList();
            this.fNotificationConnector = null;
        }
    }

    public DynamicInstrumentationListener(IModuleFeedbackChannel log, Module module, PostOffice po, BaseDINotification notification) throws EndpointNotFoundException {
        this.kLog = log;
        this.kModule = module;
        this.fPostOffice = po;
        this.fRemoteNotifications = new ArrayList();
        ICallbackConnectorCloseNotification closeNotification = new ICallbackConnectorCloseNotification(){

            @Override
            public void closing(CallbackConnector connector) {
                DynamicInstrumentationListener.this.teardown();
            }
        };
        this.fNotificationConnector = new DynamicInstrumentationNotificationConnector(this.fPostOffice, notification, closeNotification);
    }

    protected void onTeardown() {
    }

    protected synchronized void teardown() {
        this.onTeardown();
        for (CallbackConnector next : this.fRemoteNotifications) {
            next.close();
        }
        if (this.fNotificationConnector != null && !this.fNotificationConnector.isClosed()) {
            this.fNotificationConnector.close();
        }
        this.fRemoteNotifications.clear();
    }

    public CallbackConnector addRemoteCallback(PostOffice adderPostOffice, Callback agentCallback) throws EndpointNotFoundException {
        ICallbackConnectorCloseNotification closeNotification = new ICallbackConnectorCloseNotification(){

            @Override
            public void closing(CallbackConnector connector) {
                DynamicInstrumentationListener.this.teardown();
            }
        };
        CallbackConnector notificationToAgent = new CallbackConnector(adderPostOffice, agentCallback, ICallback.class, closeNotification);
        this.fRemoteNotifications.add(notificationToAgent);
        return notificationToAgent;
    }

    @Override
    public void deliverResult(DynamicInstrumentationResult result) {
        try {
            IBaseDINotification notification = this.getNotificationConnectorInterface();
            if (notification != null) {
                if (result != null && this.kLog != null && this.kModule != null && this.kLog.isDebugEnabled(this.kModule)) {
                    this.kLog.debug(this.kModule, "Delivering result with error status " + result.getErrorStatus());
                }
                notification.executeOnResult(result);
            }
        }
        catch (ConnectionException connectionException) {
            this.teardown();
        }
    }

    private IBaseDINotification getNotificationConnectorInterface() {
        if (this.fNotificationConnector != null) {
            return (IBaseDINotification)this.fNotificationConnector.getInterface();
        }
        return null;
    }
}

