/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.feature;

import com.wily.introscope.agent.async.AsyncVirtualStack;
import com.wily.introscope.agent.feature.StallFeatureBase;
import com.wily.introscope.agent.feature.StallPoint;
import com.wily.introscope.agent.remote.RemoteThread;
import com.wily.introscope.agent.trace.IStackElement;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.cas.IIntegerFluctuatingCounterDataAccumulatorWrapper;
import com.wily.introscope.agent.trace.cas.INotAnOldModeStallSubscriber;
import com.wily.introscope.agent.trace.cas.IOldModeStallSubscriber;
import com.wily.introscope.agent.trace.cas.IRepository;
import com.wily.introscope.agent.trace.cas.IStallSubscriber;
import com.wily.introscope.agent.trace.cas.ITransactionCacheProviderFactory;
import com.wily.introscope.agent.trace.cas.ITransactionElement;
import com.wily.introscope.agent.trace.cas.StackRecursionHelper;
import com.wily.introscope.agent.trace.cas.TransactionTransitionException;
import com.wily.introscope.agent.trace.cas.UpdaterFactory;
import com.wily.introscope.agent.trace.hc2.WilyTransactionStructure;
import com.wily.introscope.agent.transformer.dynamic.OverheadAdministrator;
import com.wily.introscope.agent.transformer.dynamic.OverheadMode;
import com.wily.util.heartbeat.ITimestampedRunnable;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

final class StallCheckBehaviorCorrect
implements ITimestampedRunnable {
    StallCheckBehaviorCorrect() {
    }

    private static boolean checkWithOverheadMgr() {
        return OverheadMode.LOW_WITH_ONLY_FRONTEND_BACKEND == OverheadAdministrator.getOverheadMode() || OverheadMode.ABSOLUTE_LOW == OverheadAdministrator.getOverheadMode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void ITimestampedRunnable_execute(long nowInMillis) {
        if (StallCheckBehaviorCorrect.checkWithOverheadMgr()) {
            return;
        }
        StallFeatureBase.checkAndDecrementStallsIfFinished();
        AsyncVirtualStack.runStallCheck(StallFeatureBase.sStallThreshold.get(), StallFeatureBase.sTxnAsyncAbortThreshold.get());
        long stalledStart = nowInMillis - StallFeatureBase.sStallThreshold.get();
        WilyTransactionStructure structure = WilyTransactionStructure.getInstance();
        Iterator i = StallFeatureBase.getStallPointsEntrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = (Map.Entry)i.next();
            HashSet reportedRepositories = new HashSet();
            try {
                Runnable t = (Runnable)((WeakReference)entry.getKey()).get();
                if (t instanceof Thread && ((Thread)t).isAlive() || t instanceof RemoteThread && ((RemoteThread)t).isAlive()) {
                    IStackElement currentInvocationData;
                    StallPoint stallPoint = (StallPoint)entry.getValue();
                    if (stallPoint == null || (currentInvocationData = stallPoint.getData()) == null) continue;
                    if (StallCheckBehaviorCorrect.shouldAbortTransaction(currentInvocationData, nowInMillis)) {
                        this.abortTransaction(currentInvocationData, nowInMillis);
                        continue;
                    }
                    if (StallFeatureBase.hasAlreadyReported(currentInvocationData) || currentInvocationData.isTransactionAborted()) continue;
                    boolean isTopComponentOnStackStalled = StallCheckBehaviorCorrect.isComponentStalled(currentInvocationData, stalledStart, structure);
                    if (isTopComponentOnStackStalled) {
                        StallCheckBehaviorCorrect.incrementSelfRepositories(reportedRepositories, currentInvocationData, nowInMillis);
                        StallCheckBehaviorCorrect.incrementUpStreamRepositoriesIfSubscribed(reportedRepositories, currentInvocationData, nowInMillis);
                        if (StallFeatureBase.reportStall(currentInvocationData)) continue;
                        structure.getAgent().IAgent_getModuleFeedback().debug("Top of the stack stalled, but no root component.");
                        structure.getAgent().IAgent_getModuleFeedback().debug("InvocationData: " + currentInvocationData.getComponentName());
                        continue;
                    }
                    IStackElement stalledParent = StallCheckBehaviorCorrect.findStalledParentIfAny(currentInvocationData.getParent(), nowInMillis, stalledStart, structure);
                    if (stalledParent == null || StallFeatureBase.hasAlreadyReported(stalledParent)) continue;
                    StallCheckBehaviorCorrect.incrementSelfRepositories(reportedRepositories, stalledParent, nowInMillis);
                    StallCheckBehaviorCorrect.incrementUpStreamRepositoriesIfSubscribed(reportedRepositories, stalledParent, nowInMillis);
                    if (StallFeatureBase.reportStall(stalledParent)) continue;
                    structure.getAgent().IAgent_getModuleFeedback().debug("Thousand paper cuts stall, but no top component.");
                    structure.getAgent().IAgent_getModuleFeedback().debug("InvocationData: " + currentInvocationData.getComponentName());
                    continue;
                }
                StallFeatureBase.getStallPoints().removeWeak(t);
                continue;
            }
            catch (NoSuchElementException e) {
                continue;
            }
            catch (IllegalStateException e1) {
                continue;
            }
            catch (TransactionTransitionException tte) {
                continue;
            }
            catch (Exception e) {
                structure.getAgent().IAgent_getModuleFeedback().debug("Unexpected error in handling stall check for thread " + entry.getKey(), e);
                if (!structure.getAgent().IAgent_getModuleFeedback().isDebugEnabled()) continue;
                structure.getAgent().IAgent_getModuleFeedback().debug(e.getMessage(), e);
                continue;
            }
            finally {
                reportedRepositories.clear();
                continue;
            }
            break;
        }
        return;
    }

    private static boolean isComponentStalled(IStackElement currentInvocationData, long stallStart, WilyTransactionStructure structure) {
        return StallFeatureBase.isComponentStalled(currentInvocationData, stallStart);
    }

    private static void incrementSelfRepositories(Set vetoedRepositories, IStackElement currentInvocationData, long nowInMillis) {
        if (!(currentInvocationData instanceof INotAnOldModeStallSubscriber)) {
            if (currentInvocationData instanceof IOldModeStallSubscriber) {
                IOldModeStallSubscriber oldSubscriber = (IOldModeStallSubscriber)((Object)currentInvocationData);
                StallCheckBehaviorCorrect.updateStallRepository(vetoedRepositories, currentInvocationData, nowInMillis, oldSubscriber, false);
            } else {
                for (int j = 0; j < currentInvocationData.getStartCursorsCount(); ++j) {
                    IStallSubscriber stallSub;
                    ITransactionElement wte = currentInvocationData.getStartCursorAt(j);
                    if (wte == null || (stallSub = wte.getStallSubscriber()) == null) continue;
                    StallCheckBehaviorCorrect.updateStallRepository(vetoedRepositories, currentInvocationData, nowInMillis, stallSub, false);
                }
            }
            currentInvocationData.setStalled();
        }
    }

    private static IStackElement findStalledParentIfAny(IStackElement parentInvocationData, long nowInMillis, long stallStart, WilyTransactionStructure structure) {
        int stackRecursionCounter = 0;
        for (IStackElement pivot = parentInvocationData; pivot != null; pivot = pivot.getParent()) {
            if (!StallCheckBehaviorCorrect.isComponentStalled(pivot, stallStart, structure)) continue;
            return parentInvocationData;
        }
        return null;
    }

    private static void incrementUpStreamRepositoriesIfSubscribed(Set vetoedRepositories, IStackElement currentInvocationData, long nowInMillis) {
        IStackElement pivot = currentInvocationData.getParent();
        int stackRecursionCounter = 0;
        while (pivot != null) {
            if (StallFeatureBase.hasAlreadyReported(pivot)) {
                pivot = pivot.getParent();
                if (stackRecursionCounter++ <= StackRecursionHelper.kMaxRecursive) continue;
                throw new TransactionTransitionException("Exceeded depth of stack, most likely because the stack is corrupted.");
            }
            if (!(pivot instanceof INotAnOldModeStallSubscriber)) {
                if (pivot instanceof IOldModeStallSubscriber) {
                    IOldModeStallSubscriber oldSubscriber = (IOldModeStallSubscriber)((Object)pivot);
                    StallCheckBehaviorCorrect.updateStallRepository(vetoedRepositories, pivot, nowInMillis, oldSubscriber, true);
                } else if (pivot instanceof InvocationData) {
                    for (int j = 0; j < pivot.getStartCursorsCount(); ++j) {
                        IStallSubscriber stallSub;
                        ITransactionElement wte = pivot.getStartCursorAt(j);
                        if (wte == null || (stallSub = wte.getStallSubscriber()) == null || !stallSub.subscribeToDownstreamStalls()) continue;
                        StallCheckBehaviorCorrect.updateStallRepository(vetoedRepositories, pivot, nowInMillis, stallSub, true);
                    }
                }
            }
            pivot = pivot.getParent();
            if (stackRecursionCounter++ <= StackRecursionHelper.kMaxRecursive) continue;
            throw new TransactionTransitionException("Exceeded depth of stack, most likely because the stack is corrupted.");
        }
    }

    private static void updateStallRepository(Set vetoedRepositories, IStackElement invocationData, long nowInMillis, IOldModeStallSubscriber stallSub, boolean isSubscriber) {
        IIntegerFluctuatingCounterDataAccumulatorWrapper sds = stallSub.getSubscriptionStallAccumulator(!isSubscriber);
        if (sds != null) {
            if (!vetoedRepositories.contains(sds)) {
                sds.getAccumulator().IIntegerFluctuatingCounterDataAccumulator_increment(sds.getSnapshot());
                vetoedRepositories.add(sds);
                StallFeatureBase.addReportingInvocationData(invocationData, sds);
                invocationData.setStalled();
            }
        } else {
            WilyTransactionStructure.getInstance().getAgent().IAgent_getModuleFeedback().debug("startsub " + stallSub.toString() + " does not have a local stall repository");
        }
    }

    private static void updateStallRepository(Set vetoedRepositories, IStackElement invocationData, long nowInMillis, IStallSubscriber stallSub, boolean isSubscriber) {
        IRepository sds = stallSub.getLocalStallRepository();
        if (sds != null && !vetoedRepositories.contains(sds)) {
            int hashcode = invocationData.hashCode();
            sds.update(UpdaterFactory.getIncreasingUpdater(), 0L, nowInMillis, hashcode);
            vetoedRepositories.add(sds);
            StallFeatureBase.addReportingInvocationData(invocationData, sds);
            invocationData.setStalled();
        }
    }

    private static boolean shouldAbortTransaction(IStackElement data, long nowInMillis) {
        ITransactionCacheProviderFactory stack = InvocationData.getCacheHelper();
        if (stack.isUseExternalThreadId()) {
            long th = StallFeatureBase.sTxnAbortThreshold.get();
            return th > 0L && data.getWallClockStartTime() < nowInMillis - th;
        }
        return false;
    }

    private void abortTransaction(IStackElement data, long nowInMillis) {
        long timeTaken = nowInMillis - data.getWallClockStartTime();
        WilyTransactionStructure.getInstance().abortTransactionAsync(new TransactionTransitionException(String.format("Transaction took %d ms which is more than threshold %d ms set for aborting transaction", timeTaken, StallFeatureBase.sTxnAbortThreshold.get())), data);
    }
}

