/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.adt.primitive;

import com.wily.util.adt.primitive.CharObjMapEntry;
import com.wily.util.adt.primitive.PrimitiveCharObjMap;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Iterator;
import java.util.NoSuchElementException;

public final class CharObjHashMap<V>
implements PrimitiveCharObjMap<V>,
Serializable {
    private static final long serialVersionUID = -1613470588012276602L;
    private static final int DEFAULT_INITIAL_CAPACITY = 16;
    private static final int MAXIMUM_CAPACITY = 0x40000000;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private transient CharObjMapEntry<V>[] table;
    private transient int size;
    private int threshold;
    private final float loadFactor;

    public CharObjHashMap(int initialCapacity, float loadFactor) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal initial capacity: " + initialCapacity);
        }
        if (initialCapacity > 0x40000000) {
            initialCapacity = 0x40000000;
        }
        if (loadFactor <= 0.0f || Float.isNaN(loadFactor)) {
            throw new IllegalArgumentException("Illegal load factor: " + loadFactor);
        }
        int capacity = 1;
        while (capacity < initialCapacity) {
            capacity <<= 1;
        }
        this.loadFactor = loadFactor;
        this.threshold = (int)((float)capacity * loadFactor);
        this.table = new CharObjMapEntry[capacity];
    }

    public CharObjHashMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public CharObjHashMap() {
        this.loadFactor = 0.75f;
        this.threshold = 12;
        this.table = new CharObjMapEntry[16];
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("{");
        CharObjMapEntry<V>[] charObjMapEntryArray = this.table;
        int n = this.table.length;
        int n2 = 0;
        while (n2 < n) {
            CharObjMapEntry<V> vEntry;
            CharObjMapEntry<V> e = vEntry = charObjMapEntryArray[n2];
            while (e != null) {
                char key = e.key;
                V value = e.getValue();
                buf.append(key).append("=").append((Object)(value == this ? "(this Map)" : value));
                e = e.next;
            }
            ++n2;
        }
        buf.append("}");
        return buf.toString();
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public V get(char key) {
        int i = key & this.table.length - 1;
        CharObjMapEntry<V> e = this.table[i];
        while (e != null) {
            if (key == e.key) {
                return e.value;
            }
            e = e.next;
        }
        return null;
    }

    @Override
    public boolean containsKey(char key) {
        int i = key & this.table.length - 1;
        CharObjMapEntry<V> e = this.table[i];
        while (e != null) {
            if (key == e.key) {
                return true;
            }
            e = e.next;
        }
        return false;
    }

    @Override
    public V put(char key, V value) {
        int i = key & this.table.length - 1;
        CharObjMapEntry<V> e = this.table[i];
        while (e != null) {
            if (key == e.key) {
                Object oldValue = e.value;
                e.value = value;
                return oldValue;
            }
            e = e.next;
        }
        this.addEntry(key, value, i);
        return null;
    }

    private void putForCreate(char key, V value) {
        int i = key & this.table.length - 1;
        CharObjMapEntry<V> e = this.table[i];
        while (e != null) {
            if (key == e.key) {
                e.value = value;
                return;
            }
            e = e.next;
        }
        this.createEntry(key, value, i);
    }

    private void resize(int newCapacity) {
        CharObjMapEntry<V>[] oldTable = this.table;
        int oldCapacity = oldTable.length;
        if (oldCapacity == 0x40000000) {
            this.threshold = Integer.MAX_VALUE;
            return;
        }
        CharObjMapEntry[] newTable = new CharObjMapEntry[newCapacity];
        this.transfer(newTable);
        this.table = newTable;
        this.threshold = (int)((float)newCapacity * this.loadFactor);
    }

    private void transfer(CharObjMapEntry<V>[] newTable) {
        CharObjMapEntry<V>[] src = this.table;
        int newCapacity = newTable.length;
        int j = 0;
        while (j < src.length) {
            CharObjMapEntry<V> e = src[j];
            if (e != null) {
                CharObjMapEntry next;
                src[j] = null;
                do {
                    next = e.next;
                    int i = e.key & newCapacity - 1;
                    e.next = newTable[i];
                    newTable[i] = e;
                } while ((e = next) != null);
            }
            ++j;
        }
    }

    @Override
    public V remove(char key) {
        CharObjMapEntry<V> e = this.removeEntryForKey(key);
        return e == null ? null : (V)e.value;
    }

    private CharObjMapEntry<V> removeEntryForKey(char key) {
        CharObjMapEntry<V> prev;
        int i = key & this.table.length - 1;
        CharObjMapEntry<V> e = prev = this.table[i];
        while (e != null) {
            CharObjMapEntry next = e.next;
            if (key == e.key) {
                --this.size;
                if (prev == e) {
                    this.table[i] = next;
                } else {
                    prev.next = next;
                }
                return e;
            }
            prev = e;
            e = next;
        }
        return null;
    }

    @Override
    public void clear() {
        CharObjMapEntry<V>[] tab = this.table;
        int i = 0;
        while (i < tab.length) {
            tab[i] = null;
            ++i;
        }
        this.size = 0;
    }

    @Override
    public boolean containsValue(V value) {
        CharObjMapEntry<V>[] tab;
        CharObjMapEntry<V>[] charObjMapEntryArray = tab = this.table;
        int n = tab.length;
        int n2 = 0;
        while (n2 < n) {
            CharObjMapEntry<V> vEntry;
            CharObjMapEntry<V> e = vEntry = charObjMapEntryArray[n2];
            while (e != null) {
                if (value.equals(e.value)) {
                    return true;
                }
                e = e.next;
            }
            ++n2;
        }
        return false;
    }

    private void addEntry(char key, V value, int bucketIndex) {
        this.table[bucketIndex] = new CharObjMapEntry<V>(key, value, this.table[bucketIndex]);
        if (this.size++ >= this.threshold) {
            this.resize(2 * this.table.length);
        }
    }

    private void createEntry(char key, V value, int bucketIndex) {
        this.table[bucketIndex] = new CharObjMapEntry<V>(key, value, this.table[bucketIndex]);
        ++this.size;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeInt(this.table.length);
        s.writeInt(this.size);
        int c = 0;
        int i = 0;
        while (c < this.size && i < this.table.length) {
            CharObjMapEntry<V> e = this.table[i];
            while (e != null) {
                s.writeChar(e.key);
                s.writeObject(e.getValue());
                e = e.next;
                ++c;
            }
            ++i;
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int numBuckets = s.readInt();
        this.table = new CharObjMapEntry[numBuckets];
        int size = s.readInt();
        int i = 0;
        while (i < size) {
            char key = s.readChar();
            Object value = s.readObject();
            this.putForCreate(key, value);
            ++i;
        }
    }

    @Override
    public Iterator<CharObjMapEntry<V>> iterator() {
        return new CharObjHashMapEntryIterator();
    }

    private class CharObjHashMapEntryIterator
    implements Iterator<CharObjMapEntry<V>> {
        int index = -1;
        CharObjMapEntry<V> cur = null;
        CharObjMapEntry<V> next = null;

        @Override
        public boolean hasNext() {
            if (this.next == null) {
                while (++this.index < CharObjHashMap.this.table.length) {
                    this.next = CharObjHashMap.this.table[this.index];
                    if (this.next != null) break;
                }
            }
            return this.next != null;
        }

        @Override
        public CharObjMapEntry<V> next() {
            if (this.next == null) {
                if (this.hasNext()) {
                    return this.next();
                }
                throw new NoSuchElementException("No more entries");
            }
            this.cur = this.next;
            this.next = this.next.next;
            this.hasNext();
            return this.cur;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void remove() {
            block1: {
                if (this.index <= -1 || this.index >= CharObjHashMap.access$0(CharObjHashMap.this).length) break block1;
                curNode = CharObjHashMap.access$0(CharObjHashMap.this)[this.index];
                prev = null;
                if (this.cur == null) break block1;
                if (curNode != this.cur) ** GOTO lbl14
                CharObjHashMap.access$0((CharObjHashMap)CharObjHashMap.this)[this.index] = this.cur.next;
                return;
lbl-1000:
                // 1 sources

                {
                    prev = curNode;
                    curNode = curNode.next;
                    if (curNode != this.cur) continue;
                    prev.next = curNode.next;
                    this.cur = null;
                    break;
lbl14:
                    // 2 sources

                    ** while (curNode != null)
                }
            }
        }
    }
}

