/*
 * Decompiled with CFR 0.152.
 */
package com.wily.isengard.messageprimitives.service;

import com.wily.isengard.message.AMessage;
import com.wily.isengard.message.CheckedThrowableMessage;
import com.wily.isengard.message.MessageUndeliverableException;
import com.wily.isengard.message.UncheckedThrowableMessage;
import com.wily.isengard.messageprimitives.ConnectionException;
import com.wily.isengard.messageprimitives.InterfaceUtilities;
import com.wily.isengard.messageprimitives.MethodCallMessage;
import com.wily.isengard.messageprimitives.MethodResultMessage;
import com.wily.isengard.messageprimitives.TimeoutConnectionException;
import com.wily.isengard.messageprimitives.service.AAsyncMessageServiceClient;
import com.wily.isengard.messageprimitives.service.CompressedMessageServiceCallMessage;
import com.wily.isengard.messageprimitives.service.IIsengardCompressed;
import com.wily.isengard.messageprimitives.service.IMessageReplyTimeout;
import com.wily.isengard.messageprimitives.service.IllegalServiceAccessException;
import com.wily.isengard.messageprimitives.service.MessageServiceCallMessage;
import com.wily.isengard.postoffice.Address;
import com.wily.isengard.postoffice.MessageUndeliverableMessage;
import com.wily.isengard.postoffice.PostOffice;
import com.wily.isengard.util.io.CannotDeserializePlaceholderException;
import com.wily.util.clock.MasterClock;
import com.wily.util.feedback.Module;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.text.MessageFormat;

public class MessageServiceClient<T>
extends AAsyncMessageServiceClient
implements InvocationHandler {
    private static Module sModule = new Module("MessageServiceClient");
    public static final long kDefaultTimeoutValue = 600000L;
    private static final long sReplyTimeout;
    private AMessage fReplyMessage;
    private final Class<T> fInterface;
    private int fInterfaceVersion;
    private boolean fCompressed;
    private Object fInvocationLock = new Object();
    private final long fTimeout;
    private boolean fIsNotified = false;
    private final IMessageReplyTimeout fReplyTimeout;

    static {
        long replyTimeOut = 0L;
        try {
            String replyTimeOutStr = System.getProperty("wily.MessageReplyTimeOut");
            if (replyTimeOutStr != null) {
                replyTimeOut = Long.parseLong(replyTimeOutStr);
            }
        }
        catch (Exception exception) {}
        sReplyTimeout = replyTimeOut > 0L ? replyTimeOut : 600000L;
    }

    public MessageServiceClient(PostOffice po, Class<T> clazz, Address serviceAddress) throws IllegalServiceAccessException {
        this(po, clazz, serviceAddress, sReplyTimeout, null);
    }

    public MessageServiceClient(PostOffice po, Class<T> clazz, Address serviceAddress, IMessageReplyTimeout replyTimeout) throws IllegalServiceAccessException {
        this(po, clazz, serviceAddress, sReplyTimeout, replyTimeout);
    }

    public MessageServiceClient(PostOffice po, Class<T> clazz, Address serviceAddress, long timeout) throws IllegalServiceAccessException {
        this(po, clazz, serviceAddress, timeout, null);
    }

    private MessageServiceClient(PostOffice po, Class<T> clazz, Address serviceAddress, long timeout, IMessageReplyTimeout replyTimeout) throws IllegalServiceAccessException {
        super(po, serviceAddress);
        this.fTimeout = timeout;
        this.fReplyTimeout = replyTimeout;
        this.fInterface = clazz;
        this.fInterfaceVersion = InterfaceUtilities.getInterfaceVersion(clazz);
        this.fCompressed = IIsengardCompressed.class.isAssignableFrom(clazz);
    }

    @Override
    public void close() {
        String message = "closing MessageServiceClient for " + this.fInterface + " ; hashcode == " + this.hashCode();
        RuntimeException stackTraceToLog = new RuntimeException(message);
        this.receiveReply(new MessageUndeliverableMessage(message, stackTraceToLog));
        super.close();
    }

    public T proxyInterface() {
        Object invocationHandler = this.getServiceAddress().getInvocationHandler();
        Class<T> targetInterface = this.getInterface();
        if (invocationHandler != null) {
            return targetInterface.cast(invocationHandler);
        }
        T proxy = targetInterface.cast(Proxy.newProxyInstance(targetInterface.getClassLoader(), new Class[]{targetInterface}, (InvocationHandler)this));
        this.getPostOffice().registerCloseOnWeakReference(this, proxy);
        return proxy;
    }

    public final Class<T> getInterface() {
        return this.fInterface;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object sendRequest(AMessage message) throws Throwable {
        short expectedID;
        MessageServiceClient messageServiceClient = this;
        synchronized (messageServiceClient) {
            this.fReplyMessage = null;
            expectedID = this.sendRequestAsync(message);
        }
        if (!this.blockOnResponse(message)) {
            throw new TimeoutConnectionException(MessageFormat.format("Service call to host {0} timed out after {1} ms {2} threadname {3}", message.getRemoteHost(), Long.toString(this.fTimeout), message, Thread.currentThread().getName()));
        }
        if (this.fReplyMessage instanceof MessageUndeliverableMessage) {
            throw new MessageUndeliverableException(((MessageUndeliverableMessage)this.fReplyMessage).getReason(), ((MessageUndeliverableMessage)this.fReplyMessage).getException());
        }
        if (this.fReplyMessage instanceof CheckedThrowableMessage) {
            Throwable throwable = ((CheckedThrowableMessage)this.fReplyMessage).getThrowable();
            if (throwable instanceof CannotDeserializePlaceholderException) {
                throw new ConnectionException(throwable);
            }
            throw throwable;
        }
        if (this.fReplyMessage instanceof UncheckedThrowableMessage) {
            Throwable t = ((UncheckedThrowableMessage)this.fReplyMessage).getThrowable();
            String msg = MessageFormat.format("Exception: {0} calling method: {1}", t, message);
            this.getFeedbackChannel().error(sModule, msg, new ConnectionException(t).fillInStackTrace());
            throw new ConnectionException(t);
        }
        if (this.fReplyMessage.getSequenceNumber() != expectedID) {
            this.getFeedbackChannel().error(sModule, "System running slowly. Received out of sequence reply: " + this.fReplyMessage);
            return null;
        }
        Object result = ((MethodResultMessage)this.fReplyMessage).getResult();
        this.fReplyMessage = null;
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean blockOnResponse(AMessage message) throws MessageUndeliverableException, TimeoutConnectionException {
        MessageServiceClient messageServiceClient = this;
        synchronized (messageServiceClient) {
            block17: {
                if (this.fReplyMessage == null) break block17;
                this.fIsNotified = false;
                return true;
            }
            try {
                long startTime = MasterClock.currentTimeMillis();
                boolean clearMessage = false;
                while (true) {
                    long timeout;
                    PostOffice postOffice;
                    PostOffice postOffice2 = postOffice = this.getPostOffice();
                    synchronized (postOffice2) {
                        if (postOffice.isClosed()) {
                            this.close();
                            this.getFeedbackChannel().warn("Waiting on a closed postOffice. Closing the mailbox registered to a dead postoffice...");
                            throw new MessageUndeliverableException("Waiting on a closed postOffice. Closing the mailbox registered to a dead postoffice...");
                        }
                    }
                    long l = timeout = this.fReplyTimeout == null ? this.fTimeout : this.fReplyTimeout.getNextTimeout();
                    if (timeout >= 0L) {
                        this.wait(timeout);
                    }
                    if (this.fIsNotified || this.fReplyMessage != null) {
                        if (clearMessage) {
                            this.getFeedbackChannel().warn("Got the response for the message " + message + " to address " + this.getAddress() + " service address " + this.getServiceAddress() + " from thread " + Thread.currentThread().getName());
                        }
                        break;
                    }
                    if (timeout < 0L) {
                        this.getFeedbackChannel().warn("Not waiting for response for the message " + message + " from address " + message.getSourceAddress() + " to service address " + this.getServiceAddress() + " from thread " + Thread.currentThread().getName());
                        this.close();
                        throw new TimeoutConnectionException(MessageFormat.format("Service call to host {0} timed out after {1} ms {2} threadname {3}", message.getRemoteHost(), Long.toString(timeout), message, Thread.currentThread().getName()));
                    }
                    if (MasterClock.currentTimeMillis() > startTime + timeout) {
                        if (this.fReplyTimeout == null) {
                            this.getFeedbackChannel().warn("Waited " + timeout + " ms But did not receive the response for the message " + message + " from address " + message.getSourceAddress() + " to service address " + this.getServiceAddress() + " from thread " + Thread.currentThread().getName() + " -- We will not wait any longer");
                            this.close();
                            throw new TimeoutConnectionException(MessageFormat.format("Service call to host {0} timed out after {1} ms {2} threadname {3}", message.getRemoteHost(), Long.toString(timeout), message, Thread.currentThread().getName()));
                        }
                        startTime = MasterClock.currentTimeMillis();
                    }
                    if (clearMessage) continue;
                    clearMessage = true;
                    this.getFeedbackChannel().warn("Waited " + timeout + " ms But did not receive the response for the message " + message + " from address " + message.getSourceAddress() + " to service address " + this.getServiceAddress() + " from thread " + Thread.currentThread().getName() + " -- We will keep waiting and don't log further messages until we receive the reply or time out");
                }
                this.fIsNotified = false;
                return this.fReplyMessage != null;
            }
            catch (InterruptedException e) {
                this.close();
                throw new MessageUndeliverableException("Caller thread interrupted", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void receiveReply(AMessage reply) {
        MessageServiceClient messageServiceClient = this;
        synchronized (messageServiceClient) {
            this.fReplyMessage = reply;
            this.fIsNotified = true;
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object object = this.fInvocationLock;
        synchronized (object) {
            MethodCallMessage message = this.fCompressed ? new CompressedMessageServiceCallMessage(method, this.fInterfaceVersion, args) : new MessageServiceCallMessage(method, this.fInterfaceVersion, args);
            Object result = this.sendRequest(message);
            return result;
        }
    }
}

