/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.webservices.formatter.producer;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.powerpack.webservices.WSMUtils;
import com.wily.powerpack.webservices.formatter.producer.AFormatter;

public class WLS8Formatter
extends AFormatter {
    public WLS8Formatter(IAgent agent) {
        super(agent);
    }

    @Override
    public String getServiceName(InvocationData data) {
        String name = null;
        try {
            Object context = this.getMessageContext(data);
            Object operation = WSMUtils.invokeMethodOnObject(context, "getOperation");
            Object port = WSMUtils.invokeMethodOnObject(operation, "getPort");
            Object service = WSMUtils.invokeMethodOnObject(port, "getService");
            name = (String)WSMUtils.invokeMethodOnObject(service, "getName");
            name = WSMUtils.formatURLToBeResourceSafe(name);
        }
        catch (Throwable t) {
            WSMUtils.handleError(this.getAgent(), "WebServices_Error_Determining_Service_Name", t);
        }
        return name == null ? "UnknownService" : name;
    }

    @Override
    public String getOperation(InvocationData data) {
        int index;
        Object nameObj = data.getInvocationParameterAsObject(0);
        String operation = null;
        if (nameObj != null) {
            operation = (String)nameObj;
        } else {
            try {
                Object context = this.getMessageContext(data);
                Object operationObj = WSMUtils.invokeMethodOnObject(context, "getOperation");
                operation = (String)WSMUtils.invokeMethodOnObject(operationObj, "getName");
            }
            catch (Throwable t) {
                WSMUtils.handleError(this.getAgent(), "WebServices_Error_Determining_Operation_Name", t);
            }
        }
        if (operation != null && (index = operation.lastIndexOf("Response")) > 0) {
            operation = operation.substring(0, index);
        }
        return operation == null ? "UnknownOperationName" : operation;
    }

    @Override
    protected Object getMessageContext(InvocationData data) {
        Object context = data.getInvocationParameterAsObject(2);
        return context;
    }
}

