/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.webservices.extension.agent.trace.correlation;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.transactiontrace.CorrelationId;
import com.wily.powerpack.webservices.WSMUtils;
import com.wily.powerpack.webservices.extension.agent.trace.correlation.WSCorrelationTracer;
import com.wily.util.properties.AttributeListing;
import java.util.Iterator;

public class WL81UpstreamClientSOAPCorrelationTracer
extends WSCorrelationTracer {
    private static final String kReservedWSDMTransactionContext = "Reserved WSDM Transaction Context";

    public WL81UpstreamClientSOAPCorrelationTracer(IAgent agent, AttributeListing attributeListing, ProbeIdentification probeIdentification, Object sample) {
        super(agent, attributeListing, probeIdentification, sample);
    }

    @Override
    public void ITracer_startTrace(int index, InvocationData data) {
        WSMUtils.refreshLogLevels();
        WSMUtils.getLogger().debug(" WL81UpstreamClientSOAPCorrelationTracer ITracer_startTrace");
    }

    @Override
    public void ITracer_finishTrace(int index, InvocationData data) {
        Object servletRequestImpl = null;
        try {
            WSMUtils.refreshLogLevels();
            if (WSMUtils.getLogger().isDebugEnabled()) {
                WSMUtils.getLogger().debug("WL81UpstreamClientSOAPCorrelationTracer ITracer_startTrace data.getInvocationObject() " + data.getInvocationObject().getClass());
            }
            if (!WSMUtils.correlationSOAPInsertionEnabled()) {
                return;
            }
            Object wlmessagecontext = data.getInvocationParameterAsObject(0);
            Object message = WSMUtils.invokeMethodOnObject(wlmessagecontext, "getMessage");
            Object soapPart = WSMUtils.invokeMethodOnObject(message, "getSOAPPart");
            Object envelope = WSMUtils.invokeMethodOnObject(soapPart, "getEnvelope");
            Object attrName = WSMUtils.invokeMethodOnObject(envelope, "createName", new Class[]{String.class}, new Object[]{"CorID"});
            Class<?>[] interfaces = attrName.getClass().getInterfaces();
            Class<?> attributeClass = null;
            for (int i = 0; i < interfaces.length; ++i) {
                if (WSMUtils.getLogger().isDebugEnabled()) {
                    WSMUtils.getLogger().debug("WL81UpstreamServerSOAPCorrelationTracer interfaces=" + interfaces[i].getName());
                }
                if (!interfaces[i].getName().equals("javax.xml.soap.Name")) continue;
                attributeClass = interfaces[i];
                break;
            }
            Object soapHeader = WSMUtils.invokeMethodOnObject(envelope, "getHeader");
            boolean correlationIdFound = false;
            if (soapHeader != null) {
                Iterator elements = (Iterator)WSMUtils.invokeMethodOnObject(soapHeader, "getChildElements");
                Object headerElement = null;
                while (elements.hasNext()) {
                    headerElement = elements.next();
                    Object elementName = WSMUtils.invokeMethodOnObject(headerElement, "getElementName");
                    String localName = (String)WSMUtils.invokeMethodOnObject(elementName, "getLocalName");
                    if (!localName.equals("WSCorIDSOAPHeader")) continue;
                    String value = (String)WSMUtils.invokeMethodOnObject(headerElement, "getAttributeValue", new Class[]{attributeClass}, new Object[]{attrName});
                    CorrelationId correlationIdTmp = new CorrelationId(value);
                    correlationIdFound = true;
                    break;
                }
            }
            if (!correlationIdFound) {
                CorrelationId correlationId = new CorrelationId();
            }
        }
        catch (Throwable t) {
            WSMUtils.getLogger().error("WL81UpstreamClientSOAPCorrelationTracer ITracer_startTrace exception " + WSMUtils.dumpStackTrace(t));
        }
    }
}

