/*
 * Decompiled with CFR 0.152.
 */
package SevenZip;

import SevenZip.Compression.LZMA.Decoder;
import SevenZip.Compression.LZMA.Encoder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class SevenZipHelper {
    static final int LZMA_MAGIC_1 = 140;
    static final int LZMA_MAGIC_2 = 30;
    static int dictionary = 4096;
    static boolean eos = false;

    static void SetCoderProperties(Encoder encoder) {
        encoder.SetDictionarySize(dictionary);
        encoder.SetLcLpPb(3, 0, 2);
        encoder.SetAlgorithm(2);
        encoder.SetNumFastBytes(128);
        encoder.SetEndMarkerMode(eos);
    }

    public static byte[] Compress(byte[] inputBytes) throws IOException {
        ByteArrayInputStream inStream = new ByteArrayInputStream(inputBytes);
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        Encoder encoder = new Encoder();
        SevenZipHelper.SetCoderProperties(encoder);
        outStream.write(140);
        outStream.write(30);
        encoder.WriteCoderProperties(outStream);
        int fileSize = inputBytes.length;
        outStream.write(fileSize / 256 & 0xFF);
        outStream.write(fileSize & 0xFF);
        encoder.Code(inStream, outStream, -1L, -1L, null);
        return outStream.toByteArray();
    }

    public static byte[] Decompress(byte[] inputBytes) throws IOException {
        ByteArrayInputStream newInStream = new ByteArrayInputStream(inputBytes);
        Decoder decoder = new Decoder();
        newInStream.reset();
        ByteArrayOutputStream newOutStream = new ByteArrayOutputStream();
        int magic1 = newInStream.read();
        int magic2 = newInStream.read();
        if (magic1 != 140 || magic2 != 30) {
            throw new IOException("input .lzma has wrong magic number");
        }
        byte[] properties2 = new byte[5];
        if (newInStream.read(properties2, 0, 5) != 5) {
            throw new IOException("input .lzma is too short");
        }
        int outSize = 0;
        outSize = newInStream.read() * 256;
        decoder.SetDecoderProperties(properties2);
        decoder.Code(newInStream, newOutStream, outSize += newInStream.read());
        byte[] b = newOutStream.toByteArray();
        return b;
    }

    public static boolean CheckIfLzma(byte[] inputBytes) {
        int magic1 = inputBytes[0] & 0xFF;
        int magic2 = inputBytes[1] & 0xFF;
        return magic1 == 140 && magic2 == 30;
    }
}

