/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.adt;

import com.wily.util.IComparer;
import com.wily.util.adt.PriorityQueue;
import java.util.concurrent.Semaphore;

public class BlockingPriorityQueue
extends PriorityQueue {
    private Semaphore fBlockingSemaphore = new Semaphore(0);

    public BlockingPriorityQueue(IComparer comparer) {
        super(comparer);
    }

    public BlockingPriorityQueue(IComparer comparer, int initialSize) {
        super(comparer, initialSize);
    }

    private Object getLock() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insert(Object obj) {
        Object object = this.getLock();
        synchronized (object) {
            super.insert(obj);
        }
        this.fBlockingSemaphore.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object obj) {
        Object object = this.getLock();
        synchronized (object) {
            return super.remove(obj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object dequeue() {
        Object theObject = null;
        while (theObject == null) {
            try {
                this.fBlockingSemaphore.acquire();
            }
            catch (InterruptedException interruptedException) {
                this.fBlockingSemaphore.release();
            }
            Object object = this.getLock();
            synchronized (object) {
                theObject = super.dequeue();
            }
        }
        return theObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object interruptableDequeue() throws InterruptedException {
        Object theObject = null;
        while (theObject == null) {
            this.fBlockingSemaphore.acquire();
            Object object = this.getLock();
            synchronized (object) {
                theObject = super.dequeue();
            }
        }
        return theObject;
    }
}

