/*
 * Decompiled with CFR 0.152.
 */
package com.wily.jip.tcp;

import com.wily.jip.IJIPTransportProperties;

public class JIPTCPTransportProperties
implements IJIPTransportProperties {
    public static final String kTransportType_TCP = "TCP";
    private String fServerAddress;
    private int fPort;
    private int fLocalPort;
    private String fLocalIP;
    private int fReadBufferCount;
    private int fWriteBufferCount;
    private int fSocketReadTimeoutInMillis;

    public JIPTCPTransportProperties(String serverAddress, int port, String localIP, int localPort, int readBufferCount, int writeBufferCount, int socketReadTimeoutInMillis) {
        this.fServerAddress = serverAddress;
        this.fPort = port;
        this.fLocalPort = localPort;
        this.fLocalIP = localIP;
        this.fReadBufferCount = readBufferCount;
        this.fWriteBufferCount = writeBufferCount;
        this.fSocketReadTimeoutInMillis = socketReadTimeoutInMillis;
    }

    public String getServerAddress() {
        return this.fServerAddress;
    }

    public int getPort() {
        return this.fPort;
    }

    public int getLocalPort() {
        return this.fLocalPort;
    }

    public String getLocalIP() {
        return this.fLocalIP;
    }

    public int getReadBufferCount() {
        return this.fReadBufferCount;
    }

    public int getWriteBufferCount() {
        return this.fWriteBufferCount;
    }

    public int getSocketReadTimeoutInMillis() {
        return this.fSocketReadTimeoutInMillis;
    }

    @Override
    public String IJIPTransportProperties_getType() {
        return kTransportType_TCP;
    }

    public String toString() {
        return this.getServerAddress() + ":" + this.getPort() + " with local port: " + this.getLocalPort() + " with local ip: " + this.getLocalIP() + " with read buffer: " + this.getReadBufferCount() + " write buffer: " + this.getWriteBufferCount();
    }

    public boolean equals(IJIPTransportProperties properties) {
        if (!kTransportType_TCP.equals(properties.IJIPTransportProperties_getType())) {
            return false;
        }
        JIPTCPTransportProperties targetProperties = (JIPTCPTransportProperties)properties;
        return this.getServerAddress().equals(targetProperties.getServerAddress()) && this.getPort() == targetProperties.getPort() && this.getLocalPort() == targetProperties.getLocalPort() && this.getLocalIP().equals(targetProperties.getLocalIP()) && this.getWriteBufferCount() == targetProperties.getWriteBufferCount() && this.getReadBufferCount() == targetProperties.getReadBufferCount();
    }
}

