/*
 * Decompiled with CFR 0.152.
 */
package com.wily.diagnos.cmp.classmatcher;

import com.wily.diagnos.cmp.classmatcher.ACachingImmutableClassMatcher;
import com.wily.diagnos.cmp.directives.utility.CompilerSettingsUtility;
import com.wily.diagnos.cmp.log.CompilerLogDetails;
import com.wily.diagnos.cmp.log.CompilerLogDetailsSession;
import com.wily.util.HashCodeUtils;
import com.wily.util.classfile.ClassFileUtilities;
import com.wily.util.classfile.IClassName;
import com.wily.util.classfile.IModeledClass;
import java.util.HashMap;
import java.util.Map;

public class DGExactClassMatcher
extends ACachingImmutableClassMatcher {
    private static final Map<String, DGExactClassMatcher> singleton = new HashMap<String, DGExactClassMatcher>();
    protected final IClassName fClassName;

    private DGExactClassMatcher(IClassName className) {
        String name = className.getReflectionFriendlyQualifiedNameString();
        if (singleton.containsKey(name)) {
            throw new RuntimeException("Instance already created");
        }
        this.fClassName = className;
    }

    public static DGExactClassMatcher getInstance(IClassName className) {
        String name = className.getReflectionFriendlyQualifiedNameString();
        if (!singleton.containsKey(name)) {
            singleton.put(name, new DGExactClassMatcher(className));
        }
        return singleton.get(name);
    }

    @Override
    public boolean IClassMatcher_matches(IModeledClass cls) {
        return this.IClassMatcher_matches(cls.getClassName());
    }

    @Override
    public boolean IClassMatcher_supportsNameMatching() {
        return true;
    }

    @Override
    public boolean IClassMatcher_matches(IClassName className) {
        boolean result = ClassFileUtilities.looselyMatches((IClassName)this.fClassName, (IClassName)className);
        if (result) {
            CompilerLogDetails current = CompilerLogDetailsSession.getCurrent();
            current.setSkipCause(1024);
            current.setExactClassMatcherPattern(this.fClassName);
        }
        return result;
    }

    public int hashCode() {
        int result = 17;
        result = HashCodeUtils.accumulateHashCode((int)result, (Object)this.fClassName);
        return result;
    }

    public boolean equals(Object obj) {
        if (obj instanceof DGExactClassMatcher) {
            DGExactClassMatcher m = (DGExactClassMatcher)obj;
            return this.fClassName.equals(m.fClassName);
        }
        return false;
    }

    @Override
    public String[] getMatcherKeys() {
        return new String[]{CompilerSettingsUtility.getKeyFromString(this.fClassName.getPackageAndNameString())};
    }
}

