/*
 * Decompiled with CFR 0.152.
 */
package com.wily.diagnos.personality.java.classfile.attributes.stackmapframe;

import com.wily.diagnos.personality.java.classfile.attributes.stackmapframe.DGSameLocalsOneStackItemFrameExtended;
import com.wily.diagnos.personality.java.classfile.attributes.stackmapframe.DGStackMapFrame;
import com.wily.diagnos.personality.java.classfile.attributes.stackmapframe.DGVerificationTypeInfo;
import com.wily.diagnos.personality.java.classfile.attributes.stackmapframe.DGVerificationTypeInfoArray;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class DGSameLocalsOneStackItemFrame
extends DGStackMapFrame {
    private static final int kMaxSameLocalsDelta = 63;
    public static final int kFrameTagBase = 64;
    public static final int kFrameTagMax = 127;
    private static final int kFrameSize = 1;
    private DGVerificationTypeInfoArray fStack;

    public DGSameLocalsOneStackItemFrame(DataInputStream data, int frameType, int prevOffset) throws IOException {
        super(prevOffset);
        this.setOffsetDelta(frameType - 64);
        this.fStack = new DGVerificationTypeInfoArray(1, data);
    }

    public DGSameLocalsOneStackItemFrame(int prevOffset, int delta, DGVerificationTypeInfo stackItem) {
        super(prevOffset);
        this.setOffsetDelta(delta);
        this.fStack = new DGVerificationTypeInfoArray(stackItem);
    }

    public DGVerificationTypeInfoArray getStack() {
        return this.fStack;
    }

    @Override
    public String toString() {
        return "SameLocalsOneStackItem(offset=" + this.getOffset() + ", delta=" + this.getOffsetDelta() + ", stack=" + this.getStack() + ")";
    }

    @Override
    public void write(DataOutputStream out) throws IOException {
        out.writeByte(64 + this.getOffsetDelta());
        this.fStack.write(out);
    }

    @Override
    public int size() {
        return 1 + this.fStack.size();
    }

    @Override
    public DGStackMapFrame addToOffsetDelta(int offsetToAdd) {
        int currentDelta = this.getOffsetDelta();
        if ((currentDelta += offsetToAdd) <= 63) {
            return super.addToOffsetDelta(offsetToAdd);
        }
        return new DGSameLocalsOneStackItemFrameExtended(this, currentDelta);
    }

    @Override
    protected DGVerificationTypeInfoArray adjustLocals(DGVerificationTypeInfoArray locals) {
        return locals;
    }

    @Override
    protected DGVerificationTypeInfoArray adjustStack(DGVerificationTypeInfoArray stack) {
        return this.fStack;
    }

    @Override
    protected boolean updateUninitializedTypeOffset(int pc, int delta) {
        return this.fStack.updateUninitializedVariableOffset(pc, delta);
    }
}

