/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.probebuilder.intelligent.instrumentation;

import com.wily.diagnos.cmp.directives.apply.ClassSettingsApplier;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.sustainability.SustainabilityService;
import com.wily.introscope.agent.trace.intelligent.HighPerformanceIntelligenceStackElement;
import com.wily.introscope.agent.trace.intelligent.SustainabilityMetricsHelper;
import com.wily.introscope.agent.trace.intelligent.frontend.FrontEndCandidateAnalyzer;
import com.wily.introscope.probebuilder.intelligent.analysis.VisibilityGapProcessor;
import com.wily.introscope.probebuilder.intelligent.instrumentation.BooleanProperty;
import com.wily.introscope.probebuilder.intelligent.instrumentation.IntegerProperty;
import com.wily.introscope.probebuilder.intelligent.instrumentation.IntelligentInstrumentationProperties;
import com.wily.introscope.probebuilder.intelligent.instrumentation.LevelChangeExecutor;
import com.wily.introscope.probebuilder.intelligent.instrumentation.MaxIntelligentInstrumentationsProperty;
import com.wily.introscope.probebuilder.intelligent.instrumentation.MethodScoringConfigManager;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.feedback.SimpleModuleFeedbackChannel;
import com.wily.util.heartbeat.IRegisteredBehavior;
import com.wily.util.heartbeat.ITimestampedRunnable;
import com.wily.util.properties.hot.BooleanConfigurationProperty;
import com.wily.util.properties.hot.ConfigurationManager;
import com.wily.util.properties.hot.ConfigurationProperty;
import com.wily.util.properties.hot.EnumConfigurationProperty;
import com.wily.util.properties.hot.IntegerConfigurationProperty;
import com.wily.util.properties.hot.StringSetConfigurationProperty;
import com.wily.util.text.IStringLocalizer;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

public enum IntelligentInstrumentationConfig {
    INSTANCE;

    private IAgent fAgent;
    private IModuleFeedbackChannel fModuleFeedbackChannel = new SimpleModuleFeedbackChannel("Intelligent Instrumentation");
    private Module fModule = new Module("IntelligentInstrumentation");
    private ConfigurationManager configManager;
    private IntegerProperty fMaxMethodSize;
    private IntegerProperty fInstrumentationThreshold;
    private BooleanProperty fFullParse;
    private StringSetConfigurationProperty fUninterestingPrefixes;
    private EnumConfigurationProperty fInstrumentationLevel;
    private IntegerProperty fMaxIntelligentInstrumentations;
    private IntegerProperty fReloadedClassesBatchSize;
    private IntegerProperty fReloadedClassesBatchInterval;
    private IntegerProperty fPersistenceClampSize;
    private IntegerProperty fPersistenceTraceDirectivesClampSize;
    private IntegerProperty fPersistenceBlacklistClampSize;
    private IntegerProperty fPersistencyServiceFrequencyInterval;
    private IntegerProperty fMaxTracedDeepComponents;
    private IntegerProperty fMaxTracedConsecutiveDeepComponents;
    private BooleanProperty fDeepTraceSustainabilityMetricsProperty;
    private BooleanProperty fEntryPointSustainabilityMetricsProperty;
    private BooleanProperty fRuntimeVisibilitySustainabilityMetricsProperty;
    private IntegerProperty fBoundaryDetectionThreadPoolSize;
    private BooleanProperty fInstrumentationLevelHotEnable;
    public static Boolean ignoreFlag;
    public static Boolean Flag;
    private volatile boolean fIsValidDecisionThresholdSetInProfile = false;
    private volatile int fDecisionThresholdValue = -1;
    private static int previousInstrumentationLevelInt;
    private static int currentInstrumentationLevelInt;
    private static boolean startLevelChangeExecutor;
    private boolean bVisibilityProcessorEnabled;
    private int fVisibilityProcessInterval;
    private IRegisteredBehavior fVisibilityProcessorBehaviour;
    private boolean configInitialized;

    public void init(IAgent agent) {
        if (agent != null) {
            this.fAgent = agent;
            this.fModuleFeedbackChannel = this.fAgent.IAgent_getModuleFeedback();
            this.configManager = this.fAgent.IAgent_getConfigurationManager();
            this.initProperties();
            ignoreFlag = false;
            this.configInitialized = true;
        }
    }

    private void initProperties() {
        IStringLocalizer localizer = this.fAgent.IAgent_getStringLocalizer();
        this.fMaxMethodSize = new IntegerProperty("introscope.agent.deep.instrumentation.maxmethodsize", 2000, this.fModuleFeedbackChannel, this.fModule, localizer);
        this.configManager.add((ConfigurationProperty)this.fMaxMethodSize, true);
        this.fInstrumentationThreshold = new DecisionThresholdConfigurationProperty(this.fAgent);
        this.configManager.add((ConfigurationProperty)this.fInstrumentationThreshold, true);
        this.fFullParse = new BooleanProperty("introscope.agent.deep.methodscoring.fullparse", IntelligentInstrumentationProperties.kFullParseEnabledDefault, this.fModuleFeedbackChannel, this.fModule, localizer);
        this.configManager.add((ConfigurationProperty)this.fFullParse, true);
        this.initUninterestingPrefixes(localizer);
        this.updateMethodScoringValues();
        this.initInstrumentationThresholdForLevel();
        this.updateInstrumentationThresholdForLevel();
        this.setAutoProbeLogging(localizer);
        this.fMaxIntelligentInstrumentations = new MaxIntelligentInstrumentationsProperty("introscope.agent.deep.instrumentation.max.methods", 10000, this.fModuleFeedbackChannel, this.fModule, localizer);
        this.configManager.add((ConfigurationProperty)this.fMaxIntelligentInstrumentations, true);
        this.fMaxTracedDeepComponents = new MaxTracedDeepComponentsProperty("introscope.agent.deep.trace.max.components", 1000, this.fModuleFeedbackChannel, this.fModule, localizer);
        this.configManager.add((ConfigurationProperty)this.fMaxTracedDeepComponents, true);
        this.fMaxTracedConsecutiveDeepComponents = new MaxTracedConsecutiveDeepComponentsProperty("introscope.agent.deep.trace.max.consecutive.components", 15, this.fModuleFeedbackChannel, this.fModule, localizer);
        this.configManager.add((ConfigurationProperty)this.fMaxTracedConsecutiveDeepComponents, true);
        this.fDeepTraceSustainabilityMetricsProperty = new DeepTraceSustainabilityMetricsProperty("com.wily.introscope.agent.sustainabilitymetrics.deep.trace.enabled", true, this.fModuleFeedbackChannel, this.fModule, localizer);
        this.configManager.add((ConfigurationProperty)this.fDeepTraceSustainabilityMetricsProperty, true);
        this.fEntryPointSustainabilityMetricsProperty = new EntryPointSustainabilityMetricsProperty("com.wily.introscope.agent.sustainabilitymetrics.automatic.entry.point.enabled", true, this.fModuleFeedbackChannel, this.fModule, localizer);
        this.configManager.add((ConfigurationProperty)this.fEntryPointSustainabilityMetricsProperty, true);
        this.fRuntimeVisibilitySustainabilityMetricsProperty = new RuntimeVisibilitySustainabilityMetricsProperty("com.wily.introscope.agent.sustainabilitymetrics.runtime.visibility.enabled", true, this.fModuleFeedbackChannel, this.fModule, localizer);
        this.configManager.add((ConfigurationProperty)this.fRuntimeVisibilitySustainabilityMetricsProperty, true);
        this.fBoundaryDetectionThreadPoolSize = new BoundaryDetectionThreadPoolSize("introscope.agent.boundary.detection.threadpool.size", IntelligentInstrumentationProperties.kBoundaryDetectionThreadPoolSizeDefaultValue, this.fModuleFeedbackChannel, this.fModule, localizer);
        this.configManager.add((ConfigurationProperty)this.fBoundaryDetectionThreadPoolSize, true);
        this.fReloadedClassesBatchSize = new ReloadedClassesBatchSize("introscope.agent.deep.instrumentation.level.batch.size", IntelligentInstrumentationProperties.kReloadedClassesBatchSizeDefault, this.fModuleFeedbackChannel, this.fModule, localizer);
        this.configManager.add((ConfigurationProperty)this.fReloadedClassesBatchSize, true);
        this.fReloadedClassesBatchInterval = new ReloadedClassesBatchInterval("introscope.agent.deep.instrumentation.level.batch.interval", IntelligentInstrumentationProperties.kReloadedClassesBatchIntervalDefault, this.fModuleFeedbackChannel, this.fModule, localizer);
        this.configManager.add((ConfigurationProperty)this.fReloadedClassesBatchInterval, true);
        this.fPersistenceClampSize = new PersistenceClampSize("introscope.agent.autopersist.queue.size", IntelligentInstrumentationProperties.kPersistenceQueueSizeDefaultValue, this.fModuleFeedbackChannel, this.fModule, localizer);
        this.configManager.add((ConfigurationProperty)this.fPersistenceClampSize, true);
        this.fPersistenceTraceDirectivesClampSize = new PersistenceTraceDirectivesClampSize("introscope.agent.autopersist.instrumentation.count.max", IntelligentInstrumentationProperties.kPersistenceTraceDirectivesClampDefaultValue, this.fModuleFeedbackChannel, this.fModule, localizer);
        this.configManager.add((ConfigurationProperty)this.fPersistenceTraceDirectivesClampSize, true);
        this.fPersistenceBlacklistClampSize = new PersistenceBlacklistClampSize("introscope.agent.autopersist.blacklist.count.max", IntelligentInstrumentationProperties.kPersistenceBlacklistClampDefaultValue, this.fModuleFeedbackChannel, this.fModule, localizer);
        this.configManager.add((ConfigurationProperty)this.fPersistenceBlacklistClampSize, true);
        this.fPersistencyServiceFrequencyInterval = new PersistenceServiceInterval("introscope.agent.autopersist.frequency.interval", IntelligentInstrumentationProperties.kPersistenceServiceFrequencyIntervalDefaultValue, this.fModuleFeedbackChannel, this.fModule, localizer);
        this.configManager.add((ConfigurationProperty)this.fPersistencyServiceFrequencyInterval, true);
        this.fInstrumentationLevelHotEnable = new BooleanProperty("introscope.agent.deep.instrumentation.level.hot.enabled", IntelligentInstrumentationProperties.kInstrumentationLevelHotEnableDefault, this.fModuleFeedbackChannel, this.fModule, localizer);
        this.configManager.add((ConfigurationProperty)this.fInstrumentationLevelHotEnable, true);
        this.configManager.add((ConfigurationProperty)new VisibilityProcessorEnableProperty(this.fAgent), true);
        this.configManager.add((ConfigurationProperty)new VisibilityProcessorIntervalProperty(this.fAgent), true);
        this.configManager.add((ConfigurationProperty)new FrontendCandidateStackDurationThresholdProperty(this.fAgent), true);
        this.configManager.add((ConfigurationProperty)new FrontendCandidateInactivityThresholdProperty(this.fAgent), true);
        this.configManager.add((ConfigurationProperty)new FrontendPseudoCandidateInstrumentationThresholdProperty(this.fAgent), true);
        this.configManager.add((ConfigurationProperty)new FrontendCandidateTxCountProperty(this.fAgent), true);
        this.configManager.add((ConfigurationProperty)new InitialCandidateProcessorProperty(this.fAgent), true);
        this.configManager.add((ConfigurationProperty)new MonitoreCandidateProcessorProperty(this.fAgent), true);
    }

    public void initLevelChangeExecutor() {
        LevelChangeExecutor.startExecutor(this.fAgent);
    }

    private void setAutoProbeLogging(IStringLocalizer localizer) {
        BooleanProperty autoProbeLogEnable = new BooleanProperty("introscope.agent.deep.instrumentation.autoprobelog.enabled", false, this.fModuleFeedbackChannel, this.fModule, localizer);
        this.configManager.add((ConfigurationProperty)autoProbeLogEnable, true);
        if (autoProbeLogEnable.getBooleanValue()) {
            ClassSettingsApplier.setLogIntelligentInstrumentation();
        }
    }

    private void initUninterestingPrefixes(IStringLocalizer localizer) {
        Set<String> defaultPrefixes = Collections.singleton("java");
        this.fUninterestingPrefixes = new StringSetConfigurationProperty("introscope.agent.deep.instrumentation.custom.prefixes", defaultPrefixes, null, null, true, false, this.fModuleFeedbackChannel, this.fModule, localizer);
        this.configManager.add((ConfigurationProperty)this.fUninterestingPrefixes, true);
    }

    private void updateInstrumentationThresholdForLevel() {
        if (!this.fIsValidDecisionThresholdSetInProfile) {
            this.updateInstrumentationThresholdFromValue((Integer)this.fInstrumentationLevel.getValue());
            startLevelChangeExecutor = true;
        } else {
            startLevelChangeExecutor = false;
        }
    }

    private void updateInstrumentationThresholdFromValue(int val) {
        int instrumentationLevelInt = IntelligentInstrumentationProperties.kInstrumentationLevelIntMap[val];
        int methodCallScore = MethodScoringConfigManager.getScore(10);
        int computedValue = instrumentationLevelInt * methodCallScore;
        this.fDecisionThresholdValue = computedValue <= 0 ? 1 : computedValue;
    }

    private void initInstrumentationThresholdForLevel() {
        if (!this.fIsValidDecisionThresholdSetInProfile) {
            IStringLocalizer localizer = this.fAgent.IAgent_getStringLocalizer();
            this.fInstrumentationLevel = new IntelligentInstrumentationLevelConfigurationProperty(this.fAgent);
            this.configManager.add((ConfigurationProperty)this.fInstrumentationLevel, true);
            IntegerProperty levelLow = new IntegerProperty("introscope.agent.deep.instrumentation.level.methods.low", 150, this.fModuleFeedbackChannel, this.fModule, localizer);
            IntegerProperty levelMedium = new IntegerProperty("introscope.agent.deep.instrumentation.level.methods.medium", 110, this.fModuleFeedbackChannel, this.fModule, localizer);
            IntegerProperty levelHigh = new IntegerProperty("introscope.agent.deep.instrumentation.level.methods.high", 80, this.fModuleFeedbackChannel, this.fModule, localizer);
            this.configManager.add((ConfigurationProperty)levelLow, true);
            this.configManager.add((ConfigurationProperty)levelMedium, true);
            this.configManager.add((ConfigurationProperty)levelHigh, true);
            IntelligentInstrumentationProperties.kInstrumentationLevelIntMap[0] = levelLow.getIntegerValue();
            IntelligentInstrumentationProperties.kInstrumentationLevelIntMap[1] = levelMedium.getIntegerValue();
            IntelligentInstrumentationProperties.kInstrumentationLevelIntMap[2] = levelHigh.getIntegerValue();
        }
    }

    public static int getCurrentInstrumentationLevel() {
        return currentInstrumentationLevelInt;
    }

    public static int getPreviousInstrumentationLevel() {
        return previousInstrumentationLevelInt;
    }

    private void updateMethodScoringValues() {
        for (Map.Entry<Integer, String> tokenToPropKeyMapping : MethodScoringConfigManager.getTokenToPropertyKeyMappings()) {
            String propertyKey = tokenToPropKeyMapping.getValue();
            String newValue = this.configManager.getProperty(propertyKey);
            if (newValue != null && newValue.length() != 0) {
                try {
                    int value = Integer.valueOf(newValue);
                    if (!MethodScoringConfigManager.setTokenValue(tokenToPropKeyMapping.getKey(), value)) {
                        this.fModuleFeedbackChannel.warn("Out of range value for property " + propertyKey + ", probebuilder will use default.");
                        continue;
                    }
                    this.fModuleFeedbackChannel.info("Scoring property " + propertyKey + " changed to " + value);
                }
                catch (NumberFormatException e) {
                    this.fModuleFeedbackChannel.warn("Invalid value for property " + propertyKey + ", probebuilder will use default.", (Throwable)e);
                }
                continue;
            }
            this.fModuleFeedbackChannel.info("Scoring property " + propertyKey + " set to default value " + MethodScoringConfigManager.getFactor(tokenToPropKeyMapping.getKey()));
        }
    }

    public int getMaxMethodSize() {
        return this.fMaxMethodSize.getIntegerValue();
    }

    public boolean isFullParseEnabled() {
        return this.fFullParse.getBooleanValue();
    }

    public IModuleFeedbackChannel getModuleFeedbackChannel() {
        return this.fModuleFeedbackChannel;
    }

    public int getInstrumentationDecisionThreshold() {
        return this.fDecisionThresholdValue;
    }

    public StringSetConfigurationProperty getUninterestingPrefixes() {
        return this.fUninterestingPrefixes;
    }

    public int getMaxIntelligentInstrumentations() {
        return this.fMaxIntelligentInstrumentations.getIntegerValue();
    }

    public Module getIntelligentInstrumentationModule() {
        return this.fModule;
    }

    public ConfigurationManager getConfigManager() {
        return this.configManager;
    }

    public boolean isDeepTraceSustainabilityMetricsEnabled() {
        boolean enabled = SustainabilityService.areSustainabilityMetricsEnabled();
        return enabled && this.fDeepTraceSustainabilityMetricsProperty.getBooleanValue();
    }

    public boolean isInstrumentationLevelHotEnabled() {
        return this.fInstrumentationLevelHotEnable.getBooleanValue();
    }

    public Integer getReloadedClassesBatchSize() {
        return this.fReloadedClassesBatchSize.getIntegerValue();
    }

    public Integer getReloadedClassesBatchInterval() {
        return this.fReloadedClassesBatchInterval.getIntegerValue();
    }

    public Integer getPersistenceQueueClampSize() {
        return this.fPersistenceClampSize.getIntegerValue();
    }

    public Integer getPersistenceTraceDirectivesClampSize() {
        return this.fPersistenceTraceDirectivesClampSize.getIntegerValue();
    }

    public Integer getPersistenceBlacklistClampSize() {
        return this.fPersistenceBlacklistClampSize.getIntegerValue();
    }

    public Integer getPersistencyServiceFrequencyInterval() {
        return this.fPersistencyServiceFrequencyInterval.getIntegerValue();
    }

    public Integer getBoundaryDetectionThreadPoolSize() {
        return this.fBoundaryDetectionThreadPoolSize.getIntegerValue();
    }

    public void initVisibilityGapProcessor(IAgent fAgent2, Module kmodule) {
        if (this.fAgent != null) {
            int interval = this.fVisibilityProcessInterval * 60 * 1000;
            this.fVisibilityProcessorBehaviour = this.fAgent.IAgent_getConfigHeartbeat().addBehavior((ITimestampedRunnable)new VisibilityGapProcessor(this.fAgent, kmodule), "VisibilityGapProcessor", this.bVisibilityProcessorEnabled, (long)interval, false);
        }
    }

    public boolean isConfigInitialized() {
        return this.configInitialized;
    }

    public boolean isValidDecisionThresholdSet() {
        return this.fIsValidDecisionThresholdSetInProfile;
    }

    static {
        ignoreFlag = true;
        Flag = false;
    }

    final class MonitoreCandidateProcessorProperty
    extends IntegerConfigurationProperty {
        private MonitoreCandidateProcessorProperty(IAgent agent) {
            super("introscope.agent.deep.entrypoint.monitored.candidate.processor.intervalSeconds", Integer.valueOf(60), "Entry Point Detection Feature - frequency at which monitored candidate processor will be executed", "", false, false, agent.IAgent_getModuleFeedback(), IntelligentInstrumentationConfig.this.fModule, agent.IAgent_getStringLocalizer());
        }

        public void set(Object newValue) {
            FrontEndCandidateAnalyzer.setMonitoredCandidateProcessorInterval((long)((Integer)newValue).intValue());
        }
    }

    final class InitialCandidateProcessorProperty
    extends IntegerConfigurationProperty {
        private InitialCandidateProcessorProperty(IAgent agent) {
            super("introscope.agent.deep.entrypoint.initial.candidate.processor.intervalSeconds", Integer.valueOf(60), "Entry Point Detection Feature - frequency at which initial candidate processor will be executed", "", false, false, agent.IAgent_getModuleFeedback(), IntelligentInstrumentationConfig.this.fModule, agent.IAgent_getStringLocalizer());
        }

        public void set(Object newValue) {
            FrontEndCandidateAnalyzer.setInitialCandidateProcessorInterval((long)((Integer)newValue).intValue());
        }
    }

    final class FrontendCandidateTxCountProperty
    extends IntegerConfigurationProperty {
        private FrontendCandidateTxCountProperty(IAgent agent) {
            super("introscope.agent.deep.trace.entrypoint.candidate.transaction.count", IntelligentInstrumentationProperties.kEntrypointCandidateTxCountDefault, IntelligentInstrumentationConfig.this.fModuleFeedbackChannel, IntelligentInstrumentationConfig.this.fModule, agent.IAgent_getStringLocalizer());
        }

        public void set(Object newValue) {
            super.set(newValue);
            FrontEndCandidateAnalyzer.sFrontendCandidateTxCountThreshold = (Integer)newValue;
        }
    }

    final class FrontendPseudoCandidateInstrumentationThresholdProperty
    extends IntegerConfigurationProperty {
        private FrontendPseudoCandidateInstrumentationThresholdProperty(IAgent agent) {
            super("introscope.agent.deep.trace.entrypoint.pseudocandidate.instrumentation.threshold", IntelligentInstrumentationProperties.kEntrypointPseudoCandidateInstrumentationThresholdDefault, IntelligentInstrumentationConfig.this.fModuleFeedbackChannel, IntelligentInstrumentationConfig.this.fModule, agent.IAgent_getStringLocalizer());
        }

        public void set(Object newValue) {
            super.set(newValue);
            FrontEndCandidateAnalyzer.fPseudoCandidateInstrumentationTimeThreshold = ((Integer)newValue).intValue();
        }
    }

    final class FrontendCandidateInactivityThresholdProperty
    extends IntegerConfigurationProperty {
        private FrontendCandidateInactivityThresholdProperty(IAgent agent) {
            super("introscope.agent.deep.trace.entrypoint.candidate.inactivity.threshold", IntelligentInstrumentationProperties.kEntrypointCandidateInactivityThresholdDefault, IntelligentInstrumentationConfig.this.fModuleFeedbackChannel, IntelligentInstrumentationConfig.this.fModule, agent.IAgent_getStringLocalizer());
        }

        public void set(Object newValue) {
            super.set(newValue);
            FrontEndCandidateAnalyzer.fFrontendCandidateInactivityThreshold = ((Integer)newValue).intValue();
        }
    }

    final class FrontendCandidateStackDurationThresholdProperty
    extends IntegerConfigurationProperty {
        private FrontendCandidateStackDurationThresholdProperty(IAgent agent) {
            super("introscope.agent.deep.trace.entrypoint.candidate.stack.threshold", IntelligentInstrumentationProperties.kEntrypointCandidateStackDurationThresholdDefault, IntelligentInstrumentationConfig.this.fModuleFeedbackChannel, IntelligentInstrumentationConfig.this.fModule, agent.IAgent_getStringLocalizer());
        }

        public void set(Object newValue) {
            super.set(newValue);
            FrontEndCandidateAnalyzer.fFrontendCandidateStallThreshold = ((Integer)newValue).intValue();
        }
    }

    final class VisibilityProcessorIntervalProperty
    extends IntegerConfigurationProperty {
        private VisibilityProcessorIntervalProperty(IAgent agent) {
            super("introscope.agent.deep.instrumentation.visibility.processor.interval", IntelligentInstrumentationProperties.kVisibilityProcessorIntervalDefaultValue, IntelligentInstrumentationConfig.this.fModuleFeedbackChannel, IntelligentInstrumentationConfig.this.fModule, agent.IAgent_getStringLocalizer());
        }

        public void set(Object newValue) {
            IntelligentInstrumentationConfig.this.fVisibilityProcessInterval = (Integer)newValue;
            if (IntelligentInstrumentationConfig.this.fVisibilityProcessorBehaviour != null) {
                IntelligentInstrumentationConfig.this.fVisibilityProcessorBehaviour.IRegisteredBehavior_setPeriod((long)(IntelligentInstrumentationConfig.this.fVisibilityProcessInterval * 60 ^ 0x3E8));
            }
        }
    }

    final class VisibilityProcessorEnableProperty
    extends BooleanConfigurationProperty {
        private VisibilityProcessorEnableProperty(IAgent agent) {
            super("introscope.agent.deep.instrumentation.visibility.processor.enabled", IntelligentInstrumentationProperties.kVisibilityProcessorEnableDefault, IntelligentInstrumentationConfig.this.fModuleFeedbackChannel, IntelligentInstrumentationConfig.this.fModule, agent.IAgent_getStringLocalizer());
        }

        public void set(Object newValue) {
            IntelligentInstrumentationConfig.this.bVisibilityProcessorEnabled = (Boolean)newValue;
            HighPerformanceIntelligenceStackElement.setIsVisibilityGapProcessorEnabled((boolean)IntelligentInstrumentationConfig.this.bVisibilityProcessorEnabled);
            if (IntelligentInstrumentationConfig.this.fVisibilityProcessorBehaviour != null) {
                IntelligentInstrumentationConfig.this.fVisibilityProcessorBehaviour.IRegisteredBehavior_setEnableState(IntelligentInstrumentationConfig.this.bVisibilityProcessorEnabled);
            }
        }
    }

    private static class BoundaryDetectionThreadPoolSize
    extends IntegerProperty {
        public BoundaryDetectionThreadPoolSize(String name, Integer defaultValue, IModuleFeedbackChannel feedback, Module module, IStringLocalizer localizer) {
            super(name, defaultValue, feedback, module, localizer);
        }

        public boolean validate(Object value) {
            int intVal = (Integer)value;
            return intVal >= 1;
        }

        @Override
        public void set(Object newValue) {
            super.set(newValue);
        }
    }

    private static class RuntimeVisibilitySustainabilityMetricsProperty
    extends BooleanProperty {
        public RuntimeVisibilitySustainabilityMetricsProperty(String name, Boolean defaultValue, IModuleFeedbackChannel feedback, Module module, IStringLocalizer localizer) {
            super(name, defaultValue, feedback, module, localizer);
        }

        @Override
        public void set(Object newValue) {
            super.set(newValue);
            boolean enabled = SustainabilityService.areSustainabilityMetricsEnabled();
            SustainabilityMetricsHelper.setRuntimeVisibilitySustainabilityEnabled((enabled && this.getBooleanValue() ? 1 : 0) != 0);
        }
    }

    private static class EntryPointSustainabilityMetricsProperty
    extends BooleanProperty {
        public EntryPointSustainabilityMetricsProperty(String name, Boolean defaultValue, IModuleFeedbackChannel feedback, Module module, IStringLocalizer localizer) {
            super(name, defaultValue, feedback, module, localizer);
        }

        @Override
        public void set(Object newValue) {
            super.set(newValue);
            boolean enabled = SustainabilityService.areSustainabilityMetricsEnabled();
            SustainabilityMetricsHelper.setEntryPointSustainabilityEnabled((enabled && this.getBooleanValue() ? 1 : 0) != 0);
        }
    }

    private static class DeepTraceSustainabilityMetricsProperty
    extends BooleanProperty {
        public DeepTraceSustainabilityMetricsProperty(String name, Boolean defaultValue, IModuleFeedbackChannel feedback, Module module, IStringLocalizer localizer) {
            super(name, defaultValue, feedback, module, localizer);
        }

        @Override
        public void set(Object newValue) {
            super.set(newValue);
            boolean enabled = SustainabilityService.areSustainabilityMetricsEnabled();
            SustainabilityMetricsHelper.setDeepTraceSustainabilityEnabled((enabled && this.getBooleanValue() ? 1 : 0) != 0);
        }
    }

    private static class PersistenceServiceInterval
    extends IntegerProperty {
        public PersistenceServiceInterval(String name, Integer defaultValue, IModuleFeedbackChannel feedback, Module module, IStringLocalizer localizer) {
            super(name, defaultValue, feedback, module, localizer);
        }

        @Override
        public void set(Object newValue) {
            super.set(newValue);
        }
    }

    private static class PersistenceBlacklistClampSize
    extends IntegerProperty {
        public PersistenceBlacklistClampSize(String name, Integer defaultValue, IModuleFeedbackChannel feedback, Module module, IStringLocalizer localizer) {
            super(name, defaultValue, feedback, module, localizer);
        }

        @Override
        public void set(Object newValue) {
            super.set(newValue);
        }
    }

    private static class PersistenceTraceDirectivesClampSize
    extends IntegerProperty {
        public PersistenceTraceDirectivesClampSize(String name, Integer defaultValue, IModuleFeedbackChannel feedback, Module module, IStringLocalizer localizer) {
            super(name, defaultValue, feedback, module, localizer);
        }

        @Override
        public void set(Object newValue) {
            if ((Integer)newValue > IntelligentInstrumentationProperties.kMaxEntryPointTraceDirectivesHardLimit) {
                super.set(IntelligentInstrumentationProperties.kMaxEntryPointTraceDirectivesHardLimit);
            } else {
                super.set(newValue);
            }
        }
    }

    private static class PersistenceClampSize
    extends IntegerProperty {
        public PersistenceClampSize(String name, Integer defaultValue, IModuleFeedbackChannel feedback, Module module, IStringLocalizer localizer) {
            super(name, defaultValue, feedback, module, localizer);
        }

        @Override
        public void set(Object newValue) {
            super.set(newValue);
        }
    }

    private static class ReloadedClassesBatchInterval
    extends IntegerProperty {
        public ReloadedClassesBatchInterval(String name, Integer defaultValue, IModuleFeedbackChannel feedback, Module module, IStringLocalizer localizer) {
            super(name, defaultValue, feedback, module, localizer);
        }

        @Override
        public void set(Object newValue) {
            super.set(newValue);
        }
    }

    private static class ReloadedClassesBatchSize
    extends IntegerProperty {
        public ReloadedClassesBatchSize(String name, Integer defaultValue, IModuleFeedbackChannel feedback, Module module, IStringLocalizer localizer) {
            super(name, defaultValue, feedback, module, localizer);
        }

        @Override
        public void set(Object newValue) {
            super.set(newValue);
        }
    }

    private static class MaxTracedConsecutiveDeepComponentsProperty
    extends IntegerProperty {
        public MaxTracedConsecutiveDeepComponentsProperty(String name, Integer defaultValue, IModuleFeedbackChannel feedback, Module module, IStringLocalizer localizer) {
            super(name, defaultValue, feedback, module, localizer);
        }

        @Override
        public void set(Object newValue) {
            super.set(newValue);
            HighPerformanceIntelligenceStackElement.sMaxCountSinceLastInvocationData = this.getIntegerValue();
        }
    }

    private static class MaxTracedDeepComponentsProperty
    extends IntegerProperty {
        public MaxTracedDeepComponentsProperty(String name, Integer defaultValue, IModuleFeedbackChannel feedback, Module module, IStringLocalizer localizer) {
            super(name, defaultValue, feedback, module, localizer);
        }

        @Override
        public void set(Object newValue) {
            super.set(newValue);
            HighPerformanceIntelligenceStackElement.sMaxCount = this.getIntegerValue();
        }

        public boolean validate(Object value) {
            int intVal = (Integer)value;
            return intVal <= 10000;
        }
    }

    private class IntelligentInstrumentationLevelConfigurationProperty
    extends EnumConfigurationProperty {
        volatile int value;

        private IntelligentInstrumentationLevelConfigurationProperty(IAgent agent) {
            super("introscope.agent.deep.instrumentation.level", Integer.valueOf(0), IntelligentInstrumentationProperties.kInstrumentationLevelValidValues, IntelligentInstrumentationConfig.this.fModuleFeedbackChannel, IntelligentInstrumentationConfig.this.fModule, agent.IAgent_getStringLocalizer());
        }

        public void set(Object newValue) {
            previousInstrumentationLevelInt = this.value;
            this.value = (Integer)newValue;
            currentInstrumentationLevelInt = this.value;
            if (this.value == previousInstrumentationLevelInt) {
                return;
            }
            if (ignoreFlag.booleanValue()) {
                Flag = true;
                return;
            }
            IntelligentInstrumentationConfig.this.updateInstrumentationThresholdFromValue(this.value);
            if (startLevelChangeExecutor && IntelligentInstrumentationConfig.this.isInstrumentationLevelHotEnabled()) {
                LevelChangeExecutor.scheduleExecutor(IntelligentInstrumentationConfig.this.fAgent);
            }
        }
    }

    private class DecisionThresholdConfigurationProperty
    extends IntegerProperty {
        private DecisionThresholdConfigurationProperty(IAgent agent) {
            super("introscope.agent.deep.instrumentation.decisionthreshold", -1, IntelligentInstrumentationConfig.this.fModuleFeedbackChannel, IntelligentInstrumentationConfig.this.fModule, agent.IAgent_getStringLocalizer());
        }

        @Override
        public void set(Object newValue) {
            int val = (Integer)newValue;
            IntelligentInstrumentationConfig.this.fDecisionThresholdValue = val;
            if (val >= 0) {
                IntelligentInstrumentationConfig.this.fIsValidDecisionThresholdSetInProfile = true;
            }
        }
    }
}

