/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.blame;

import com.wily.introscope.agent.blame.VirtualStack;
import com.wily.introscope.agent.blame.VirtualStackCursor;
import com.wily.introscope.agent.remote.RemoteThread;
import com.wily.introscope.agent.trace.cas.IThreadLocalObjectFactory;
import com.wily.introscope.agent.trace.cas.ITransactionCacheProvider;
import com.wily.introscope.agent.trace.cas.ITransactionCacheProviderFactory;
import com.wily.introscope.agent.trace.cas.TransactionTransitionException;
import com.wily.introscope.agent.trace.hc2.WilyTransactionStructure;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;

public final class ThreadLocals {
    final RemoteThread thread;
    final Object connection;
    static final int TLO_COUNT = IThreadLocalObjectFactory.ThreadLocalFactories.values().length;
    private final Object[] tlo = new Object[TLO_COUNT];
    private static volatile boolean sUseExternalThreadId = false;
    private static final ThreadLocal<ExternalThreadId> sExternalThreadId = new ThreadLocal<ExternalThreadId>(){

        @Override
        public ExternalThreadId initialValue() {
            return new ExternalThreadId();
        }
    };
    private static final Map<String, ThreadLocals> sExternalThreadMap = new ConcurrentHashMap<String, ThreadLocals>();
    private static final ThreadLocal<ThreadLocals> sThreadLocals = new ThreadLocal<ThreadLocals>(){

        @Override
        protected ThreadLocals initialValue() {
            return new ThreadLocals(null, null);
        }
    };
    public static final ITransactionCacheProviderFactory sCacheProviderFactory;

    ThreadLocals(RemoteThread thread, Object connection) {
        this.thread = thread;
        this.connection = connection;
    }

    final <T> T rawGet(IThreadLocalObjectFactory.ThreadLocalFactories factory) {
        return (T)this.tlo[factory.ordinal()];
    }

    private static final ThreadLocals getThreadLocals() {
        if (sUseExternalThreadId) {
            ExternalThreadId etl = sExternalThreadId.get();
            String tid = etl.tid;
            if (tid != null && tid.length() != 0) {
                ThreadLocals e = sExternalThreadMap.get(tid);
                if (e == null) {
                    e = new ThreadLocals(new RemoteThread(tid), etl.conn);
                    sExternalThreadMap.put(tid, e);
                }
                return e;
            }
            VirtualStack.fAgent.IAgent_getModuleFeedback().debug(VirtualStack.kModule, "Using external thread id, but empty thread ID. Wil use real thread locals", new Throwable());
        }
        return sThreadLocals.get();
    }

    static final <T> T getThreadLocalObject(IThreadLocalObjectFactory.ThreadLocalFactories factory) {
        ThreadLocals threadLocals = ThreadLocals.getThreadLocals();
        int idx = factory.ordinal();
        Object obj = threadLocals.tlo[idx];
        if (obj != null) {
            return (T)obj;
        }
        threadLocals.tlo[idx] = factory.getFactory().makeNewThreadLocalObject(threadLocals.thread);
        return (T)threadLocals.tlo[idx];
    }

    static final <T> T getThreadLocalObjectOrNull(IThreadLocalObjectFactory.ThreadLocalFactories factory) {
        ThreadLocals threadLocals = ThreadLocals.getThreadLocals();
        int idx = factory.ordinal();
        return (T)threadLocals.tlo[idx];
    }

    public static Backup saveAside() {
        ThreadLocals threadLocals = ThreadLocals.getThreadLocals();
        Backup backup = new Backup(threadLocals);
        Arrays.fill(threadLocals.tlo, null);
        return backup;
    }

    static final VirtualStackCursor getStack() {
        return (VirtualStackCursor)ThreadLocals.getThreadLocalObject(IThreadLocalObjectFactory.ThreadLocalFactories.VirtualStackFactory);
    }

    static final VirtualStackCursor getStackOrNull() {
        return (VirtualStackCursor)ThreadLocals.getThreadLocalObjectOrNull(IThreadLocalObjectFactory.ThreadLocalFactories.VirtualStackFactory);
    }

    static final VirtualStack.AppMapCursor getAppMapStack() {
        return (VirtualStack.AppMapCursor)ThreadLocals.getThreadLocalObject(IThreadLocalObjectFactory.ThreadLocalFactories.AppMapStackFactory);
    }

    static final VirtualStack.AppMapCursor getAppMapStackOrNull() {
        return (VirtualStack.AppMapCursor)ThreadLocals.getThreadLocalObjectOrNull(IThreadLocalObjectFactory.ThreadLocalFactories.AppMapStackFactory);
    }

    static {
        IThreadLocalObjectFactory.ThreadLocalFactories.VirtualStackFactory.setFactory(new IThreadLocalObjectFactory(){

            @Override
            public Object makeNewThreadLocalObject(Runnable myThread) {
                return new VirtualStackCursor(myThread);
            }
        });
        IThreadLocalObjectFactory.ThreadLocalFactories.AppMapStackFactory.setFactory(new IThreadLocalObjectFactory(){

            @Override
            public Object makeNewThreadLocalObject(Runnable myThread) {
                return new VirtualStack.AppMapCursor();
            }
        });
        sCacheProviderFactory = new ITransactionCacheProviderFactory(){

            @Override
            public ITransactionCacheProvider getProvider() {
                return ThreadLocals.getStack();
            }

            @Override
            public void setUseExternalThreadId() {
                sUseExternalThreadId = true;
            }

            @Override
            public boolean isUseExternalThreadId() {
                return sUseExternalThreadId;
            }

            @Override
            public int getExternalThreadCount() {
                return sExternalThreadMap.size();
            }

            @Override
            public <T> T getExternalThreadLocalObject(IThreadLocalObjectFactory.ThreadLocalFactories factory) {
                return ThreadLocals.getThreadLocalObject(factory);
            }

            @Override
            public <T> T getExternalThreadLocalObjectOrNull(IThreadLocalObjectFactory.ThreadLocalFactories factory) {
                return ThreadLocals.getThreadLocalObjectOrNull(factory);
            }

            @Override
            public Object setExternalThreadLocalObject(IThreadLocalObjectFactory.ThreadLocalFactories factory, Object replacement) {
                int idx = factory.ordinal();
                ThreadLocals threadLocals = ThreadLocals.getThreadLocals();
                Object previousValue = threadLocals.tlo[idx];
                ((ThreadLocals)threadLocals).tlo[idx] = replacement;
                return previousValue;
            }

            @Override
            public boolean setExternalThreadId(String id, Object conn, boolean createIfNew) {
                boolean retval = true;
                ThreadLocals e = (ThreadLocals)sExternalThreadMap.get(id);
                if (e == null) {
                    if (createIfNew) {
                        e = new ThreadLocals(new RemoteThread(id), conn);
                    } else {
                        e = new ThreadLocals(new RemoteThread(id), null);
                        e.thread.kill();
                        retval = false;
                    }
                    sExternalThreadMap.put(id, e);
                }
                ExternalThreadId etl = (ExternalThreadId)sExternalThreadId.get();
                etl.tid = id;
                etl.conn = conn;
                return retval;
            }

            @Override
            public void clearExternalThread() {
                VirtualStackCursor vc;
                ExternalThreadId etl = (ExternalThreadId)sExternalThreadId.get();
                ThreadLocals ee = (ThreadLocals)sExternalThreadMap.get(etl.tid);
                if (ee != null && (vc = (VirtualStackCursor)ee.rawGet(IThreadLocalObjectFactory.ThreadLocalFactories.VirtualStackFactory)) != null && vc.data != null) {
                    WilyTransactionStructure.getInstance().abortTransaction(new TransactionTransitionException(""), vc.data);
                }
                if (ee != null && ee.thread instanceof RemoteThread) {
                    ee.thread.kill();
                }
                sExternalThreadMap.remove(etl.tid);
            }

            @Override
            public void clearExternalThread(Runnable thread) {
                if (!(thread instanceof RemoteThread)) {
                    return;
                }
                Iterator i = sExternalThreadMap.entrySet().iterator();
                while (i.hasNext()) {
                    Map.Entry e = i.next();
                    ThreadLocals ee = (ThreadLocals)e.getValue();
                    if (ee == null || !thread.equals(ee.thread)) continue;
                    ((RemoteThread)thread).kill();
                    i.remove();
                }
            }

            @Override
            public void invalidateThreadsFromConnection(Object conn) {
                Iterator i = sExternalThreadMap.entrySet().iterator();
                while (i.hasNext()) {
                    Map.Entry e = i.next();
                    ThreadLocals ee = (ThreadLocals)e.getValue();
                    if (ee == null || ee.connection != conn) continue;
                    VirtualStackCursor vc = (VirtualStackCursor)ee.rawGet(IThreadLocalObjectFactory.ThreadLocalFactories.VirtualStackFactory);
                    if (vc != null && vc.data != null) {
                        WilyTransactionStructure.getInstance().abortTransaction(new TransactionTransitionException(""), vc.data);
                    } else {
                        VirtualStack.abortTransaction();
                    }
                    if (ee.thread instanceof RemoteThread) {
                        ee.thread.kill();
                    }
                    i.remove();
                }
            }
        };
    }

    public static final class Backup {
        private final AtomicBoolean valid = new AtomicBoolean(true);
        private final Object[] tlo = new Object[TLO_COUNT];

        private Backup(ThreadLocals threadLocals) {
            System.arraycopy(threadLocals.tlo, 0, this.tlo, 0, TLO_COUNT);
        }

        public boolean isValid() {
            return this.valid.get();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void finishProcessing(Runnable job) {
            if (!this.valid.compareAndSet(true, false)) {
                throw new IllegalArgumentException("Backup was already processed/discarded, cannot process it second time");
            }
            Object[] temp = new Object[TLO_COUNT];
            ThreadLocals threadLocals = ThreadLocals.getThreadLocals();
            System.arraycopy(threadLocals.tlo, 0, temp, 0, TLO_COUNT);
            System.arraycopy(this.tlo, 0, threadLocals.tlo, 0, TLO_COUNT);
            try {
                job.run();
            }
            finally {
                System.arraycopy(temp, 0, threadLocals.tlo, 0, TLO_COUNT);
                Arrays.fill(this.tlo, null);
            }
        }

        public final void discard() {
            if (!this.valid.compareAndSet(true, false)) {
                throw new IllegalArgumentException("Backup was already processed/discarded, cannot discard it second time");
            }
            Arrays.fill(this.tlo, null);
        }
    }

    static final class ExternalThreadId {
        public String tid;
        public Object conn;

        ExternalThreadId() {
        }
    }
}

